/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.apache.commons.lang3.time.StopWatch;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.PrivateCellUtil;
import org.apache.hadoop.hbase.codec.Codec;
import org.apache.hadoop.hbase.codec.KeyValueCodec;
import org.apache.hadoop.hbase.io.SizedCellScanner;
import org.apache.hadoop.hbase.ipc.CellBlockBuilder;
import org.apache.hadoop.hbase.nio.ByteBuff;
import org.apache.hadoop.hbase.nio.SingleByteBuff;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.ClassSize;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.DefaultCodec;
import org.apache.hadoop.io.compress.GzipCodec;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={ClientTests.class, SmallTests.class})
public class TestCellBlockBuilder {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestCellBlockBuilder.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestCellBlockBuilder.class);
    private CellBlockBuilder builder;
    private static final String COUNT = "--count=";
    private static final String SIZE = "--size=";

    @Before
    public void before() {
        this.builder = new CellBlockBuilder(HBaseConfiguration.create());
    }

    @Test
    public void testBuildCellBlock() throws IOException {
        TestCellBlockBuilder.doBuildCellBlockUndoCellBlock(this.builder, (Codec)new KeyValueCodec(), null);
        TestCellBlockBuilder.doBuildCellBlockUndoCellBlock(this.builder, (Codec)new KeyValueCodec(), (CompressionCodec)new DefaultCodec());
        TestCellBlockBuilder.doBuildCellBlockUndoCellBlock(this.builder, (Codec)new KeyValueCodec(), (CompressionCodec)new GzipCodec());
    }

    static void doBuildCellBlockUndoCellBlock(CellBlockBuilder builder, Codec codec, CompressionCodec compressor) throws IOException {
        TestCellBlockBuilder.doBuildCellBlockUndoCellBlock(builder, codec, compressor, 10, 1, false);
    }

    static void doBuildCellBlockUndoCellBlock(CellBlockBuilder builder, Codec codec, CompressionCodec compressor, int count, int size, boolean sized) throws IOException {
        Cell[] cells = TestCellBlockBuilder.getCells(count, size);
        CellScanner cellScanner = sized ? TestCellBlockBuilder.getSizedCellScanner(cells) : CellUtil.createCellScanner(Arrays.asList(cells).iterator());
        ByteBuffer bb = builder.buildCellBlock(codec, compressor, cellScanner);
        cellScanner = builder.createCellScannerReusingBuffers(codec, compressor, (ByteBuff)new SingleByteBuff(bb));
        int i = 0;
        while (cellScanner.advance()) {
            ++i;
        }
        Assert.assertEquals((long)count, (long)i);
    }

    static CellScanner getSizedCellScanner(Cell[] cells) {
        int size = -1;
        for (Cell cell : cells) {
            size += PrivateCellUtil.estimatedSerializedSizeOf((Cell)cell);
        }
        final int totalSize = ClassSize.align((int)size);
        final CellScanner cellScanner = CellUtil.createCellScanner((Cell[])cells);
        return new SizedCellScanner(){

            public long heapSize() {
                return totalSize;
            }

            public Cell current() {
                return cellScanner.current();
            }

            public boolean advance() throws IOException {
                return cellScanner.advance();
            }
        };
    }

    static Cell[] getCells(int howMany) {
        return TestCellBlockBuilder.getCells(howMany, 1024);
    }

    static Cell[] getCells(int howMany, int valueSize) {
        Cell[] cells = new Cell[howMany];
        byte[] value = new byte[valueSize];
        for (int i = 0; i < howMany; ++i) {
            byte[] index = Bytes.toBytes((int)i);
            KeyValue kv = new KeyValue(index, Bytes.toBytes((String)"f"), index, value);
            cells[i] = kv;
        }
        return cells;
    }

    private static void usage(int errorCode) {
        System.out.println("Usage: IPCUtil [options]");
        System.out.println("Micro-benchmarking how changed sizes and counts work with buffer resizing");
        System.out.println(" --count  Count of Cells");
        System.out.println(" --size   Size of Cell values");
        System.out.println("Example: IPCUtil --count=1024 --size=1024");
        System.exit(errorCode);
    }

    private static void timerTests(CellBlockBuilder builder, int count, int size, Codec codec, CompressionCodec compressor) throws IOException {
        int i;
        int cycles = 1000;
        StopWatch timer = new StopWatch();
        timer.start();
        for (i = 0; i < 1000; ++i) {
            TestCellBlockBuilder.timerTest(builder, timer, count, size, codec, compressor, false);
        }
        timer.stop();
        LOG.info("Codec=" + codec + ", compression=" + compressor + ", sized=" + false + ", count=" + count + ", size=" + size + ", + took=" + timer.getTime() + "ms");
        timer.reset();
        timer.start();
        for (i = 0; i < 1000; ++i) {
            TestCellBlockBuilder.timerTest(builder, timer, count, size, codec, compressor, true);
        }
        timer.stop();
        LOG.info("Codec=" + codec + ", compression=" + compressor + ", sized=" + true + ", count=" + count + ", size=" + size + ", + took=" + timer.getTime() + "ms");
    }

    private static void timerTest(CellBlockBuilder builder, StopWatch timer, int count, int size, Codec codec, CompressionCodec compressor, boolean sized) throws IOException {
        TestCellBlockBuilder.doBuildCellBlockUndoCellBlock(builder, codec, compressor, count, size, sized);
    }

    public static void main(String[] args) throws IOException {
        int count = 1024;
        int size = 10240;
        for (String arg : args) {
            if (arg.startsWith(COUNT)) {
                count = Integer.parseInt(arg.replace(COUNT, ""));
                continue;
            }
            if (arg.startsWith(SIZE)) {
                size = Integer.parseInt(arg.replace(SIZE, ""));
                continue;
            }
            TestCellBlockBuilder.usage(1);
        }
        CellBlockBuilder builder = new CellBlockBuilder(HBaseConfiguration.create());
        TestCellBlockBuilder.timerTests(builder, count, size, (Codec)new KeyValueCodec(), null);
        TestCellBlockBuilder.timerTests(builder, count, size, (Codec)new KeyValueCodec(), (CompressionCodec)new DefaultCodec());
        TestCellBlockBuilder.timerTests(builder, count, size, (Codec)new KeyValueCodec(), (CompressionCodec)new GzipCodec());
    }
}

