/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.aead;

import com.google.crypto.tink.Aead;
import com.google.crypto.tink.PrimitiveSet;
import com.google.crypto.tink.PrimitiveWrapper;
import com.google.crypto.tink.Registry;
import com.google.crypto.tink.internal.MonitoringUtil;
import com.google.crypto.tink.internal.MutableMonitoringRegistry;
import com.google.crypto.tink.monitoring.MonitoringClient;
import com.google.crypto.tink.monitoring.MonitoringKeysetInfo;
import com.google.crypto.tink.subtle.Bytes;
import java.security.GeneralSecurityException;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;

public class AeadWrapper
implements PrimitiveWrapper<Aead, Aead> {
    private static final Logger logger = Logger.getLogger(AeadWrapper.class.getName());

    AeadWrapper() {
    }

    @Override
    public Aead wrap(PrimitiveSet<Aead> pset) throws GeneralSecurityException {
        return new WrappedAead(pset);
    }

    @Override
    public Class<Aead> getPrimitiveClass() {
        return Aead.class;
    }

    @Override
    public Class<Aead> getInputPrimitiveClass() {
        return Aead.class;
    }

    public static void register() throws GeneralSecurityException {
        Registry.registerPrimitiveWrapper(new AeadWrapper());
    }

    private static class WrappedAead
    implements Aead {
        private final PrimitiveSet<Aead> pSet;
        private final MonitoringClient.Logger encLogger;
        private final MonitoringClient.Logger decLogger;

        private WrappedAead(PrimitiveSet<Aead> pSet) {
            this.pSet = pSet;
            if (pSet.hasAnnotations()) {
                MonitoringClient client = MutableMonitoringRegistry.globalInstance().getMonitoringClient();
                MonitoringKeysetInfo keysetInfo = MonitoringUtil.getMonitoringKeysetInfo(pSet);
                this.encLogger = client.createLogger(keysetInfo, "aead", "encrypt");
                this.decLogger = client.createLogger(keysetInfo, "aead", "decrypt");
            } else {
                this.encLogger = MonitoringUtil.DO_NOTHING_LOGGER;
                this.decLogger = MonitoringUtil.DO_NOTHING_LOGGER;
            }
        }

        @Override
        public byte[] encrypt(byte[] plaintext, byte[] associatedData) throws GeneralSecurityException {
            try {
                byte[] output = Bytes.concat(this.pSet.getPrimary().getIdentifier(), this.pSet.getPrimary().getPrimitive().encrypt(plaintext, associatedData));
                this.encLogger.log(this.pSet.getPrimary().getKeyId(), plaintext.length);
                return output;
            }
            catch (GeneralSecurityException e) {
                this.encLogger.logFailure();
                throw e;
            }
        }

        @Override
        public byte[] decrypt(byte[] ciphertext, byte[] associatedData) throws GeneralSecurityException {
            if (ciphertext.length > 5) {
                byte[] prefix = Arrays.copyOf(ciphertext, 5);
                byte[] ciphertextNoPrefix = Arrays.copyOfRange(ciphertext, 5, ciphertext.length);
                List<PrimitiveSet.Entry<Aead>> entries = this.pSet.getPrimitive(prefix);
                for (PrimitiveSet.Entry<Aead> entry : entries) {
                    try {
                        byte[] result = entry.getPrimitive().decrypt(ciphertextNoPrefix, associatedData);
                        this.decLogger.log(entry.getKeyId(), ciphertextNoPrefix.length);
                        return result;
                    }
                    catch (GeneralSecurityException e) {
                        logger.info("ciphertext prefix matches a key, but cannot decrypt: " + e);
                    }
                }
            }
            List<PrimitiveSet.Entry<Aead>> entries = this.pSet.getRawPrimitives();
            for (PrimitiveSet.Entry<Aead> entry : entries) {
                try {
                    byte[] result = entry.getPrimitive().decrypt(ciphertext, associatedData);
                    this.decLogger.log(entry.getKeyId(), ciphertext.length);
                    return result;
                }
                catch (GeneralSecurityException e) {
                }
            }
            this.decLogger.logFailure();
            throw new GeneralSecurityException("decryption failed");
        }
    }
}

