/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.rdd;

import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.Partitioner;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkEnv;
import org.apache.spark.SparkEnv$;
import org.apache.spark.TaskContext;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.errors.SparkCoreErrors$;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.config.package$;
import org.apache.spark.io.CompressionCodec$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.ReliableCheckpointRDD;
import org.apache.spark.serializer.DeserializationStream;
import org.apache.spark.serializer.SerializationStream;
import org.apache.spark.serializer.SerializerInstance;
import org.apache.spark.util.SerializableConfiguration;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.control.NonFatal$;

public final class ReliableCheckpointRDD$
implements Logging,
scala.Serializable {
    public static ReliableCheckpointRDD$ MODULE$;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new ReliableCheckpointRDD$();
    }

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$(this, isInterpreter, silent);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public <T> Option<Partitioner> $lessinit$greater$default$3() {
        return None$.MODULE$;
    }

    public String org$apache$spark$rdd$ReliableCheckpointRDD$$checkpointFileName(int partitionIndex) {
        return new StringOps(Predef$.MODULE$.augmentString("part-%05d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)partitionIndex)}));
    }

    private String checkpointPartitionerFileName() {
        return "_partitioner";
    }

    public <T> ReliableCheckpointRDD<T> writeRDDToCheckpointDirectory(RDD<T> originalRDD, String checkpointDir, int blockSize, ClassTag<T> evidence$2) {
        long checkpointStartTimeNs = System.nanoTime();
        Path checkpointDirPath = new Path(checkpointDir);
        SparkContext sc = originalRDD.sparkContext();
        FileSystem fs = checkpointDirPath.getFileSystem(sc.hadoopConfiguration());
        if (!fs.mkdirs(checkpointDirPath)) {
            throw SparkCoreErrors$.MODULE$.failToCreateCheckpointPathError(checkpointDirPath);
        }
        Broadcast<SerializableConfiguration> broadcastedConf = sc.broadcast(new SerializableConfiguration(sc.hadoopConfiguration()), ClassTag$.MODULE$.apply(SerializableConfiguration.class));
        String string = checkpointDirPath.toString();
        int n = this.writePartitionToCheckpointFile$default$3();
        sc.runJob(originalRDD, (Function2 & Serializable & scala.Serializable)(ctx, iterator) -> {
            ReliableCheckpointRDD$.MODULE$.writePartitionToCheckpointFile(string, broadcastedConf, n, ctx, iterator, evidence$2);
            return BoxedUnit.UNIT;
        }, ClassTag$.MODULE$.Unit());
        if (originalRDD.partitioner().nonEmpty()) {
            this.writePartitionerToCheckpointDir(sc, (Partitioner)originalRDD.partitioner().get(), checkpointDirPath);
        }
        long checkpointDurationMs = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - checkpointStartTimeNs);
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(23).append("Checkpointing took ").append(checkpointDurationMs).append(" ms.").toString());
        ReliableCheckpointRDD<T> newRDD = new ReliableCheckpointRDD<T>(sc, checkpointDirPath.toString(), originalRDD.partitioner(), evidence$2);
        if (newRDD.partitions().length != originalRDD.partitions().length) {
            throw SparkCoreErrors$.MODULE$.checkpointRDDHasDifferentNumberOfPartitionsFromOriginalRDDError(originalRDD.id(), originalRDD.partitions().length, newRDD.id(), newRDD.partitions().length);
        }
        return newRDD;
    }

    public <T> int writeRDDToCheckpointDirectory$default$3() {
        return -1;
    }

    public <T> void writePartitionToCheckpointFile(String path, Broadcast<SerializableConfiguration> broadcastedConf, int blockSize, TaskContext ctx, Iterator<T> iterator, ClassTag<T> evidence$3) {
        Object object;
        SparkEnv env = SparkEnv$.MODULE$.get();
        Path outputDir = new Path(path);
        FileSystem fs = outputDir.getFileSystem(broadcastedConf.value().value());
        String finalOutputName = this.org$apache$spark$rdd$ReliableCheckpointRDD$$checkpointFileName(ctx.partitionId());
        Path finalOutputPath = new Path(outputDir, finalOutputName);
        Path tempOutputPath = new Path(outputDir, new StringBuilder(10).append(".").append(finalOutputName).append("-attempt-").append(ctx.taskAttemptId()).toString());
        int bufferSize = BoxesRunTime.unboxToInt((Object)env.conf().get(package$.MODULE$.BUFFER_SIZE()));
        if (blockSize < 0) {
            FSDataOutputStream fileStream = fs.create(tempOutputPath, false, bufferSize);
            object = BoxesRunTime.unboxToBoolean((Object)env.conf().get(package$.MODULE$.CHECKPOINT_COMPRESS())) ? CompressionCodec$.MODULE$.createCodec(env.conf()).compressedOutputStream((OutputStream)fileStream) : fileStream;
        } else {
            object = fs.create(tempOutputPath, false, bufferSize, fs.getDefaultReplication(fs.getWorkingDirectory()), (long)blockSize);
        }
        FSDataOutputStream fileOutputStream = object;
        SerializerInstance serializer = env.serializer().newInstance();
        SerializationStream serializeStream = serializer.serializeStream((OutputStream)fileOutputStream);
        Utils$.MODULE$.tryWithSafeFinallyAndFailureCallbacks((Function0 & Serializable & scala.Serializable)() -> serializeStream.writeAll(iterator, evidence$3), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            boolean deleted = fs.delete(tempOutputPath, false);
            if (!deleted) {
                MODULE$.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("Failed to delete tempOutputPath ").append(tempOutputPath).append(".").toString());
                return;
            }
        }, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> serializeStream.close());
        if (!fs.rename(tempOutputPath, finalOutputPath)) {
            if (!fs.exists(finalOutputPath)) {
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(24).append("Deleting tempOutputPath ").append(tempOutputPath).toString());
                fs.delete(tempOutputPath, false);
                throw SparkCoreErrors$.MODULE$.checkpointFailedToSaveError(ctx.attemptNumber(), finalOutputPath);
            }
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(53).append("Final output path ").append(finalOutputPath).append(" already exists; not overwriting it").toString());
            if (!fs.delete(tempOutputPath, false)) {
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(15).append("Error deleting ").append(tempOutputPath).toString());
                return;
            }
            return;
        }
    }

    public <T> int writePartitionToCheckpointFile$default$3() {
        return -1;
    }

    private void writePartitionerToCheckpointDir(SparkContext sc, Partitioner partitioner, Path checkpointDirPath) {
        try {
            Path partitionerFilePath = new Path(checkpointDirPath, this.checkpointPartitionerFileName());
            int bufferSize = BoxesRunTime.unboxToInt((Object)sc.conf().get(package$.MODULE$.BUFFER_SIZE()));
            FileSystem fs = partitionerFilePath.getFileSystem(sc.hadoopConfiguration());
            FSDataOutputStream fileOutputStream = fs.create(partitionerFilePath, false, bufferSize);
            SerializerInstance serializer = SparkEnv$.MODULE$.get().serializer().newInstance();
            SerializationStream serializeStream = serializer.serializeStream((OutputStream)fileOutputStream);
            Utils$.MODULE$.tryWithSafeFinally((Function0 & Serializable & scala.Serializable)() -> serializeStream.writeObject(partitioner, ClassTag$.MODULE$.apply(Partitioner.class)), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> serializeStream.close());
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(23).append("Written partitioner to ").append(partitionerFilePath).toString());
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(30).append("Error writing partitioner ").append(partitioner).append(" to ").append(checkpointDirPath).toString());
            }
            throw throwable;
        }
    }

    public Option<Partitioner> org$apache$spark$rdd$ReliableCheckpointRDD$$readCheckpointedPartitionerFile(SparkContext sc, String checkpointDirPath) {
        None$ none$;
        try {
            int bufferSize = BoxesRunTime.unboxToInt((Object)sc.conf().get(package$.MODULE$.BUFFER_SIZE()));
            Path partitionerFilePath = new Path(checkpointDirPath, this.checkpointPartitionerFileName());
            FileSystem fs = partitionerFilePath.getFileSystem(sc.hadoopConfiguration());
            FSDataInputStream fileInputStream = fs.open(partitionerFilePath, bufferSize);
            SerializerInstance serializer = SparkEnv$.MODULE$.get().serializer().newInstance();
            Partitioner partitioner = (Partitioner)Utils$.MODULE$.tryWithSafeFinally((Function0 & Serializable & scala.Serializable)() -> {
                DeserializationStream deserializeStream = serializer.deserializeStream((InputStream)fileInputStream);
                return (Partitioner)Utils$.MODULE$.tryWithSafeFinally((Function0 & Serializable & scala.Serializable)() -> (Partitioner)deserializeStream.readObject(ClassTag$.MODULE$.apply(Partitioner.class)), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> deserializeStream.close());
            }, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> fileInputStream.close());
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(22).append("Read partitioner from ").append(partitionerFilePath).toString());
            none$ = new Some((Object)partitioner);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof FileNotFoundException) {
                FileNotFoundException fileNotFoundException = (FileNotFoundException)throwable2;
                this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "No partitioner file", fileNotFoundException);
                none$ = None$.MODULE$;
            }
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(101).append("Error reading partitioner from ").append(checkpointDirPath).append(", ").append("partitioner will not be recovered which may lead to performance loss").toString(), e);
                none$ = None$.MODULE$;
            }
            throw throwable;
        }
        return none$;
    }

    public <T> Iterator<T> readCheckpointFile(Path path, Broadcast<SerializableConfiguration> broadcastedConf, TaskContext context2) {
        SparkEnv env = SparkEnv$.MODULE$.get();
        FileSystem fs = path.getFileSystem(broadcastedConf.value().value());
        int bufferSize = BoxesRunTime.unboxToInt((Object)env.conf().get(package$.MODULE$.BUFFER_SIZE()));
        FSDataInputStream fileStream = fs.open(path, bufferSize);
        FSDataInputStream fileInputStream = BoxesRunTime.unboxToBoolean((Object)env.conf().get(package$.MODULE$.CHECKPOINT_COMPRESS())) ? CompressionCodec$.MODULE$.createCodec(env.conf()).compressedInputStream((InputStream)fileStream) : fileStream;
        SerializerInstance serializer = env.serializer().newInstance();
        DeserializationStream deserializeStream = serializer.deserializeStream((InputStream)fileInputStream);
        context2.addTaskCompletionListener((Function1 & Serializable & scala.Serializable)context -> {
            deserializeStream.close();
            return BoxedUnit.UNIT;
        });
        return deserializeStream.asIterator();
    }

    private Object readResolve() {
        return MODULE$;
    }

    private ReliableCheckpointRDD$() {
        MODULE$ = this;
        Logging.$init$(this);
    }
}

