/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse.repl.dump.events;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Iterator;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.api.NotificationEvent;
import org.apache.hadoop.hive.metastore.messaging.AddPartitionMessage;
import org.apache.hadoop.hive.metastore.messaging.PartitionFiles;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.EximUtil;
import org.apache.hadoop.hive.ql.parse.repl.DumpType;
import org.apache.hadoop.hive.ql.parse.repl.dump.Utils;
import org.apache.hadoop.hive.ql.parse.repl.dump.events.AbstractEventHandler;
import org.apache.hadoop.hive.ql.parse.repl.dump.events.EventHandler;

class AddPartitionHandler
extends AbstractEventHandler {
    protected AddPartitionHandler(NotificationEvent notificationEvent) {
        super(notificationEvent);
    }

    @Override
    public void handle(EventHandler.Context withinContext) throws Exception {
        LOG.info("Processing#{} ADD_PARTITION message : {}", (Object)this.fromEventId(), (Object)this.event.getMessage());
        AddPartitionMessage apm = this.deserializer.getAddPartitionMessage(this.event.getMessage());
        org.apache.hadoop.hive.metastore.api.Table tobj = apm.getTableObj();
        if (tobj == null) {
            LOG.debug("Event#{} was a ADD_PTN_EVENT with no table listed");
            return;
        }
        Table qlMdTable = new Table(tobj);
        if (!Utils.shouldReplicate(withinContext.replicationSpec, qlMdTable, withinContext.hiveConf).booleanValue()) {
            return;
        }
        Iterable ptns = apm.getPartitionObjs();
        if (ptns == null || !ptns.iterator().hasNext()) {
            LOG.debug("Event#{} was an ADD_PTN_EVENT with no partitions");
            return;
        }
        Iterable qlPtns = StreamSupport.stream(ptns.spliterator(), true).map(input -> {
            if (input == null) {
                return null;
            }
            try {
                return new Partition(qlMdTable, (org.apache.hadoop.hive.metastore.api.Partition)input);
            }
            catch (HiveException e) {
                throw new IllegalArgumentException(e);
            }
        }).collect(Collectors.toList());
        Path metaDataPath = new Path(withinContext.eventRoot, "_metadata");
        EximUtil.createExportDump(metaDataPath.getFileSystem((Configuration)withinContext.hiveConf), metaDataPath, qlMdTable, qlPtns, withinContext.replicationSpec, withinContext.hiveConf);
        Iterator partitionFilesIter = apm.getPartitionFilesIter().iterator();
        for (Partition qlPtn : qlPtns) {
            Iterable files = ((PartitionFiles)partitionFilesIter.next()).getFiles();
            if (files == null) continue;
            BufferedWriter fileListWriter = this.writer(withinContext, qlPtn);
            Throwable throwable = null;
            try {
                for (String file : files) {
                    fileListWriter.write(file);
                    fileListWriter.newLine();
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (fileListWriter == null) continue;
                if (throwable != null) {
                    try {
                        fileListWriter.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                fileListWriter.close();
            }
        }
        withinContext.createDmd(this).write();
    }

    private BufferedWriter writer(EventHandler.Context withinContext, Partition qlPtn) throws IOException {
        Path ptnDataPath = new Path(withinContext.eventRoot, qlPtn.getName());
        FileSystem fs = ptnDataPath.getFileSystem((Configuration)withinContext.hiveConf);
        Path filesPath = new Path(ptnDataPath, "_files");
        return new BufferedWriter(new OutputStreamWriter((OutputStream)fs.create(filesPath)));
    }

    @Override
    public DumpType dumpType() {
        return DumpType.EVENT_ADD_PARTITION;
    }
}

