/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse.repl.dump.events;

import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.parse.ReplicationSpec;
import org.apache.hadoop.hive.ql.parse.repl.DumpType;
import org.apache.hadoop.hive.ql.parse.repl.load.DumpMetaData;

public interface EventHandler {
    public void handle(Context var1) throws Exception;

    public long fromEventId();

    public long toEventId();

    public DumpType dumpType();

    public static class Context {
        final Path eventRoot;
        final Path cmRoot;
        final Hive db;
        final HiveConf hiveConf;
        final ReplicationSpec replicationSpec;

        public Context(Path eventRoot, Path cmRoot, Hive db, HiveConf hiveConf, ReplicationSpec replicationSpec) {
            this.eventRoot = eventRoot;
            this.cmRoot = cmRoot;
            this.db = db;
            this.hiveConf = hiveConf;
            this.replicationSpec = replicationSpec;
        }

        DumpMetaData createDmd(EventHandler eventHandler) {
            return new DumpMetaData(this.eventRoot, eventHandler.dumpType(), eventHandler.fromEventId(), eventHandler.toEventId(), this.cmRoot, this.hiveConf);
        }
    }
}

