/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.statistics;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.statistics.IOStatistics;
import org.apache.hadoop.fs.statistics.IOStatisticsSnapshot;
import org.apache.hadoop.fs.statistics.IOStatisticsSource;
import org.apache.hadoop.fs.statistics.MeanStatistic;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public final class IOStatisticAssertions {
    private static final String COUNTER = "Counter";
    private static final String GAUGE = "Gauge";
    private static final String MINIMUM = "Minimum";
    private static final String MAXIMUM = "Maxiumum";
    private static final String MEAN = "Mean";

    private IOStatisticAssertions() {
    }

    public static long lookupCounterStatistic(IOStatistics stats, String key) {
        return (Long)IOStatisticAssertions.lookupStatistic(COUNTER, key, IOStatisticAssertions.verifyStatisticsNotNull(stats).counters());
    }

    public static <T extends IOStatistics> T verifyStatisticsNotNull(T stats) {
        ((ObjectAssert)Assertions.assertThat(stats).describedAs("IO Statistics reference", new Object[0])).isNotNull();
        return stats;
    }

    public static long lookupGaugeStatistic(IOStatistics stats, String key) {
        return (Long)IOStatisticAssertions.lookupStatistic(GAUGE, key, IOStatisticAssertions.verifyStatisticsNotNull(stats).gauges());
    }

    public static long lookupMaximumStatistic(IOStatistics stats, String key) {
        return (Long)IOStatisticAssertions.lookupStatistic(MAXIMUM, key, IOStatisticAssertions.verifyStatisticsNotNull(stats).maximums());
    }

    public static long lookupMinimumStatistic(IOStatistics stats, String key) {
        return (Long)IOStatisticAssertions.lookupStatistic(MINIMUM, key, IOStatisticAssertions.verifyStatisticsNotNull(stats).minimums());
    }

    public static MeanStatistic lookupMeanStatistic(IOStatistics stats, String key) {
        return (MeanStatistic)IOStatisticAssertions.lookupStatistic(MEAN, key, IOStatisticAssertions.verifyStatisticsNotNull(stats).meanStatistics());
    }

    private static <E> E lookupStatistic(String type, String key, Map<String, E> map) {
        E statistic = map.get(key);
        ((ObjectAssert)Assertions.assertThat(statistic).describedAs("%s named %s", new Object[]{type, key})).isNotNull();
        return statistic;
    }

    public static long verifyStatisticCounterValue(IOStatistics stats, String key, long value) {
        return IOStatisticAssertions.verifyStatisticValue(COUNTER, key, IOStatisticAssertions.verifyStatisticsNotNull(stats).counters(), value);
    }

    public static long verifyStatisticGaugeValue(IOStatistics stats, String key, long value) {
        return IOStatisticAssertions.verifyStatisticValue(GAUGE, key, IOStatisticAssertions.verifyStatisticsNotNull(stats).gauges(), value);
    }

    public static long verifyStatisticMaximumValue(IOStatistics stats, String key, long value) {
        return IOStatisticAssertions.verifyStatisticValue(MAXIMUM, key, IOStatisticAssertions.verifyStatisticsNotNull(stats).maximums(), value);
    }

    public static long verifyStatisticMinimumValue(IOStatistics stats, String key, long value) {
        return IOStatisticAssertions.verifyStatisticValue(MINIMUM, key, IOStatisticAssertions.verifyStatisticsNotNull(stats).minimums(), value);
    }

    public static MeanStatistic verifyStatisticMeanValue(IOStatistics stats, String key, MeanStatistic value) {
        return IOStatisticAssertions.verifyStatisticValue(MEAN, key, IOStatisticAssertions.verifyStatisticsNotNull(stats).meanStatistics(), value);
    }

    private static <E> E verifyStatisticValue(String type, String key, Map<String, E> map, E value) {
        E statistic = IOStatisticAssertions.lookupStatistic(type, key, map);
        ((ObjectAssert)Assertions.assertThat(statistic).describedAs("%s named %s with expected value %s", new Object[]{type, key, value})).isEqualTo(value);
        return statistic;
    }

    private static <E> ObjectAssert<E> assertThatStatistic(String type, String key, Map<String, E> map) {
        E statistic = IOStatisticAssertions.lookupStatistic(type, key, map);
        return (ObjectAssert)Assertions.assertThat(statistic).describedAs("%s named %s", new Object[]{type, key});
    }

    private static AbstractLongAssert<?> assertThatStatisticLong(String type, String key, Map<String, Long> map) {
        long statistic = IOStatisticAssertions.lookupStatistic(type, key, map);
        return (AbstractLongAssert)Assertions.assertThat((long)statistic).describedAs("%s named %s", new Object[]{type, key});
    }

    public static AbstractLongAssert<?> assertThatStatisticCounter(IOStatistics stats, String key) {
        return IOStatisticAssertions.assertThatStatisticLong(COUNTER, key, IOStatisticAssertions.verifyStatisticsNotNull(stats).counters());
    }

    public static AbstractLongAssert<?> assertThatStatisticGauge(IOStatistics stats, String key) {
        return IOStatisticAssertions.assertThatStatisticLong(GAUGE, key, IOStatisticAssertions.verifyStatisticsNotNull(stats).gauges());
    }

    public static AbstractLongAssert<?> assertThatStatisticMinimum(IOStatistics stats, String key) {
        return IOStatisticAssertions.assertThatStatisticLong(MINIMUM, key, IOStatisticAssertions.verifyStatisticsNotNull(stats).minimums());
    }

    public static AbstractLongAssert<?> assertThatStatisticMaximum(IOStatistics stats, String key) {
        return IOStatisticAssertions.assertThatStatisticLong(MAXIMUM, key, IOStatisticAssertions.verifyStatisticsNotNull(stats).maximums());
    }

    public static void assertDurationRange(IOStatistics stats, String key, long min, long max) {
        IOStatisticAssertions.assertThatStatisticMinimum(stats, key + ".min").isGreaterThanOrEqualTo(min);
        IOStatisticAssertions.assertThatStatisticMaximum(stats, key + ".max").isLessThanOrEqualTo(max);
    }

    public static ObjectAssert<MeanStatistic> assertThatStatisticMean(IOStatistics stats, String key) {
        return IOStatisticAssertions.assertThatStatistic(MEAN, key, IOStatisticAssertions.verifyStatisticsNotNull(stats).meanStatistics());
    }

    public static ObjectAssert<MeanStatistic> assertThatStatisticMeanMatches(IOStatistics stats, String key, long samples, long sum) {
        return (ObjectAssert)((ObjectAssert)IOStatisticAssertions.assertThatStatisticMean(stats, key).matches(p -> p.getSamples() == samples, "samples == " + samples)).matches(p -> p.getSum() == sum, "sum == " + sum);
    }

    private static void assertUntracked(IOStatistics stats, String type, String key, Map<String, ?> map) {
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)map.containsKey(key)).describedAs("%s %s is tracked in %s", new Object[]{type, key, stats})).isFalse();
    }

    private static void assertTracked(IOStatistics stats, String type, String key, Map<String, ?> map) {
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)map.containsKey(key)).describedAs("%s %s is not tracked in %s", new Object[]{type, key, stats})).isTrue();
    }

    public static void assertStatisticCounterIsTracked(IOStatistics stats, String key) {
        IOStatisticAssertions.assertTracked(stats, COUNTER, key, IOStatisticAssertions.verifyStatisticsNotNull(stats).counters());
    }

    public static void assertStatisticCounterIsUntracked(IOStatistics stats, String key) {
        IOStatisticAssertions.assertUntracked(stats, COUNTER, key, IOStatisticAssertions.verifyStatisticsNotNull(stats).counters());
    }

    public static void assertIsStatisticsSource(Object source) {
        ((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)source).describedAs("Object %s", new Object[]{source})).isInstanceOf(IOStatisticsSource.class)).extracting(o -> ((IOStatisticsSource)o).getIOStatistics()).isNotNull();
    }

    public static IOStatistics extractStatistics(Object source) {
        ((ObjectAssert)Assertions.assertThat((Object)source).describedAs("Object %s", new Object[]{source})).isInstanceOf(IOStatisticsSource.class);
        IOStatisticsSource ios = (IOStatisticsSource)source;
        return IOStatisticAssertions.extractStatistics(ios);
    }

    private static IOStatistics extractStatistics(IOStatisticsSource ioStatisticsSource) {
        IOStatistics statistics = ioStatisticsSource.getIOStatistics();
        ((ObjectAssert)Assertions.assertThat((Object)statistics).describedAs("Statistics from %s", new Object[]{ioStatisticsSource})).isNotNull();
        return statistics;
    }

    public static IOStatistics statisticsJavaRoundTrip(IOStatistics stat) throws IOException, ClassNotFoundException {
        IOStatistics deser;
        Assertions.assertThat((Object)stat).isInstanceOf(Serializable.class);
        ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
        try (ObjectOutputStream oos = new ObjectOutputStream(baos);){
            oos.writeObject(stat);
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        try (RestrictedInput ois = new RestrictedInput(bais, IOStatisticsSnapshot.requiredSerializationClasses());){
            deser = (IOStatistics)ois.readObject();
        }
        return deser;
    }

    private static final class RestrictedInput
    extends ObjectInputStream {
        private final List<String> allowedClasses;

        private RestrictedInput(InputStream in, List<Class> allowedClasses) throws IOException {
            super(in);
            this.allowedClasses = allowedClasses.stream().map(Class::getName).collect(Collectors.toList());
        }

        @Override
        protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
            String classname = desc.getName();
            if (!this.allowedClasses.contains(classname)) {
                throw new ClassNotFoundException("Class " + classname + " Not in list of allowed classes");
            }
            return super.resolveClass(desc);
        }
    }
}

