/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.tez.runtime;

import com.google.common.collect.Lists;
import com.google.common.primitives.Ints;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.TaskAttemptID;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.log4j.PropertyConfigurator;
import org.apache.pig.JVMReuseImpl;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigHadoopLogger;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigMapReduce;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.ProgressableReporter;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.UDFFinishVisitor;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.PhysicalOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.Result;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.POUserFunc;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhysicalPlan;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.util.PlanHelper;
import org.apache.pig.backend.hadoop.executionengine.shims.HadoopShims;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.udf.ReadScalarsTez;
import org.apache.pig.backend.hadoop.executionengine.tez.runtime.ObjectCache;
import org.apache.pig.backend.hadoop.executionengine.tez.runtime.TezInput;
import org.apache.pig.backend.hadoop.executionengine.tez.runtime.TezOutput;
import org.apache.pig.backend.hadoop.executionengine.tez.runtime.TezTaskConfigurable;
import org.apache.pig.backend.hadoop.executionengine.tez.runtime.TezTaskContext;
import org.apache.pig.data.SchemaTupleBackend;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.PigContext;
import org.apache.pig.impl.plan.DependencyOrderWalker;
import org.apache.pig.impl.plan.PlanWalker;
import org.apache.pig.impl.plan.VisitorException;
import org.apache.pig.impl.util.ObjectSerializer;
import org.apache.pig.impl.util.SpillableMemoryManager;
import org.apache.pig.impl.util.UDFContext;
import org.apache.pig.impl.util.Utils;
import org.apache.pig.tools.pigstats.PigStatusReporter;
import org.apache.tez.common.TezUtils;
import org.apache.tez.dag.api.UserPayload;
import org.apache.tez.mapreduce.hadoop.mapreduce.TaskAttemptContextImpl;
import org.apache.tez.mapreduce.output.MROutput;
import org.apache.tez.runtime.api.AbstractLogicalIOProcessor;
import org.apache.tez.runtime.api.Event;
import org.apache.tez.runtime.api.LogicalInput;
import org.apache.tez.runtime.api.LogicalOutput;
import org.apache.tez.runtime.api.ProcessorContext;
import org.apache.tez.runtime.api.events.VertexManagerEvent;
import org.apache.tez.runtime.library.api.KeyValueReader;

public class PigProcessor
extends AbstractLogicalIOProcessor {
    private static final Log LOG = LogFactory.getLog(PigProcessor.class);
    public static final String PLAN = "pig.exec.tez.plan";
    public static final String COMBINE_PLAN = "pig.exec.tez.combine.plan";
    public static final String ESTIMATE_PARALLELISM = "pig.exec.estimate.parallelism";
    public static final String ESTIMATED_NUM_PARALLELISM = "pig.exec.estimated.num.parallelism";
    public static final String SAMPLE_VERTEX = "pig.sampleVertex";
    public static final String SORT_VERTEX = "pig.sortVertex";
    private PhysicalPlan execPlan;
    private Set<MROutput> fileOutputs = new HashSet<MROutput>();
    private PhysicalOperator leaf;
    private Configuration conf;
    private PigHadoopLogger pigHadoopLogger;
    private Object progressHelper;
    public static String sampleVertex;
    public static Map<String, Object> sampleMap;
    private volatile boolean isAborted = false;

    public PigProcessor(ProcessorContext context) {
        super(context);
        ObjectCache.getInstance().setObjectRegistry(context.getObjectRegistry());
    }

    public void initialize() throws Exception {
        sampleVertex = null;
        sampleMap = null;
        new JVMReuseImpl().cleanupStaticData();
        PhysicalOperator.setReporter(new ProgressableReporter());
        UserPayload payload = this.getContext().getUserPayload();
        this.conf = TezUtils.createConfFromUserPayload((UserPayload)payload);
        SpillableMemoryManager.getInstance().configure(this.conf);
        PigContext.setPackageImportList((ArrayList)ObjectSerializer.deserialize(this.conf.get("udf.import.list")));
        Properties log4jProperties = (Properties)ObjectSerializer.deserialize(this.conf.get("pig.log4j.properties"));
        if (log4jProperties != null) {
            PropertyConfigurator.configure((Properties)log4jProperties);
        }
        this.conf.set("mapreduce.job.application.attempt.id", this.getContext().getUniqueIdentifier());
        boolean isMapperOutput = this.conf.getBoolean("tez.mapreduce.is_map_processor", false);
        TaskAttemptID taskAttemptId = TaskAttemptContextImpl.createMockTaskAttemptID((long)this.getContext().getApplicationId().getClusterTimestamp(), (int)this.getContext().getTaskVertexIndex(), (int)this.getContext().getApplicationId().getId(), (int)this.getContext().getTaskIndex(), (int)this.getContext().getTaskAttemptNumber(), (boolean)isMapperOutput);
        this.conf.set("mapreduce.task.attempt.id", taskAttemptId.toString());
        this.conf.set("mapreduce.task.id", taskAttemptId.getTaskID().toString());
        this.conf.setBoolean("mapreduce.task.ismap", isMapperOutput);
        this.conf.setInt("mapreduce.task.partition", taskAttemptId.getTaskID().getId());
        this.conf.set("mapreduce.job.id", taskAttemptId.getJobID().toString());
        if (this.conf.get("pig.inpLimits") != null) {
            this.conf.setInt("mapreduce.job.maps", this.getContext().getVertexParallelism());
        } else {
            this.conf.setInt("mapreduce.job.reduces", this.getContext().getVertexParallelism());
        }
        this.conf.set("mapreduce.task.index", Integer.toString(this.getContext().getTaskIndex()));
        UDFContext.getUDFContext().addJobConf(this.conf);
        UDFContext.getUDFContext().deserialize();
        String execPlanString = this.conf.get(PLAN);
        this.execPlan = (PhysicalPlan)ObjectSerializer.deserialize(execPlanString);
        SchemaTupleBackend.initialize(this.conf);
        PigMapReduce.sJobContext = HadoopShims.createJobContext(this.conf, new JobID());
        PigMapReduce.sJobConfInternal.set(this.conf);
        Utils.setDefaultTimeZone(this.conf);
        boolean aggregateWarning = "true".equalsIgnoreCase(this.conf.get("aggregate.warning"));
        PigStatusReporter pigStatusReporter = PigStatusReporter.getInstance();
        pigStatusReporter.setContext(new TezTaskContext(this.getContext()));
        this.pigHadoopLogger = PigHadoopLogger.getInstance();
        this.pigHadoopLogger.setReporter(pigStatusReporter);
        this.pigHadoopLogger.setAggregate(aggregateWarning);
        PhysicalOperator.setPigLogger(this.pigHadoopLogger);
        LinkedList<TezTaskConfigurable> tezTCs = PlanHelper.getPhysicalOperators(this.execPlan, TezTaskConfigurable.class);
        for (TezTaskConfigurable tezTC : tezTCs) {
            tezTC.initialize(this.getContext());
        }
    }

    public void handleEvents(List<Event> processorEvents) {
    }

    public void close() throws Exception {
        try {
            if (this.progressHelper != null) {
                Class<?> clazz = Class.forName("org.apache.tez.common.ProgressHelper");
                Method shutDownProgressTaskService = clazz.getMethod("shutDownProgressTaskService", new Class[0]);
                shutDownProgressTaskService.invoke(this.progressHelper, new Object[0]);
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
            // empty catch block
        }
        this.execPlan = null;
        this.fileOutputs = null;
        this.leaf = null;
        this.conf = null;
        sampleMap = null;
        sampleVertex = null;
        this.pigHadoopLogger = null;
        new JVMReuseImpl().cleanupStaticData();
        UDFContext.staticDataCleanup();
    }

    public void run(Map<String, LogicalInput> inputs, Map<String, LogicalOutput> outputs) throws Exception {
        try {
            Class<?> clazz = Class.forName("org.apache.tez.common.ProgressHelper");
            Constructor<?> ctor = clazz.getConstructor(Map.class, ProcessorContext.class, String.class);
            this.progressHelper = ctor.newInstance(inputs, this.getContext(), ((Object)((Object)this)).getClass().getSimpleName());
            Method scheduleProgressTaskService = clazz.getMethod("scheduleProgressTaskService", Long.TYPE, Long.TYPE);
            scheduleProgressTaskService.invoke(this.progressHelper, 100, Math.max(1000, this.conf.getInt("tez.task.am.heartbeat.interval-ms.max", 100) - 50));
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException clazz) {
            // empty catch block
        }
        try {
            this.initializeInputs(inputs);
            this.initializeOutputs(outputs);
            List leaves = null;
            if (!this.execPlan.isEmpty()) {
                leaves = this.execPlan.getLeaves();
                this.leaf = (PhysicalOperator)leaves.get(0);
            }
            LOG.info((Object)("Aliases being processed per job phase (AliasName[line,offset]): " + this.conf.get("pig.alias.location")));
            this.runPipeline(this.leaf);
            if (Boolean.valueOf(this.conf.get("pig.invoke.close.in.map", "false")).booleanValue() && !this.execPlan.endOfAllInput) {
                this.execPlan.endOfAllInput = true;
                this.runPipeline(this.leaf);
            }
            UDFFinishVisitor finisher = new UDFFinishVisitor(this.execPlan, (PlanWalker<PhysicalOperator, PhysicalPlan>)new DependencyOrderWalker<PhysicalOperator, PhysicalPlan>(this.execPlan));
            try {
                finisher.visit();
            }
            catch (VisitorException e) {
                int errCode = 2121;
                String msg = "Error while calling finish method on UDFs.";
                throw new VisitorException(msg, errCode, 4, (Throwable)e);
            }
            if (!this.fileOutputs.isEmpty()) {
                while (!this.getContext().canCommit() && !this.isAborted) {
                    Thread.sleep(100L);
                }
                if (this.isAborted) {
                    return;
                }
                for (MROutput fileOutput : this.fileOutputs) {
                    fileOutput.flush();
                    if (!fileOutput.isCommitRequired()) continue;
                    fileOutput.commit();
                }
            }
            if (this.conf.getBoolean(ESTIMATE_PARALLELISM, false)) {
                int parallelism = 1;
                if (sampleMap != null && sampleMap.containsKey(ESTIMATED_NUM_PARALLELISM)) {
                    parallelism = (Integer)sampleMap.get(ESTIMATED_NUM_PARALLELISM);
                }
                String sortingVertex = this.conf.get(SORT_VERTEX);
                LOG.info((Object)("Sending numParallelism " + parallelism + " to " + sortingVertex));
                VertexManagerEvent vmEvent = VertexManagerEvent.create((String)sortingVertex, (ByteBuffer)ByteBuffer.wrap(Ints.toByteArray((int)parallelism)));
                ArrayList events = Lists.newArrayListWithCapacity((int)1);
                events.add(vmEvent);
                this.getContext().sendEvents((List)events);
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Encountered exception while processing: ", (Throwable)e);
            this.abortOutput();
            throw e;
        }
    }

    private void abortOutput() {
        for (MROutput fileOutput : this.fileOutputs) {
            try {
                fileOutput.abort();
            }
            catch (Exception e) {
                LOG.error((Object)"Encountered exception while aborting output", (Throwable)e);
            }
        }
    }

    private void initializeInputs(Map<String, LogicalInput> inputs) throws Exception {
        HashSet<String> inputsToSkip = new HashSet<String>();
        sampleVertex = this.conf.get(SAMPLE_VERTEX);
        if (sampleVertex != null) {
            this.collectSample(sampleVertex, inputs.get(sampleVertex));
            inputsToSkip.add(sampleVertex);
        }
        LinkedList<TezInput> tezInputs = PlanHelper.getPhysicalOperators(this.execPlan, TezInput.class);
        for (TezInput tezInput : tezInputs) {
            tezInput.addInputsToSkip(inputsToSkip);
        }
        LinkedList<ReadScalarsTez> scalarInputs = new LinkedList<ReadScalarsTez>();
        for (POUserFunc pOUserFunc : PlanHelper.getPhysicalOperators(this.execPlan, POUserFunc.class)) {
            if (!(pOUserFunc.getFunc() instanceof ReadScalarsTez)) continue;
            scalarInputs.add((ReadScalarsTez)pOUserFunc.getFunc());
        }
        for (ReadScalarsTez readScalarsTez : scalarInputs) {
            readScalarsTez.addInputsToSkip(inputsToSkip);
        }
        for (Map.Entry entry : inputs.entrySet()) {
            if (inputsToSkip.contains(entry.getKey())) {
                LOG.info((Object)("Skipping fetch of input " + entry.getValue() + " from vertex " + (String)entry.getKey()));
                continue;
            }
            LOG.info((Object)("Starting fetch of input " + entry.getValue() + " from vertex " + (String)entry.getKey()));
            ((LogicalInput)entry.getValue()).start();
        }
        for (TezInput tezInput : tezInputs) {
            tezInput.attachInputs(inputs, this.conf);
        }
        for (ReadScalarsTez readScalarsTez : scalarInputs) {
            readScalarsTez.attachInputs(inputs, this.conf);
        }
    }

    private void initializeOutputs(Map<String, LogicalOutput> outputs) throws Exception {
        for (Map.Entry<String, LogicalOutput> entry : outputs.entrySet()) {
            LogicalOutput output = entry.getValue();
            LOG.info((Object)("Starting output " + output + " to vertex " + entry.getKey()));
            output.start();
            if (!(output instanceof MROutput)) continue;
            MROutput mrOut = (MROutput)output;
            this.fileOutputs.add(mrOut);
        }
        LinkedList<TezOutput> tezOuts = PlanHelper.getPhysicalOperators(this.execPlan, TezOutput.class);
        for (TezOutput tezOut : tezOuts) {
            tezOut.attachOutputs(outputs, this.conf);
        }
    }

    protected void runPipeline(PhysicalOperator leaf) throws IOException, InterruptedException {
        Result res;
        while (true) {
            res = leaf.getNextTuple();
            if (res.returnStatus == 0) continue;
            if (res.returnStatus == 3) {
                return;
            }
            if (res.returnStatus != 1 && res.returnStatus == 2) break;
        }
        String errMsg = res.result != null ? "Received Error while processing the map plan: " + res.result : "Received Error while processing the map plan.";
        int errCode = 2055;
        ExecException ee = new ExecException(errMsg, errCode, 4);
        throw ee;
    }

    private void collectSample(String sampleVertex, LogicalInput logicalInput) throws Exception {
        String quantileMapCacheKey = "sample-" + sampleVertex + ".quantileMap";
        sampleMap = (Map)ObjectCache.getInstance().retrieve(quantileMapCacheKey);
        if (sampleMap != null) {
            return;
        }
        LOG.info((Object)("Starting fetch of input " + logicalInput + " from vertex " + sampleVertex));
        logicalInput.start();
        KeyValueReader reader = (KeyValueReader)logicalInput.getReader();
        reader.next();
        Object val = reader.getCurrentValue();
        if (val != null) {
            Tuple t = (Tuple)val;
            sampleMap = (Map)t.get(0);
            ObjectCache.getInstance().cache(quantileMapCacheKey, sampleMap);
        } else {
            LOG.warn((Object)("Cannot fetch sample from " + sampleVertex));
        }
    }

    public void abort() {
        this.isAborted = true;
        LOG.warn((Object)"Aborting execution");
        this.abortOutput();
    }
}

