/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.worker.dlog;

import java.io.IOException;
import java.io.InputStream;
import org.apache.distributedlog.DLSN;
import org.apache.distributedlog.LogRecordWithDLSN;
import org.apache.distributedlog.api.DistributedLogManager;
import org.apache.distributedlog.api.LogReader;
import org.apache.distributedlog.exceptions.EndOfStreamException;

public class DLInputStream
extends InputStream {
    private LogRecordWithInputStream currentLogRecord = null;
    private final DistributedLogManager dlm;
    private LogReader reader;
    private boolean eos = false;

    public DLInputStream(DistributedLogManager dlm) throws IOException {
        this.dlm = dlm;
        this.reader = dlm.getInputStream(DLSN.InitialDLSN);
    }

    private LogRecordWithInputStream nextLogRecord() throws IOException {
        try {
            return DLInputStream.nextLogRecord(this.reader);
        }
        catch (EndOfStreamException e) {
            this.eos = true;
            return null;
        }
    }

    private static LogRecordWithInputStream nextLogRecord(LogReader reader) throws IOException {
        LogRecordWithDLSN record = reader.readNext(false);
        if (null != record) {
            return new LogRecordWithInputStream(record);
        }
        record = reader.readNext(false);
        if (null != record) {
            return new LogRecordWithInputStream(record);
        }
        return null;
    }

    @Override
    public int read() throws IOException {
        byte[] b = new byte[1];
        if (this.read(b, 0, 1) != 1) {
            return -1;
        }
        return b[0];
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.eos) {
            return -1;
        }
        int read = 0;
        if (this.currentLogRecord == null) {
            this.currentLogRecord = this.nextLogRecord();
            if (this.currentLogRecord == null) {
                return read;
            }
        }
        while (read < len) {
            int thisread = this.currentLogRecord.getPayLoadInputStream().read(b, off + read, len - read);
            if (thisread == -1) {
                this.currentLogRecord = this.nextLogRecord();
                if (this.currentLogRecord != null) continue;
                return read;
            }
            read += thisread;
        }
        return read;
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
        this.dlm.close();
    }

    private static class LogRecordWithInputStream {
        private final InputStream payloadStream;

        LogRecordWithInputStream(LogRecordWithDLSN logRecord) {
            this.payloadStream = logRecord.getPayLoadInputStream();
        }

        InputStream getPayLoadInputStream() {
            return this.payloadStream;
        }
    }
}

