/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.mledger.impl.cache;

import io.netty.util.IllegalReferenceCountException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.NavigableMap;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.atomic.AtomicLong;
import lombok.Generated;
import org.apache.bookkeeper.mledger.Position;
import org.apache.bookkeeper.mledger.ReferenceCountedEntry;
import org.apache.bookkeeper.mledger.impl.cache.RangeCacheEntryWrapper;
import org.apache.bookkeeper.mledger.impl.cache.RangeCacheRemovalCounters;
import org.apache.bookkeeper.mledger.impl.cache.RangeCacheRemovalQueue;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RangeCache {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RangeCache.class);
    private final ConcurrentNavigableMap<Position, RangeCacheEntryWrapper> entries;
    private final RangeCacheRemovalQueue removalQueue;
    private AtomicLong size;

    public RangeCache(RangeCacheRemovalQueue removalQueue) {
        this.removalQueue = removalQueue;
        this.entries = new ConcurrentSkipListMap<Position, RangeCacheEntryWrapper>();
        this.size = new AtomicLong(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean put(Position key, ReferenceCountedEntry value, int entryLength) {
        value.retain();
        try {
            boolean added;
            if (!value.matchesPosition(key)) {
                throw new IllegalArgumentException("Value '" + value + "' does not match key '" + key + "'");
            }
            boolean bl = added = RangeCacheEntryWrapper.withNewInstance(this, key, value, entryLength, newWrapper -> {
                if (this.entries.putIfAbsent(key, (RangeCacheEntryWrapper)newWrapper) == null && this.removalQueue.addEntry((RangeCacheEntryWrapper)newWrapper)) {
                    this.size.addAndGet(entryLength);
                    return true;
                }
                newWrapper.recycle();
                return false;
            }).booleanValue();
            return bl;
        }
        finally {
            value.release();
        }
    }

    public boolean put(Position key, ReferenceCountedEntry value) {
        return this.put(key, value, value.getLength());
    }

    public boolean exists(Position key) {
        return key != null ? this.entries.containsKey(key) : true;
    }

    public ReferenceCountedEntry get(Position key) {
        return this.getValueFromWrapper(key, (RangeCacheEntryWrapper)this.entries.get(key));
    }

    private ReferenceCountedEntry getValueFromWrapper(Position key, RangeCacheEntryWrapper valueWrapper) {
        if (valueWrapper == null) {
            return null;
        }
        ReferenceCountedEntry value = valueWrapper.getValue(key);
        return this.getRetainedValueMatchingKey(key, value);
    }

    private ReferenceCountedEntry getValueMatchingEntry(Map.Entry<Position, RangeCacheEntryWrapper> entry) {
        ReferenceCountedEntry valueMatchingEntry = RangeCacheEntryWrapper.getValueMatchingMapEntry(entry);
        return this.getRetainedValueMatchingKey(entry.getKey(), valueMatchingEntry);
    }

    private ReferenceCountedEntry getRetainedValueMatchingKey(Position key, ReferenceCountedEntry value) {
        if (value == null) {
            return null;
        }
        try {
            value.retain();
        }
        catch (IllegalReferenceCountException e) {
            return null;
        }
        if (value.refCnt() > 1 && value.matchesPosition(key)) {
            return value;
        }
        value.release();
        return null;
    }

    public Collection<ReferenceCountedEntry> getRange(Position first, Position last) {
        ArrayList<ReferenceCountedEntry> values = new ArrayList<ReferenceCountedEntry>();
        for (Map.Entry<Position, RangeCacheEntryWrapper> entry : this.entries.subMap((Object)first, true, (Object)last, true).entrySet()) {
            ReferenceCountedEntry value = this.getValueMatchingEntry(entry);
            if (value == null) continue;
            values.add(value);
        }
        return values;
    }

    public Pair<Integer, Long> removeRange(Position first, Position last, boolean lastInclusive) {
        if (log.isDebugEnabled()) {
            log.debug("Removing entries in range [{}, {}], lastInclusive: {}", new Object[]{first, last, lastInclusive});
        }
        RangeCacheRemovalCounters counters = RangeCacheRemovalCounters.create();
        NavigableMap subMap = this.entries.subMap((Object)first, true, (Object)last, lastInclusive);
        for (Map.Entry entry : subMap.entrySet()) {
            this.removeEntryWithWriteLock((Position)entry.getKey(), (RangeCacheEntryWrapper)entry.getValue(), counters);
        }
        return this.handleRemovalResult(counters);
    }

    boolean removeEntryWithWriteLock(Position expectedKey, RangeCacheEntryWrapper entryWrapper, RangeCacheRemovalCounters counters) {
        return entryWrapper.withWriteLock(e -> {
            if (e.key == null || e.key != expectedKey) {
                return false;
            }
            return this.removeEntry(e.key, e.value, (RangeCacheEntryWrapper)e, counters, false);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean removeEntry(Position key, ReferenceCountedEntry value, RangeCacheEntryWrapper entryWrapper, RangeCacheRemovalCounters counters, boolean updateSize) {
        this.entries.remove(key, entryWrapper);
        if (value == null) {
            return false;
        }
        try {
            value.retain();
        }
        catch (IllegalReferenceCountException e) {
            return false;
        }
        try {
            if (!value.matchesPosition(key)) {
                boolean e = false;
                return e;
            }
            long removedSize = entryWrapper.markRemoved(key, value);
            if (removedSize > -1L) {
                counters.entryRemoved(removedSize);
                if (updateSize) {
                    this.size.addAndGet(-removedSize);
                }
                if (value.refCnt() > 1) {
                    value.release();
                } else {
                    log.info("Unexpected refCnt {} for key {}, removed entry without releasing the value", (Object)value.refCnt(), (Object)key);
                }
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            value.release();
        }
    }

    private Pair<Integer, Long> handleRemovalResult(RangeCacheRemovalCounters counters) {
        this.size.addAndGet(-counters.removedSize);
        Pair result = Pair.of((Object)counters.removedEntries, (Object)counters.removedSize);
        counters.recycle();
        return result;
    }

    protected long getNumberOfEntries() {
        return this.entries.size();
    }

    public long getSize() {
        return this.size.get();
    }

    public Pair<Integer, Long> clear() {
        Map.Entry entry;
        if (log.isDebugEnabled()) {
            log.debug("Clearing the cache with {} entries and size {}", (Object)this.entries.size(), (Object)this.size.get());
        }
        RangeCacheRemovalCounters counters = RangeCacheRemovalCounters.create();
        while (!Thread.currentThread().isInterrupted() && (entry = this.entries.firstEntry()) != null) {
            this.removeEntryWithWriteLock((Position)entry.getKey(), (RangeCacheEntryWrapper)entry.getValue(), counters);
        }
        return this.handleRemovalResult(counters);
    }
}

