/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.mledger.impl.cache;

import io.netty.util.Recycler;

class RangeCacheRemovalCounters {
    private final Recycler.Handle<RangeCacheRemovalCounters> recyclerHandle;
    private static final Recycler<RangeCacheRemovalCounters> RECYCLER = new Recycler<RangeCacheRemovalCounters>(){

        protected RangeCacheRemovalCounters newObject(Recycler.Handle<RangeCacheRemovalCounters> recyclerHandle) {
            return new RangeCacheRemovalCounters(recyclerHandle);
        }
    };
    int removedEntries;
    long removedSize;

    private RangeCacheRemovalCounters(Recycler.Handle<RangeCacheRemovalCounters> recyclerHandle) {
        this.recyclerHandle = recyclerHandle;
    }

    static <T> RangeCacheRemovalCounters create() {
        RangeCacheRemovalCounters results = (RangeCacheRemovalCounters)RECYCLER.get();
        results.removedEntries = 0;
        results.removedSize = 0L;
        return results;
    }

    void recycle() {
        this.removedEntries = 0;
        this.removedSize = 0L;
        this.recyclerHandle.recycle((Object)this);
    }

    public void entryRemoved(long size) {
        this.removedSize += size;
        ++this.removedEntries;
    }
}

