/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service.resource.usage;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.apache.pulsar.broker.service.resource.usage.LightProtoCodec;
import org.apache.pulsar.broker.service.resource.usage.NetworkUsage;
import org.apache.pulsar.broker.service.resource.usage.StorageUsage;

public final class ResourceUsage {
    private String owner;
    private int _ownerBufferIdx = -1;
    private int _ownerBufferLen = -1;
    private static final int _OWNER_FIELD_NUMBER = 1;
    private static final int _OWNER_TAG = 10;
    private static final int _OWNER_TAG_SIZE = LightProtoCodec.computeVarIntSize(10);
    private static final int _OWNER_MASK = 1;
    private NetworkUsage publish;
    private static final int _PUBLISH_FIELD_NUMBER = 2;
    private static final int _PUBLISH_TAG = 18;
    private static final int _PUBLISH_TAG_SIZE = LightProtoCodec.computeVarIntSize(18);
    private static final int _PUBLISH_MASK = 2;
    private NetworkUsage dispatch;
    private static final int _DISPATCH_FIELD_NUMBER = 3;
    private static final int _DISPATCH_TAG = 26;
    private static final int _DISPATCH_TAG_SIZE = LightProtoCodec.computeVarIntSize(26);
    private static final int _DISPATCH_MASK = 4;
    private StorageUsage storage;
    private static final int _STORAGE_FIELD_NUMBER = 4;
    private static final int _STORAGE_TAG = 34;
    private static final int _STORAGE_TAG_SIZE = LightProtoCodec.computeVarIntSize(34);
    private static final int _STORAGE_MASK = 8;
    private int _bitField0;
    private static final int _REQUIRED_FIELDS_MASK0 = 1;
    private int _cachedSize;
    private ByteBuf _parsedBuffer;

    public boolean hasOwner() {
        return (this._bitField0 & 1) != 0;
    }

    public String getOwner() {
        if (!this.hasOwner()) {
            throw new IllegalStateException("Field 'owner' is not set");
        }
        if (this.owner == null) {
            this.owner = LightProtoCodec.readString(this._parsedBuffer, this._ownerBufferIdx, this._ownerBufferLen);
        }
        return this.owner;
    }

    public ResourceUsage setOwner(String owner) {
        this.owner = owner;
        this._bitField0 |= 1;
        this._ownerBufferIdx = -1;
        this._ownerBufferLen = LightProtoCodec.computeStringUTF8Size(owner);
        this._cachedSize = -1;
        return this;
    }

    public ResourceUsage clearOwner() {
        this._bitField0 &= 0xFFFFFFFE;
        this.owner = null;
        this._ownerBufferIdx = -1;
        this._ownerBufferLen = -1;
        return this;
    }

    public boolean hasPublish() {
        return (this._bitField0 & 2) != 0;
    }

    public NetworkUsage getPublish() {
        if (!this.hasPublish()) {
            throw new IllegalStateException("Field 'publish' is not set");
        }
        return this.publish;
    }

    public NetworkUsage setPublish() {
        if (this.publish == null) {
            this.publish = new NetworkUsage();
        }
        this._bitField0 |= 2;
        this._cachedSize = -1;
        return this.publish;
    }

    public ResourceUsage clearPublish() {
        this._bitField0 &= 0xFFFFFFFD;
        if (this.hasPublish()) {
            this.publish.clear();
        }
        return this;
    }

    public boolean hasDispatch() {
        return (this._bitField0 & 4) != 0;
    }

    public NetworkUsage getDispatch() {
        if (!this.hasDispatch()) {
            throw new IllegalStateException("Field 'dispatch' is not set");
        }
        return this.dispatch;
    }

    public NetworkUsage setDispatch() {
        if (this.dispatch == null) {
            this.dispatch = new NetworkUsage();
        }
        this._bitField0 |= 4;
        this._cachedSize = -1;
        return this.dispatch;
    }

    public ResourceUsage clearDispatch() {
        this._bitField0 &= 0xFFFFFFFB;
        if (this.hasDispatch()) {
            this.dispatch.clear();
        }
        return this;
    }

    public boolean hasStorage() {
        return (this._bitField0 & 8) != 0;
    }

    public StorageUsage getStorage() {
        if (!this.hasStorage()) {
            throw new IllegalStateException("Field 'storage' is not set");
        }
        return this.storage;
    }

    public StorageUsage setStorage() {
        if (this.storage == null) {
            this.storage = new StorageUsage();
        }
        this._bitField0 |= 8;
        this._cachedSize = -1;
        return this.storage;
    }

    public ResourceUsage clearStorage() {
        this._bitField0 &= 0xFFFFFFF7;
        if (this.hasStorage()) {
            this.storage.clear();
        }
        return this;
    }

    public int writeTo(ByteBuf _b) {
        this.checkRequiredFields();
        int _writeIdx = _b.writerIndex();
        LightProtoCodec.writeVarInt(_b, 10);
        LightProtoCodec.writeVarInt(_b, this._ownerBufferLen);
        if (this._ownerBufferIdx == -1) {
            LightProtoCodec.writeString(_b, this.owner, this._ownerBufferLen);
        } else {
            this._parsedBuffer.getBytes(this._ownerBufferIdx, _b, this._ownerBufferLen);
        }
        if (this.hasPublish()) {
            LightProtoCodec.writeVarInt(_b, 18);
            LightProtoCodec.writeVarInt(_b, this.publish.getSerializedSize());
            this.publish.writeTo(_b);
        }
        if (this.hasDispatch()) {
            LightProtoCodec.writeVarInt(_b, 26);
            LightProtoCodec.writeVarInt(_b, this.dispatch.getSerializedSize());
            this.dispatch.writeTo(_b);
        }
        if (this.hasStorage()) {
            LightProtoCodec.writeVarInt(_b, 34);
            LightProtoCodec.writeVarInt(_b, this.storage.getSerializedSize());
            this.storage.writeTo(_b);
        }
        return _b.writerIndex() - _writeIdx;
    }

    public int getSerializedSize() {
        if (this._cachedSize > -1) {
            return this._cachedSize;
        }
        int _size = 0;
        _size += _OWNER_TAG_SIZE;
        _size += LightProtoCodec.computeVarIntSize(this._ownerBufferLen);
        _size += this._ownerBufferLen;
        if (this.hasPublish()) {
            _size += LightProtoCodec.computeVarIntSize(18);
            int MsgsizePublish = this.publish.getSerializedSize();
            _size += LightProtoCodec.computeVarIntSize(MsgsizePublish) + MsgsizePublish;
        }
        if (this.hasDispatch()) {
            _size += LightProtoCodec.computeVarIntSize(26);
            int MsgsizeDispatch = this.dispatch.getSerializedSize();
            _size += LightProtoCodec.computeVarIntSize(MsgsizeDispatch) + MsgsizeDispatch;
        }
        if (this.hasStorage()) {
            _size += LightProtoCodec.computeVarIntSize(34);
            int MsgsizeStorage = this.storage.getSerializedSize();
            _size += LightProtoCodec.computeVarIntSize(MsgsizeStorage) + MsgsizeStorage;
        }
        this._cachedSize = _size;
        return _size;
    }

    public void parseFrom(ByteBuf _buffer, int _size) {
        this.clear();
        int _endIdx = _buffer.readerIndex() + _size;
        block6: while (_buffer.readerIndex() < _endIdx) {
            int _tag = LightProtoCodec.readVarInt(_buffer);
            switch (_tag) {
                case 10: {
                    this._bitField0 |= 1;
                    this._ownerBufferLen = LightProtoCodec.readVarInt(_buffer);
                    this._ownerBufferIdx = _buffer.readerIndex();
                    _buffer.skipBytes(this._ownerBufferLen);
                    continue block6;
                }
                case 18: {
                    this._bitField0 |= 2;
                    int publishSize = LightProtoCodec.readVarInt(_buffer);
                    this.setPublish().parseFrom(_buffer, publishSize);
                    continue block6;
                }
                case 26: {
                    this._bitField0 |= 4;
                    int dispatchSize = LightProtoCodec.readVarInt(_buffer);
                    this.setDispatch().parseFrom(_buffer, dispatchSize);
                    continue block6;
                }
                case 34: {
                    this._bitField0 |= 8;
                    int storageSize = LightProtoCodec.readVarInt(_buffer);
                    this.setStorage().parseFrom(_buffer, storageSize);
                    continue block6;
                }
            }
            LightProtoCodec.skipUnknownField(_tag, _buffer);
        }
        this.checkRequiredFields();
        this._parsedBuffer = _buffer;
    }

    private void checkRequiredFields() {
        if ((this._bitField0 & 1) != 1) {
            throw new IllegalStateException("Some required fields are missing");
        }
    }

    public ResourceUsage clear() {
        this.owner = null;
        this._ownerBufferIdx = -1;
        this._ownerBufferLen = -1;
        if (this.hasPublish()) {
            this.publish.clear();
        }
        if (this.hasDispatch()) {
            this.dispatch.clear();
        }
        if (this.hasStorage()) {
            this.storage.clear();
        }
        this._parsedBuffer = null;
        this._cachedSize = -1;
        this._bitField0 = 0;
        return this;
    }

    public ResourceUsage copyFrom(ResourceUsage _other) {
        this._cachedSize = -1;
        if (_other.hasOwner()) {
            this.setOwner(_other.getOwner());
        }
        if (_other.hasPublish()) {
            this.setPublish().copyFrom(_other.publish);
        }
        if (_other.hasDispatch()) {
            this.setDispatch().copyFrom(_other.dispatch);
        }
        if (_other.hasStorage()) {
            this.setStorage().copyFrom(_other.storage);
        }
        return this;
    }

    public byte[] toByteArray() {
        byte[] a = new byte[this.getSerializedSize()];
        ByteBuf b = Unpooled.wrappedBuffer((byte[])a).writerIndex(0);
        this.writeTo(b);
        return a;
    }

    public void parseFrom(byte[] a) {
        ByteBuf b = Unpooled.wrappedBuffer((byte[])a);
        this.parseFrom(b, b.readableBytes());
    }
}

