/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.compaction;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.apache.bookkeeper.mledger.Entry;
import org.apache.bookkeeper.mledger.ManagedCursor;
import org.apache.bookkeeper.mledger.Position;
import org.apache.bookkeeper.mledger.PositionFactory;
import org.apache.bookkeeper.mledger.util.ManagedLedgerUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.pulsar.compaction.TopicCompactionService;

public class CompactedTopicUtils {
    @Beta
    public static CompletableFuture<List<Entry>> asyncReadCompactedEntries(TopicCompactionService topicCompactionService, ManagedCursor cursor, int maxEntries, long bytesToRead, Position maxReadPosition, boolean readFromEarliest, boolean wait) {
        Objects.requireNonNull(topicCompactionService);
        Objects.requireNonNull(cursor);
        Preconditions.checkArgument((maxEntries > 0 ? 1 : 0) != 0);
        Position readPosition = readFromEarliest ? PositionFactory.EARLIEST : cursor.getReadPosition();
        CompletableFuture<Position> lastCompactedPositionFuture = topicCompactionService.getLastCompactedPosition();
        return lastCompactedPositionFuture.thenCompose(lastCompactedPosition -> {
            if (lastCompactedPosition == null || readPosition.compareTo(lastCompactedPosition.getLedgerId(), lastCompactedPosition.getEntryId()) > 0) {
                if (wait) {
                    return ManagedLedgerUtils.readEntriesWithSkipOrWait((ManagedCursor)cursor, (int)maxEntries, (long)bytesToRead, (Position)maxReadPosition, null);
                }
                return ManagedLedgerUtils.readEntries((ManagedCursor)cursor, (int)maxEntries, (long)bytesToRead, (Position)maxReadPosition);
            }
            int numberOfEntriesToRead = cursor.applyMaxSizeCap(maxEntries, bytesToRead);
            return topicCompactionService.readCompactedEntries(readPosition, numberOfEntriesToRead).thenApply(entries -> {
                if (CollectionUtils.isEmpty((Collection)entries)) {
                    Position seekToPosition = lastCompactedPosition.getNext();
                    if (readPosition.compareTo(seekToPosition.getLedgerId(), seekToPosition.getEntryId()) > 0) {
                        seekToPosition = readPosition;
                    }
                    cursor.seek(seekToPosition);
                    return entries;
                }
                long entriesSize = 0L;
                for (Entry entry : entries) {
                    entriesSize += (long)entry.getLength();
                }
                cursor.updateReadStats(entries.size(), entriesSize);
                Entry lastEntry = (Entry)entries.get(entries.size() - 1);
                cursor.seek(lastEntry.getPosition().getNext(), true);
                return entries;
            });
        });
    }
}

