/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.util;

import com.google.common.collect.Lists;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.distributedlog.DLMTestUtil;
import org.apache.distributedlog.LogSegmentMetadata;
import org.apache.distributedlog.exceptions.InvalidStreamNameException;
import org.apache.distributedlog.exceptions.UnexpectedException;
import org.apache.distributedlog.util.DLUtils;
import org.junit.Assert;
import org.junit.Test;

public class TestDLUtils {
    private static LogSegmentMetadata completedLogSegment(long logSegmentSequenceNumber, long fromTxnId, long toTxnId) {
        return TestDLUtils.completedLogSegment(logSegmentSequenceNumber, fromTxnId, toTxnId, LogSegmentMetadata.LEDGER_METADATA_CURRENT_LAYOUT_VERSION);
    }

    private static LogSegmentMetadata completedLogSegment(long logSegmentSequenceNumber, long fromTxnId, long toTxnId, int version) {
        return DLMTestUtil.completedLogSegment("/logsegment/" + fromTxnId, fromTxnId, fromTxnId, toTxnId, 100, logSegmentSequenceNumber, 999L, 0L, version);
    }

    private static LogSegmentMetadata inprogressLogSegment(long logSegmentSequenceNumber, long firstTxId) {
        return TestDLUtils.inprogressLogSegment(logSegmentSequenceNumber, firstTxId, LogSegmentMetadata.LEDGER_METADATA_CURRENT_LAYOUT_VERSION);
    }

    private static LogSegmentMetadata inprogressLogSegment(long logSegmentSequenceNumber, long firstTxId, int version) {
        return DLMTestUtil.inprogressLogSegment("/logsegment/" + firstTxId, firstTxId, firstTxId, logSegmentSequenceNumber, version);
    }

    @Test(timeout=60000L)
    public void testFindLogSegmentNotLessThanTxnId() throws Exception {
        long txnId = 999L;
        ArrayList emptyList = Lists.newArrayList();
        Assert.assertEquals((long)-1L, (long)DLUtils.findLogSegmentNotLessThanTxnId((List)emptyList, (long)txnId));
        ArrayList list1 = Lists.newArrayList((Object[])new LogSegmentMetadata[]{TestDLUtils.completedLogSegment(1L, 1000L, 2000L)});
        Assert.assertEquals((long)-1L, (long)DLUtils.findLogSegmentNotLessThanTxnId((List)list1, (long)txnId));
        ArrayList list2 = Lists.newArrayList((Object[])new LogSegmentMetadata[]{TestDLUtils.inprogressLogSegment(1L, 1000L)});
        Assert.assertEquals((long)-1L, (long)DLUtils.findLogSegmentNotLessThanTxnId((List)list2, (long)txnId));
        ArrayList list3 = Lists.newArrayList((Object[])new LogSegmentMetadata[]{TestDLUtils.completedLogSegment(1L, 0L, 99L), TestDLUtils.completedLogSegment(2L, 1000L, 2000L)});
        Assert.assertEquals((long)1L, (long)DLUtils.findLogSegmentNotLessThanTxnId((List)list3, (long)txnId));
        ArrayList list4 = Lists.newArrayList((Object[])new LogSegmentMetadata[]{TestDLUtils.completedLogSegment(1L, 0L, 990L), TestDLUtils.completedLogSegment(2L, 1000L, 2000L)});
        Assert.assertEquals((long)1L, (long)DLUtils.findLogSegmentNotLessThanTxnId((List)list4, (long)txnId));
        ArrayList list5 = Lists.newArrayList((Object[])new LogSegmentMetadata[]{TestDLUtils.inprogressLogSegment(1L, 0L), TestDLUtils.inprogressLogSegment(2L, 1000L)});
        Assert.assertEquals((long)0L, (long)DLUtils.findLogSegmentNotLessThanTxnId((List)list5, (long)txnId));
        ArrayList list6_0 = Lists.newArrayList((Object[])new LogSegmentMetadata[]{TestDLUtils.completedLogSegment(1L, 100L, 200L)});
        Assert.assertEquals((long)0L, (long)DLUtils.findLogSegmentNotLessThanTxnId((List)list6_0, (long)txnId));
        ArrayList list6_1 = Lists.newArrayList((Object[])new LogSegmentMetadata[]{TestDLUtils.completedLogSegment(1L, 100L, 199L), TestDLUtils.completedLogSegment(2L, 200L, 299L)});
        Assert.assertEquals((long)1L, (long)DLUtils.findLogSegmentNotLessThanTxnId((List)list6_1, (long)txnId));
        ArrayList list7 = Lists.newArrayList((Object[])new LogSegmentMetadata[]{TestDLUtils.inprogressLogSegment(1L, 100L)});
        Assert.assertEquals((long)0L, (long)DLUtils.findLogSegmentNotLessThanTxnId((List)list7, (long)txnId));
        ArrayList list8 = Lists.newArrayList((Object[])new LogSegmentMetadata[]{TestDLUtils.completedLogSegment(1L, 999L, 2000L)});
        Assert.assertEquals((long)0L, (long)DLUtils.findLogSegmentNotLessThanTxnId((List)list8, (long)txnId));
        ArrayList list9 = Lists.newArrayList((Object[])new LogSegmentMetadata[]{TestDLUtils.inprogressLogSegment(1L, 999L)});
        Assert.assertEquals((long)0L, (long)DLUtils.findLogSegmentNotLessThanTxnId((List)list9, (long)txnId));
        ArrayList list10 = Lists.newArrayList((Object[])new LogSegmentMetadata[]{TestDLUtils.completedLogSegment(1L, 0L, 999L), TestDLUtils.completedLogSegment(2L, 999L, 2000L)});
        Assert.assertEquals((long)0L, (long)DLUtils.findLogSegmentNotLessThanTxnId((List)list10, (long)txnId));
        ArrayList list11 = Lists.newArrayList((Object[])new LogSegmentMetadata[]{TestDLUtils.completedLogSegment(1L, 0L, 99L), TestDLUtils.completedLogSegment(2L, 999L, 2000L)});
        Assert.assertEquals((long)1L, (long)DLUtils.findLogSegmentNotLessThanTxnId((List)list11, (long)txnId));
        ArrayList list12 = Lists.newArrayList((Object[])new LogSegmentMetadata[]{TestDLUtils.inprogressLogSegment(1L, 0L), TestDLUtils.inprogressLogSegment(2L, 999L)});
        Assert.assertEquals((long)1L, (long)DLUtils.findLogSegmentNotLessThanTxnId((List)list12, (long)txnId));
    }

    @Test(timeout=60000L)
    public void testNextLogSegmentSequenceNumber() throws Exception {
        ArrayList v1List = Lists.newArrayList((Object[])new LogSegmentMetadata[]{TestDLUtils.completedLogSegment(2L, 100L, 199L, LogSegmentMetadata.LogSegmentMetadataVersion.VERSION_V1_ORIGINAL.value), TestDLUtils.completedLogSegment(1L, 0L, 99L, LogSegmentMetadata.LogSegmentMetadataVersion.VERSION_V1_ORIGINAL.value)});
        Assert.assertNull((Object)DLUtils.nextLogSegmentSequenceNumber((List)v1List));
        ArrayList afterV1List = Lists.newArrayList((Object[])new LogSegmentMetadata[]{TestDLUtils.completedLogSegment(2L, 100L, 199L), TestDLUtils.completedLogSegment(1L, 0L, 99L)});
        Assert.assertEquals((Object)3L, (Object)DLUtils.nextLogSegmentSequenceNumber((List)afterV1List));
        ArrayList mixList1 = Lists.newArrayList((Object[])new LogSegmentMetadata[]{TestDLUtils.completedLogSegment(2L, 100L, 199L, LogSegmentMetadata.LogSegmentMetadataVersion.VERSION_V1_ORIGINAL.value), TestDLUtils.completedLogSegment(1L, 0L, 99L)});
        Assert.assertEquals((Object)3L, (Object)DLUtils.nextLogSegmentSequenceNumber((List)mixList1));
        ArrayList mixList2 = Lists.newArrayList((Object[])new LogSegmentMetadata[]{TestDLUtils.completedLogSegment(2L, 100L, 199L), TestDLUtils.completedLogSegment(1L, 0L, 99L, LogSegmentMetadata.LogSegmentMetadataVersion.VERSION_V1_ORIGINAL.value)});
        Assert.assertEquals((Object)3L, (Object)DLUtils.nextLogSegmentSequenceNumber((List)mixList2));
    }

    @Test(timeout=60000L, expected=UnexpectedException.class)
    public void testUnexpectedExceptionOnComputeStartSequenceId() throws Exception {
        ArrayList segments = Lists.newArrayList((Object[])new LogSegmentMetadata[]{TestDLUtils.inprogressLogSegment(3L, 201L), TestDLUtils.inprogressLogSegment(2L, 101L), TestDLUtils.completedLogSegment(1L, 1L, 100L).mutator().setStartSequenceId(1L).build()});
        DLUtils.computeStartSequenceId((List)segments, (LogSegmentMetadata)((LogSegmentMetadata)segments.get(0)));
    }

    @Test(timeout=60000L)
    public void testComputeStartSequenceIdOnEmptyList() throws Exception {
        ArrayList emptyList = Lists.newArrayList();
        Assert.assertEquals((long)0L, (long)DLUtils.computeStartSequenceId((List)emptyList, (LogSegmentMetadata)TestDLUtils.inprogressLogSegment(1L, 1L)));
    }

    @Test(timeout=60000L)
    public void testComputeStartSequenceIdOnLowerSequenceNumberSegment() throws Exception {
        ArrayList segments = Lists.newArrayList((Object[])new LogSegmentMetadata[]{TestDLUtils.completedLogSegment(3L, 201L, 300L).mutator().setStartSequenceId(201L).build(), TestDLUtils.completedLogSegment(2L, 101L, 200L).mutator().setStartSequenceId(101L).build()});
        Assert.assertEquals((long)0L, (long)DLUtils.computeStartSequenceId((List)segments, (LogSegmentMetadata)TestDLUtils.inprogressLogSegment(1L, 1L)));
    }

    @Test(timeout=60000L)
    public void testComputeStartSequenceIdOnHigherSequenceNumberSegment() throws Exception {
        ArrayList segments = Lists.newArrayList((Object[])new LogSegmentMetadata[]{TestDLUtils.completedLogSegment(3L, 201L, 300L).mutator().setStartSequenceId(201L).build(), TestDLUtils.completedLogSegment(2L, 101L, 200L).mutator().setStartSequenceId(101L).build()});
        Assert.assertEquals((long)0L, (long)DLUtils.computeStartSequenceId((List)segments, (LogSegmentMetadata)TestDLUtils.inprogressLogSegment(5L, 401L)));
    }

    @Test(timeout=60000L)
    public void testComputeStartSequenceId() throws Exception {
        ArrayList segments = Lists.newArrayList((Object[])new LogSegmentMetadata[]{TestDLUtils.completedLogSegment(3L, 201L, 300L).mutator().setStartSequenceId(201L).setRecordCount(100).build(), TestDLUtils.completedLogSegment(2L, 101L, 200L).mutator().setStartSequenceId(101L).setRecordCount(100).build()});
        Assert.assertEquals((long)301L, (long)DLUtils.computeStartSequenceId((List)segments, (LogSegmentMetadata)TestDLUtils.inprogressLogSegment(4L, 301L)));
    }

    @Test(timeout=60000L)
    public void testSerDeLogSegmentSequenceNumber() throws Exception {
        long sn = 123456L;
        byte[] snData = Long.toString(sn).getBytes(StandardCharsets.UTF_8);
        Assert.assertEquals((String)"Deserialization should succeed", (long)sn, (long)DLUtils.deserializeLogSegmentSequenceNumber((byte[])snData));
        Assert.assertArrayEquals((String)"Serialization should succeed", (byte[])snData, (byte[])DLUtils.serializeLogSegmentSequenceNumber((long)sn));
    }

    @Test(timeout=60000L, expected=NumberFormatException.class)
    public void testDeserilizeInvalidLSSN() throws Exception {
        byte[] corruptedData = "corrupted-lssn".getBytes(StandardCharsets.UTF_8);
        DLUtils.deserializeLogSegmentSequenceNumber((byte[])corruptedData);
    }

    @Test(timeout=60000L)
    public void testSerDeLogRecordTxnId() throws Exception {
        long txnId = 123456L;
        byte[] txnData = Long.toString(txnId).getBytes(StandardCharsets.UTF_8);
        Assert.assertEquals((String)"Deserialization should succeed", (long)txnId, (long)DLUtils.deserializeTransactionId((byte[])txnData));
        Assert.assertArrayEquals((String)"Serialization should succeed", (byte[])txnData, (byte[])DLUtils.serializeTransactionId((long)txnId));
    }

    @Test(timeout=60000L, expected=NumberFormatException.class)
    public void testDeserilizeInvalidLogRecordTxnId() throws Exception {
        byte[] corruptedData = "corrupted-txn-id".getBytes(StandardCharsets.UTF_8);
        DLUtils.deserializeTransactionId((byte[])corruptedData);
    }

    @Test(timeout=60000L)
    public void testSerDeLedgerId() throws Exception {
        long ledgerId = 123456L;
        byte[] ledgerIdData = Long.toString(ledgerId).getBytes(StandardCharsets.UTF_8);
        Assert.assertEquals((String)"Deserialization should succeed", (long)ledgerId, (long)DLUtils.bytes2LogSegmentId((byte[])ledgerIdData));
        Assert.assertArrayEquals((String)"Serialization should succeed", (byte[])ledgerIdData, (byte[])DLUtils.logSegmentId2Bytes((long)ledgerId));
    }

    @Test(timeout=60000L, expected=NumberFormatException.class)
    public void testDeserializeInvalidLedgerId() throws Exception {
        byte[] corruptedData = "corrupted-ledger-id".getBytes(StandardCharsets.UTF_8);
        DLUtils.bytes2LogSegmentId((byte[])corruptedData);
    }

    @Test(timeout=10000L)
    public void testValidateLogName() throws Exception {
        String logName = "test-validate-log-name";
        DLUtils.validateAndNormalizeName((String)logName);
    }

    @Test(timeout=10000L, expected=InvalidStreamNameException.class)
    public void testValidateBadLogName0() throws Exception {
        String logName = "  test-bad-log-name";
        DLUtils.validateAndNormalizeName((String)logName);
    }

    @Test(timeout=10000L, expected=InvalidStreamNameException.class)
    public void testValidateBadLogName1() throws Exception {
        String logName = "test-bad-log-name/";
        DLUtils.validateAndNormalizeName((String)logName);
    }

    @Test(timeout=10000L, expected=InvalidStreamNameException.class)
    public void testValidateBadLogName2() throws Exception {
        String logName = "../test-bad-log-name/";
        DLUtils.validateAndNormalizeName((String)logName);
    }

    @Test(timeout=10000L)
    public void testValidateSameStreamPath() throws Exception {
        String logName1 = "/test-resolve-log";
        String logName2 = "test-resolve-log";
        DLUtils.validateAndNormalizeName((String)logName1);
        DLUtils.validateAndNormalizeName((String)logName2);
    }
}

