/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.mledger;

import java.util.Optional;
import org.apache.bookkeeper.common.annotation.InterfaceAudience;
import org.apache.bookkeeper.common.annotation.InterfaceStability;
import org.apache.bookkeeper.mledger.PositionFactory;

@InterfaceAudience.LimitedPrivate
@InterfaceStability.Stable
public interface Position
extends Comparable<Position> {
    public long getLedgerId();

    public long getEntryId();

    @Override
    default public int compareTo(Position that) {
        if (this.getLedgerId() != that.getLedgerId()) {
            return Long.compare(this.getLedgerId(), that.getLedgerId());
        }
        return Long.compare(this.getEntryId(), that.getEntryId());
    }

    default public int compareTo(long ledgerId, long entryId) {
        if (this.getLedgerId() != ledgerId) {
            return Long.compare(this.getLedgerId(), ledgerId);
        }
        return Long.compare(this.getEntryId(), entryId);
    }

    default public int hashCodeForPosition() {
        int result = Long.hashCode(this.getLedgerId());
        result = 31 * result + Long.hashCode(this.getEntryId());
        return result;
    }

    default public Position getNext() {
        if (this.getEntryId() < 0L) {
            return PositionFactory.create(this.getLedgerId(), 0L);
        }
        return PositionFactory.create(this.getLedgerId(), this.getEntryId() + 1L);
    }

    default public Position getPositionAfterEntries(int entryNum) {
        if (entryNum < 1) {
            return this;
        }
        if (this.getEntryId() < 0L) {
            return PositionFactory.create(this.getLedgerId(), entryNum - 1);
        }
        return PositionFactory.create(this.getLedgerId(), this.getEntryId() + (long)entryNum);
    }

    default public boolean hasExtension(Class<?> extensionClass) {
        return this.getExtension(extensionClass).isPresent();
    }

    default public <T> Optional<T> getExtension(Class<T> extensionClass) {
        return Optional.empty();
    }
}

