/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v1_0.messaging;

import java.util.ArrayList;
import java.util.List;
import org.apache.qpid.server.bytebuffer.QpidByteBuffer;
import org.apache.qpid.server.protocol.v1_0.codec.SectionDecoderRegistry;
import org.apache.qpid.server.protocol.v1_0.codec.ValueHandler;
import org.apache.qpid.server.protocol.v1_0.messaging.SectionDecoder;
import org.apache.qpid.server.protocol.v1_0.type.AmqpErrorException;
import org.apache.qpid.server.protocol.v1_0.type.messaging.EncodingRetainingSection;
import org.apache.qpid.server.protocol.v1_0.type.transport.AmqpError;

public class SectionDecoderImpl
implements SectionDecoder {
    private final ValueHandler _valueHandler;

    public SectionDecoderImpl(SectionDecoderRegistry describedTypeRegistry) {
        this._valueHandler = new ValueHandler(describedTypeRegistry);
    }

    @Override
    public List<EncodingRetainingSection<?>> parseAll(QpidByteBuffer buf) throws AmqpErrorException {
        ArrayList obj = new ArrayList();
        try {
            while (buf.hasRemaining()) {
                Object parsedObject = this._valueHandler.parse(buf);
                if (parsedObject instanceof EncodingRetainingSection) {
                    EncodingRetainingSection section = (EncodingRetainingSection)parsedObject;
                    obj.add(section);
                    continue;
                }
                throw new AmqpErrorException(AmqpError.DECODE_ERROR, String.format("Invalid Message: Expected type \"section\" but found \"%s\"", parsedObject.getClass().getSimpleName()), new Object[0]);
            }
        }
        catch (AmqpErrorException e) {
            for (EncodingRetainingSection encodingRetainingSection : obj) {
                encodingRetainingSection.dispose();
            }
            throw e;
        }
        return obj;
    }
}

