/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep.util.ldiff;

import com.sleepycat.je.rep.util.ldiff.Block;
import com.sleepycat.je.rep.util.ldiff.BlockBag;
import com.sleepycat.je.rep.util.ldiff.MismatchedRegion;
import com.sleepycat.je.rep.util.ldiff.Window;
import java.util.ArrayList;
import java.util.List;

public class DiffTracker {
    private Block startBlock;
    private long remoteStart;
    private long remoteDiffSize;
    private final long blockSize;
    private final List<MismatchedRegion> regions;

    public DiffTracker(long blockSize) {
        this.blockSize = blockSize;
        this.regions = new ArrayList<MismatchedRegion>();
    }

    public void setBlockDiffBegin(Block startBlock, int startIndex) {
        this.startBlock = startBlock;
        this.remoteStart = (long)startIndex * this.blockSize;
    }

    public void calBlockDiffSize(int currentIndex) {
        this.remoteDiffSize = (long)(currentIndex - 1) * this.blockSize - this.remoteStart;
    }

    public void addDiffRegion(Window window) {
        MismatchedRegion region = new MismatchedRegion();
        this.setBlockDiff(region, this.startBlock, this.remoteDiffSize, true);
        this.setWindowDiff(region, window, window.getDiffSize(), true);
        if (!region.isNull()) {
            this.regions.add(region);
        }
        this.remoteDiffSize = 0L;
    }

    private void setWindowDiff(MismatchedRegion region, Window window, long diffSize, boolean doCheck) {
        if (doCheck && window.getDiffSize() == 0L) {
            return;
        }
        region.setLocalBeginKey(window.getBeginKey());
        region.setLocalBeginData(window.getBeginData());
        region.setLocalDiffSize(diffSize);
    }

    private void setBlockDiff(MismatchedRegion region, Block block, long diffSize, boolean doCheck) {
        if (doCheck && this.remoteDiffSize == 0L) {
            return;
        }
        region.setRemoteBeginKey(block.getBeginKey());
        region.setRemoteBeginData(block.getBeginData());
        region.setRemoteDiffSize(diffSize);
    }

    public void addWindowAdditionalDiffs(Window window) {
        MismatchedRegion region = new MismatchedRegion();
        this.setWindowDiff(region, window, -1L, false);
        this.regions.add(region);
    }

    public void addBlockBagAdditionalDiffs(Window window, BlockBag blkBag) {
        MismatchedRegion region = new MismatchedRegion();
        this.setBlockDiff(region, blkBag.getBlock(), -1L, false);
        this.setWindowDiff(region, window, -1L, true);
        this.regions.add(region);
    }

    public List<MismatchedRegion> getDiffRegions() {
        return this.regions;
    }
}

