/*
 *
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 *
 */
package org.apache.qpid.server.logging;


import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;

public enum LogLevel
{
    ALL, TRACE, DEBUG, INFO, WARN, ERROR, OFF;

    public static Collection<String> validValues()
    {
        List<String> validValues = new ArrayList<>();
        for (LogLevel level : EnumSet.allOf(LogLevel.class))
        {
            validValues.add(level.name());
        }
        return validValues;
    }
}
