/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.client.impl;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.qpid.protonj2.buffer.ProtonBuffer;
import org.apache.qpid.protonj2.buffer.ProtonBufferAllocator;
import org.apache.qpid.protonj2.client.AdvancedMessage;
import org.apache.qpid.protonj2.client.Message;
import org.apache.qpid.protonj2.client.exceptions.ClientException;
import org.apache.qpid.protonj2.client.impl.ClientExceptionSupport;
import org.apache.qpid.protonj2.client.impl.ClientMessage;
import org.apache.qpid.protonj2.codec.CodecFactory;
import org.apache.qpid.protonj2.codec.Decoder;
import org.apache.qpid.protonj2.codec.DecoderState;
import org.apache.qpid.protonj2.codec.Encoder;
import org.apache.qpid.protonj2.codec.EncoderState;
import org.apache.qpid.protonj2.codec.SectionEncoder;
import org.apache.qpid.protonj2.engine.util.StringUtils;
import org.apache.qpid.protonj2.types.Binary;
import org.apache.qpid.protonj2.types.Symbol;
import org.apache.qpid.protonj2.types.messaging.AmqpSequence;
import org.apache.qpid.protonj2.types.messaging.AmqpValue;
import org.apache.qpid.protonj2.types.messaging.ApplicationProperties;
import org.apache.qpid.protonj2.types.messaging.Data;
import org.apache.qpid.protonj2.types.messaging.DeliveryAnnotations;
import org.apache.qpid.protonj2.types.messaging.Footer;
import org.apache.qpid.protonj2.types.messaging.Header;
import org.apache.qpid.protonj2.types.messaging.MessageAnnotations;
import org.apache.qpid.protonj2.types.messaging.Properties;
import org.apache.qpid.protonj2.types.messaging.Section;

public abstract class ClientMessageSupport {
    private static final Encoder DEFAULT_ENCODER = CodecFactory.getDefaultEncoder();
    private static final Decoder DEFAULT_DECODER = CodecFactory.getDefaultDecoder();
    private static final SectionEncoder SECTION_ENCODER = new SectionEncoder(DEFAULT_ENCODER);
    private static final int DEFAULT_BUFFER_ALLOCATION = 256;
    private static final ThreadLocal<EncoderState> THREAD_LOCAL_ENCODER_STATE = ThreadLocal.withInitial(() -> DEFAULT_ENCODER.newEncoderState());
    private static final ThreadLocal<DecoderState> THREAD_LOCAL_DECODER_STATE = ThreadLocal.withInitial(() -> DEFAULT_DECODER.newDecoderState());

    public static <E> AdvancedMessage<E> convertMessage(Message<E> message) throws ClientException {
        if (message instanceof AdvancedMessage) {
            return (AdvancedMessage)message;
        }
        try {
            return message.toAdvancedMessage();
        }
        catch (UnsupportedOperationException uoe) {
            return ClientMessageSupport.convertFromOutsideMessage(message);
        }
    }

    public static ProtonBuffer encodeSection(Section<?> section, ProtonBuffer buffer) {
        DEFAULT_ENCODER.writeObject(buffer, DEFAULT_ENCODER.newEncoderState(), section);
        return buffer;
    }

    public static ProtonBuffer encodeMessage(AdvancedMessage<?> message, Map<String, Object> deliveryAnnotations) throws ClientException {
        return ClientMessageSupport.encodeMessage(DEFAULT_ENCODER, THREAD_LOCAL_ENCODER_STATE.get(), ProtonBufferAllocator.defaultAllocator(), message, deliveryAnnotations);
    }

    public static ProtonBuffer encodeMessage(AdvancedMessage<?> message, Map<String, Object> deliveryAnnotations, ProtonBufferAllocator allocator) throws ClientException {
        return ClientMessageSupport.encodeMessage(DEFAULT_ENCODER, THREAD_LOCAL_ENCODER_STATE.get(), allocator, message, deliveryAnnotations);
    }

    public static ProtonBuffer encodeMessage(Encoder encoder, ProtonBufferAllocator allocator, AdvancedMessage<?> message, Map<String, Object> deliveryAnnotations) throws ClientException {
        return ClientMessageSupport.encodeMessage(encoder, encoder.newEncoderState(), allocator, message, deliveryAnnotations);
    }

    public static ProtonBuffer encodeMessage(Encoder encoder, EncoderState encoderState, ProtonBufferAllocator allocator, AdvancedMessage<?> message, Map<String, Object> deliveryAnnotations) throws ClientException {
        ProtonBuffer buffer = allocator.outputBuffer(256);
        Header header = message.header();
        MessageAnnotations messageAnnotations = message.annotations();
        Properties properties = message.properties();
        ApplicationProperties applicationProperties = message.applicationProperties();
        Footer footer = message.footer();
        if (header != null) {
            SECTION_ENCODER.write(buffer, header);
        }
        if (deliveryAnnotations != null) {
            SECTION_ENCODER.write(buffer, new DeliveryAnnotations(StringUtils.toSymbolKeyedMap(deliveryAnnotations)));
        }
        if (messageAnnotations != null) {
            SECTION_ENCODER.write(buffer, messageAnnotations);
        }
        if (properties != null) {
            SECTION_ENCODER.write(buffer, properties);
        }
        if (applicationProperties != null) {
            SECTION_ENCODER.write(buffer, applicationProperties);
        }
        message.forEachBodySection(section -> SECTION_ENCODER.write(buffer, section));
        if (footer != null) {
            SECTION_ENCODER.write(buffer, footer);
        }
        return buffer.convertToReadOnly();
    }

    public static Message<?> decodeMessage(ProtonBuffer buffer, Consumer<DeliveryAnnotations> daConsumer) throws ClientException {
        return ClientMessageSupport.decodeMessage(DEFAULT_DECODER, THREAD_LOCAL_DECODER_STATE.get(), buffer, daConsumer);
    }

    public static Message<?> decodeMessage(Decoder decoder, ProtonBuffer buffer, Consumer<DeliveryAnnotations> daConsumer) throws ClientException {
        return ClientMessageSupport.decodeMessage(decoder, decoder.newDecoderState(), buffer, daConsumer);
    }

    public static Message<?> decodeMessage(Decoder decoder, DecoderState decoderState, ProtonBuffer buffer, Consumer<DeliveryAnnotations> daConsumer) throws ClientException {
        ClientMessage message = new ClientMessage();
        Section section = null;
        block11: while (buffer.isReadable()) {
            try {
                section = (Section)decoder.readObject(buffer, decoderState);
            }
            catch (Exception e) {
                throw ClientExceptionSupport.createNonFatalOrPassthrough(e);
            }
            switch (section.getType()) {
                case Header: {
                    message.header((Header)section);
                    continue block11;
                }
                case DeliveryAnnotations: {
                    if (daConsumer == null) continue block11;
                    daConsumer.accept((DeliveryAnnotations)section);
                    continue block11;
                }
                case MessageAnnotations: {
                    message.annotations((MessageAnnotations)section);
                    continue block11;
                }
                case Properties: {
                    message.properties((Properties)section);
                    continue block11;
                }
                case ApplicationProperties: {
                    message.applicationProperties((ApplicationProperties)section);
                    continue block11;
                }
                case Data: 
                case AmqpSequence: 
                case AmqpValue: {
                    message.addBodySection(section);
                    continue block11;
                }
                case Footer: {
                    message.footer((Footer)section);
                    continue block11;
                }
            }
            throw new ClientException("Unknown Message Section forced decode abort.");
        }
        return message;
    }

    public static <E> Section<E> createSectionFromValue(E body) {
        if (body == null) {
            return null;
        }
        if (body instanceof byte[]) {
            return new Data((byte[])body);
        }
        if (body instanceof List) {
            return new AmqpSequence((List)body);
        }
        return new AmqpValue(body);
    }

    private static <E> ClientMessage<E> convertFromOutsideMessage(Message<E> source) throws ClientException {
        Footer footer;
        ApplicationProperties applicationProperties;
        MessageAnnotations messageAnnotations;
        Header header = new Header();
        header.setDurable(source.durable());
        header.setPriority(source.priority());
        header.setTimeToLive(source.timeToLive());
        header.setFirstAcquirer(source.firstAcquirer());
        header.setDeliveryCount(source.deliveryCount());
        Properties properties = new Properties();
        properties.setMessageId(source.messageId());
        properties.setUserId(source.userId() != null ? new Binary(source.userId()) : null);
        properties.setTo(source.to());
        properties.setSubject(source.subject());
        properties.setReplyTo(source.replyTo());
        properties.setCorrelationId(source.correlationId());
        properties.setContentType(source.contentType());
        properties.setContentEncoding(source.contentEncoding());
        properties.setAbsoluteExpiryTime(source.absoluteExpiryTime());
        properties.setCreationTime(source.creationTime());
        properties.setGroupId(source.groupId());
        properties.setGroupSequence(source.groupSequence());
        properties.setReplyToGroupId(source.replyToGroupId());
        if (source.hasAnnotations()) {
            messageAnnotations = new MessageAnnotations(new LinkedHashMap());
            source.forEachAnnotation((key, value) -> messageAnnotations.getValue().put(Symbol.valueOf((String)key), value));
        } else {
            messageAnnotations = null;
        }
        if (source.hasProperties()) {
            applicationProperties = new ApplicationProperties(new LinkedHashMap());
            source.forEachProperty((key, value) -> applicationProperties.getValue().put(key, value));
        } else {
            applicationProperties = null;
        }
        if (source.hasFooters()) {
            footer = new Footer(new LinkedHashMap());
            source.forEachFooter((key, value) -> footer.getValue().put(Symbol.valueOf((String)key), value));
        } else {
            footer = null;
        }
        ClientMessage<E> message = new ClientMessage<E>(ClientMessageSupport.createSectionFromValue(source.body()));
        message.header(header);
        message.properties(properties);
        message.annotations(messageAnnotations);
        message.applicationProperties(applicationProperties);
        message.footer(footer);
        return message;
    }
}

