/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.citation;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import org.apache.sis.metadata.internal.Dependencies;
import org.apache.sis.metadata.internal.shared.ImplementationHelper;
import org.apache.sis.metadata.iso.citation.AbstractParty;
import org.apache.sis.metadata.iso.citation.DefaultIndividual;
import org.apache.sis.metadata.iso.citation.DefaultOrganisation;
import org.apache.sis.metadata.iso.citation.DefaultResponsibility;
import org.apache.sis.metadata.iso.legacy.LegacyPropertyAdapter;
import org.apache.sis.util.iso.Types;
import org.opengis.metadata.citation.Contact;
import org.opengis.metadata.citation.ResponsibleParty;
import org.opengis.metadata.citation.Role;
import org.opengis.util.InternationalString;

@XmlType(name="CI_ResponsibleParty_Type", namespace="http://www.isotc211.org/2005/gmd", propOrder={"individualName", "organisationName", "positionName", "contactInfo", "role"})
@XmlRootElement(name="CI_ResponsibleParty", namespace="http://www.isotc211.org/2005/gmd")
public class DefaultResponsibleParty
extends DefaultResponsibility
implements ResponsibleParty {
    private static final long serialVersionUID = -1022635486627088812L;

    public DefaultResponsibleParty() {
    }

    public DefaultResponsibleParty(Role role) {
        super(role, null, null);
    }

    public DefaultResponsibleParty(DefaultResponsibility object) {
        super(object);
    }

    public DefaultResponsibleParty(ResponsibleParty object) {
        super(object);
        if (object != null && !(object instanceof DefaultResponsibility)) {
            this.setIndividualName(object.getIndividualName());
            this.setOrganisationName(object.getOrganisationName());
        }
    }

    public static DefaultResponsibleParty castOrCopy(ResponsibleParty object) {
        if (object == null || object instanceof DefaultResponsibleParty) {
            return (DefaultResponsibleParty)object;
        }
        return new DefaultResponsibleParty(object);
    }

    private InternationalString getIndividual(boolean position) {
        InternationalString name;
        block1: {
            Collection<AbstractParty> parties = this.getParties();
            name = DefaultResponsibleParty.getName(parties, DefaultIndividual.class, position);
            if (name != null || parties == null) break block1;
            for (AbstractParty party : parties) {
                if (party instanceof DefaultOrganisation && (name = DefaultResponsibleParty.getName(((DefaultOrganisation)party).getIndividual(), DefaultIndividual.class, position)) != null) break;
            }
        }
        return name;
    }

    private static InternationalString getName(Collection<? extends AbstractParty> parties, Class<? extends AbstractParty> type, boolean position) {
        InternationalString name = null;
        if (parties != null) {
            for (AbstractParty abstractParty : parties) {
                if (!type.isInstance(abstractParty)) continue;
                if (name != null) {
                    LegacyPropertyAdapter.warnIgnoredExtraneous(type, DefaultResponsibleParty.class, position ? "getPositionName" : (type == DefaultIndividual.class ? "getIndividualName" : "getOrganisationName"));
                    break;
                }
                name = position ? ((DefaultIndividual)abstractParty).getPositionName() : abstractParty.getName();
            }
        }
        return name;
    }

    private void setName(Class<? extends AbstractParty> type, boolean position, InternationalString name, Function<InternationalString, AbstractParty> creator) {
        Collection<AbstractParty> parties = this.getParties();
        this.checkWritePermission(ImplementationHelper.valueIfDefined(parties));
        if (parties != null) {
            Iterator<AbstractParty> it = parties.iterator();
            while (it.hasNext()) {
                AbstractParty party = it.next();
                if (!type.isInstance(party)) continue;
                if (position) {
                    ((DefaultIndividual)party).setPositionName(name);
                } else {
                    party.setName(name);
                }
                if (party.isEmpty()) {
                    it.remove();
                }
                return;
            }
        }
        if (name != null) {
            AbstractParty party = creator.apply(name);
            if (parties != null) {
                parties.add(party);
            } else {
                this.setParties(Collections.singletonList(party));
            }
        }
    }

    @Deprecated(since="1.0")
    @Dependencies(value={"getParties"})
    @XmlElement(name="individualName")
    public String getIndividualName() {
        InternationalString name = this.getIndividual(false);
        return name != null ? name.toString() : null;
    }

    @Deprecated(since="1.0")
    public void setIndividualName(String newValue) {
        this.setName(DefaultIndividual.class, false, Types.toInternationalString(newValue), DefaultResponsibleParty::individual);
    }

    private static AbstractParty individual(InternationalString name) {
        return new DefaultIndividual((CharSequence)name, null, null);
    }

    @Deprecated(since="1.0")
    @Dependencies(value={"getParties"})
    @XmlElement(name="organisationName")
    public InternationalString getOrganisationName() {
        return DefaultResponsibleParty.getName(this.getParties(), DefaultOrganisation.class, false);
    }

    @Deprecated(since="1.0")
    public void setOrganisationName(InternationalString newValue) {
        this.setName(DefaultOrganisation.class, false, newValue, DefaultResponsibleParty::organisation);
    }

    private static AbstractParty organisation(InternationalString name) {
        return new DefaultOrganisation((CharSequence)name, null, null, null);
    }

    @Deprecated(since="1.0")
    @Dependencies(value={"getParties"})
    @XmlElement(name="positionName")
    public InternationalString getPositionName() {
        return this.getIndividual(true);
    }

    @Deprecated(since="1.0")
    public void setPositionName(InternationalString newValue) {
        this.setName(DefaultIndividual.class, true, newValue, DefaultResponsibleParty::position);
    }

    private static AbstractParty position(InternationalString name) {
        return new DefaultIndividual(null, (CharSequence)name, null);
    }

    @Deprecated(since="1.0")
    @Dependencies(value={"getParties"})
    @XmlElement(name="contactInfo")
    public Contact getContactInfo() {
        Collection<AbstractParty> parties = this.getParties();
        if (parties != null) {
            for (AbstractParty party : parties) {
                Collection<Contact> contacts = party.getContactInfo();
                if (contacts == null) continue;
                for (Contact contact : contacts) {
                    if (contact == null) continue;
                    return contact;
                }
            }
        }
        return null;
    }

    @Deprecated(since="1.0")
    public void setContactInfo(Contact newValue) {
        Iterator<AbstractParty> it;
        Collection<AbstractParty> parties = this.getParties();
        this.checkWritePermission(ImplementationHelper.valueIfDefined(parties));
        if (parties != null && (it = parties.iterator()).hasNext()) {
            AbstractParty party = it.next();
            party.setContactInfo(newValue != null ? Collections.singleton(newValue) : null);
            if (party.isEmpty()) {
                it.remove();
            }
            return;
        }
        if (newValue != null) {
            DefaultIndividual party = new DefaultIndividual(null, null, newValue);
            if (parties != null) {
                parties.add(party);
            } else {
                this.setParties(Collections.singletonList(party));
            }
        }
    }

    @Override
    @XmlElement(name="role", required=true)
    public Role getRole() {
        return super.getRole();
    }

    @Override
    public void setRole(Role newValue) {
        super.setRole(newValue);
    }
}

