/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.factory;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.referencing.datum.DatumOrEnsemble;
import org.apache.sis.referencing.datum.DefaultDatumEnsemble;
import org.apache.sis.referencing.factory.AuthorityFactoryProxy;
import org.apache.sis.referencing.factory.GeodeticAuthorityFactory;
import org.apache.sis.referencing.internal.shared.FilteredIterator;
import org.apache.sis.referencing.internal.shared.LazySet;
import org.apache.sis.system.Semaphores;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.Disposable;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.collection.BackingStoreException;
import org.apache.sis.util.logging.Logging;
import org.opengis.metadata.Identifier;
import org.opengis.referencing.AuthorityFactory;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.datum.Datum;
import org.opengis.util.FactoryException;

public class IdentifiedObjectFinder {
    protected final AuthorityFactory factory;
    private transient AuthorityFactoryProxy<?> proxy;
    private IdentifiedObjectFinder wrapper;
    private Domain domain;
    private boolean ignoreAxes;

    protected IdentifiedObjectFinder(AuthorityFactory factory) {
        this.factory = Objects.requireNonNull(factory);
        this.domain = Domain.VALID_DATASET;
    }

    final void setWrapper(IdentifiedObjectFinder other) {
        this.wrapper = other;
        this.setSearchDomain(other.domain);
        this.setIgnoringAxes(other.ignoreAxes);
    }

    public Domain getSearchDomain() {
        return this.domain;
    }

    public void setSearchDomain(Domain domain) {
        this.domain = Objects.requireNonNull(domain);
    }

    public boolean isIgnoringAxes() {
        return this.ignoreAxes;
    }

    public void setIgnoringAxes(boolean ignore) {
        this.ignoreAxes = ignore;
    }

    private ComparisonMode getComparisonMode() {
        return this.ignoreAxes ? ComparisonMode.ALLOW_VARIANT : ComparisonMode.APPROXIMATE;
    }

    private static boolean match(IdentifiedObject candidate, IdentifiedObject object, ComparisonMode mode, AuthorityFactoryProxy<?> proxy) {
        if (Utilities.deepEquals((Object)candidate, (Object)object, (ComparisonMode)mode)) {
            return true;
        }
        if (Datum.class.isAssignableFrom(proxy.type)) {
            if (candidate instanceof Datum && object instanceof DefaultDatumEnsemble) {
                return DatumOrEnsemble.isLegacyDatum((DefaultDatumEnsemble)object, (Datum)candidate, mode);
            }
            if (candidate instanceof DefaultDatumEnsemble && object instanceof Datum) {
                return DatumOrEnsemble.isLegacyDatum((DefaultDatumEnsemble)candidate, (Datum)object, mode);
            }
        }
        return false;
    }

    Set<IdentifiedObject> getFromCache(IdentifiedObject object) {
        return this.wrapper != null ? this.wrapper.getFromCache(object) : null;
    }

    Set<IdentifiedObject> cache(IdentifiedObject object, Set<IdentifiedObject> result) {
        if (this.wrapper != null) {
            result = this.wrapper.cache(object, result);
        }
        return result;
    }

    public IdentifiedObject findSingleton(IdentifiedObject object) throws FactoryException {
        IdentifiedObject result = null;
        boolean sameAxisOrder = false;
        boolean ambiguous = false;
        try {
            for (IdentifiedObject candidate : this.find(object)) {
                boolean matchAxes;
                boolean bl = matchAxes = !this.ignoreAxes || Utilities.deepEquals((Object)candidate, (Object)object, (ComparisonMode)ComparisonMode.APPROXIMATE);
                if (result != null) {
                    ambiguous = true;
                    if (sameAxisOrder & matchAxes) {
                        return null;
                    }
                }
                result = candidate;
                sameAxisOrder = matchAxes;
            }
        }
        catch (BackingStoreException e) {
            throw (FactoryException)((Object)e.unwrapOrRethrow(FactoryException.class));
        }
        return sameAxisOrder || !ambiguous ? result : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<IdentifiedObject> find(IdentifiedObject object) throws FactoryException {
        Set<IdentifiedObject> result = this.getFromCache(Objects.requireNonNull(object));
        if (result == null) {
            try {
                AuthorityFactoryProxy<?> previousProxy = this.proxy;
                this.proxy = AuthorityFactoryProxy.getInstance(object.getClass());
                try {
                    result = this.createFromCodes(object);
                }
                finally {
                    this.proxy = previousProxy;
                }
                result = this.cache(object, result);
            }
            catch (BackingStoreException e) {
                throw (FactoryException)((Object)e.unwrapOrRethrow(FactoryException.class));
            }
        }
        return result;
    }

    Set<IdentifiedObject> createFromCodes(IdentifiedObject object) throws FactoryException {
        return new Instances(this, object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final IdentifiedObject createAndFilter(AuthorityFactory factory, String code, IdentifiedObject object) throws FactoryException {
        boolean finer = Semaphores.queryAndSet((int)32);
        try {
            IdentifiedObject candidate = (IdentifiedObject)this.proxy.createFromAPI(factory, code);
            IdentifiedObject identifiedObject = IdentifiedObjectFinder.match(candidate, object, this.getComparisonMode(), this.proxy) ? candidate : null;
            return identifiedObject;
        }
        finally {
            Semaphores.clearIfFalse((int)32, (boolean)finer);
        }
    }

    protected Iterable<String> getCodeCandidates(IdentifiedObject object) throws FactoryException {
        Class<IdentifiedObject> type = this.proxy.type.asSubclass(IdentifiedObject.class);
        if (this.domain == Domain.EXHAUSTIVE_VALID_DATASET) {
            return this.factory.getAuthorityCodes(type);
        }
        boolean easy = this.domain == Domain.DECLARATION;
        Set identifiers = object.getIdentifiers();
        if (identifiers.isEmpty()) {
            return easy ? Set.of() : this.factory.getAuthorityCodes(type);
        }
        return new Codes(this.factory, identifiers, easy ? null : type);
    }

    static void exceptionOccurred(FactoryException exception) {
        if (GeodeticAuthorityFactory.LOGGER.isLoggable(Level.FINER)) {
            Logging.completeAndLog((Logger)GeodeticAuthorityFactory.LOGGER, IdentifiedObjectFinder.class, (String)"find", (LogRecord)new LogRecord(Level.FINER, exception.getMessage()));
        }
    }

    public static enum Domain {
        DECLARATION,
        VALID_DATASET,
        EXHAUSTIVE_VALID_DATASET,
        ALL_DATASET;

    }

    private static final class Instances
    extends LazySet<IdentifiedObject>
    implements Function<String, IdentifiedObject> {
        private final AuthorityFactory factory;
        private final AuthorityFactoryProxy<?> proxy;
        private final Iterable<String> codes;
        private final ComparisonMode mode;
        private final Set<IdentifiedObject> existing;
        private final IdentifiedObject object;
        private boolean hasMatches;

        Instances(IdentifiedObjectFinder source, IdentifiedObject object) throws FactoryException {
            this.factory = source.factory;
            this.proxy = source.proxy;
            this.codes = source.getCodeCandidates(object);
            this.mode = source.getComparisonMode();
            this.existing = new HashSet<IdentifiedObject>();
            this.object = object;
        }

        @Override
        protected Iterator<IdentifiedObject> createSourceIterator() {
            return new FilteredIterator<String, IdentifiedObject>(this.codes.iterator(), this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IdentifiedObject apply(String code) {
            boolean finer = Semaphores.queryAndSet((int)32);
            try {
                IdentifiedObject candidate = (IdentifiedObject)this.proxy.createFromAPI(this.factory, code);
                if (IdentifiedObjectFinder.match(candidate, this.object, this.mode, this.proxy) && this.existing.add(candidate)) {
                    if (!this.hasMatches) {
                        this.hasMatches = true;
                        if (this.codes instanceof Disposable) {
                            ((Disposable)this.codes).dispose();
                        }
                    }
                    IdentifiedObject identifiedObject = candidate;
                    return identifiedObject;
                }
            }
            catch (FactoryException e) {
                IdentifiedObjectFinder.exceptionOccurred(e);
            }
            finally {
                Semaphores.clearIfFalse((int)32, (boolean)finer);
            }
            return null;
        }
    }

    private static final class Codes
    implements Iterable<String>,
    Function<ReferenceIdentifier, String>,
    Disposable {
        private final AuthorityFactory factory;
        private final Set<ReferenceIdentifier> identifiers;
        private Class<? extends IdentifiedObject> type;
        private Iterable<String> codes;

        Codes(AuthorityFactory factory, Set<ReferenceIdentifier> identifiers, Class<? extends IdentifiedObject> type) {
            this.factory = factory;
            this.identifiers = identifiers;
            this.type = type;
        }

        public void dispose() {
            this.type = null;
        }

        @Override
        public String apply(ReferenceIdentifier id) {
            String code = IdentifiedObjects.toString((Identifier)id);
            return code.indexOf(58) >= 0 ? code : null;
        }

        final Iterator<String> getIdentifiers() {
            return new FilteredIterator<ReferenceIdentifier, String>(this.identifiers.iterator(), this);
        }

        final Iterator<String> getAuthorityCodes() {
            if (this.codes == null) {
                if (this.type == null) {
                    this.codes = Set.of();
                } else {
                    try {
                        this.codes = this.factory.getAuthorityCodes(this.type);
                    }
                    catch (FactoryException e) {
                        throw new BackingStoreException((Throwable)e);
                    }
                }
            }
            return this.codes.iterator();
        }

        @Override
        public Iterator<String> iterator() {
            return new Iterator<String>(){
                private Iterator<String> codes;
                private boolean isCodeCandidates;
                {
                    this.codes = this.getIdentifiers();
                }

                @Override
                public boolean hasNext() {
                    if (!this.isCodeCandidates) {
                        if (this.codes.hasNext()) {
                            return true;
                        }
                        this.codes = this.getAuthorityCodes();
                        this.isCodeCandidates = true;
                    }
                    return this.codes.hasNext();
                }

                @Override
                public String next() {
                    if (!this.isCodeCandidates && !this.codes.hasNext()) {
                        this.codes = this.getAuthorityCodes();
                    }
                    return this.codes.next();
                }
            };
        }
    }

    public static abstract class Wrapper
    extends IdentifiedObjectFinder {
        private IdentifiedObjectFinder delegate;

        protected Wrapper(IdentifiedObjectFinder finder) {
            super(finder.factory);
            this.delegate = finder;
        }

        protected void delegate(IdentifiedObjectFinder finder) throws FactoryException {
            if (this.delegate != null) {
                this.delegate.wrapper = null;
            }
            this.delegate = Objects.requireNonNull(finder);
        }

        protected IdentifiedObjectFinder delegate() throws FactoryException {
            if (this.delegate != this) {
                this.delegate.setWrapper(this);
            }
            return this.delegate;
        }

        @Override
        public Set<IdentifiedObject> find(IdentifiedObject object) throws FactoryException {
            IdentifiedObjectFinder delegate = this.delegate();
            return delegate != this ? delegate.find(object) : super.find(object);
        }

        @Override
        public IdentifiedObject findSingleton(IdentifiedObject object) throws FactoryException {
            IdentifiedObjectFinder delegate = this.delegate();
            return delegate != this ? delegate.findSingleton(object) : super.findSingleton(object);
        }

        @Override
        Set<IdentifiedObject> createFromCodes(IdentifiedObject object) throws FactoryException {
            IdentifiedObjectFinder delegate = this.delegate();
            return delegate != this ? delegate.createFromCodes(object) : super.createFromCodes(object);
        }

        @Override
        protected Iterable<String> getCodeCandidates(IdentifiedObject object) throws FactoryException {
            IdentifiedObjectFinder delegate = this.delegate();
            return delegate != this ? delegate.getCodeCandidates(object) : super.getCodeCandidates(object);
        }
    }
}

