/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.esri;

import java.awt.image.ColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.NoSuchFileException;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import org.apache.sis.coverage.SampleDimension;
import org.apache.sis.coverage.grid.GridCoverage2D;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.coverage.internal.shared.RangeArgument;
import org.apache.sis.image.DataType;
import org.apache.sis.image.internal.shared.ColorModelBuilder;
import org.apache.sis.image.internal.shared.ColorModelFactory;
import org.apache.sis.image.internal.shared.ObservableImage;
import org.apache.sis.math.Statistics;
import org.apache.sis.measure.NumberRange;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.DataStoreProvider;
import org.apache.sis.storage.GridCoverageResource;
import org.apache.sis.storage.Resource;
import org.apache.sis.storage.StorageConnector;
import org.apache.sis.storage.base.MetadataBuilder;
import org.apache.sis.storage.base.PRJDataStore;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.internal.shared.Numerics;
import org.apache.sis.util.internal.shared.UnmodifiableArrayList;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.metadata.Metadata;
import org.opengis.metadata.maintenance.ScopeCode;

abstract class RasterStore
extends PRJDataStore
implements GridCoverageResource {
    private static final int VISIBLE_BAND = 0;
    static final String NROWS = "NROWS";
    static final String NCOLS = "NCOLS";
    static final String STX = "stx";
    static final String CLR = "clr";
    private ColorModel colorModel;
    private List<SampleDimension> sampleDimensions;
    double nodataValue = Double.NaN;
    Metadata metadata;
    private static final short[] RGB_BAND_NAMES = new short[]{167, 96, 18, 201};

    RasterStore(DataStoreProvider provider, StorageConnector connector) throws DataStoreException {
        super(provider, connector);
        this.listeners.useReadOnlyEvents();
    }

    @Override
    public Optional<Resource.FileSet> getFileSet() throws DataStoreException {
        return this.listComponentFiles("prj", STX, CLR);
    }

    final void createMetadata(String formatName, String formatKey) throws DataStoreException {
        GridGeometry gridGeometry = this.getGridGeometry();
        MetadataBuilder builder = new MetadataBuilder();
        builder.setPredefinedFormat(formatKey, this.listeners, true);
        builder.addFormatReaderSIS(this.provider != null ? this.provider.getShortName() : null);
        builder.addResourceScope(ScopeCode.valueOf((String)"COVERAGE"), null);
        builder.addLanguage(Locale.ENGLISH, this.encoding, MetadataBuilder.Scope.METADATA);
        builder.addSpatialRepresentation(null, gridGeometry, true);
        builder.addExtent(gridGeometry.getEnvelope(), this.listeners);
        if (this.sampleDimensions != null) {
            for (SampleDimension band : this.sampleDimensions) {
                builder.addNewBand(band);
            }
        }
        this.mergeAuxiliaryMetadata(RasterStore.class, builder);
        builder.addTitleOrIdentifier(this.getFilename(), MetadataBuilder.Scope.ALL);
        builder.setISOStandards(false);
        this.metadata = builder.buildAndFreeze();
    }

    private ColorModel readColorMap(int dataType, int mapSize, int numBands) throws DataStoreException, URISyntaxException, IOException {
        int maxSize;
        switch (dataType) {
            case 0: {
                maxSize = 255;
                break;
            }
            case 1: {
                maxSize = 65535;
                break;
            }
            default: {
                return null;
            }
        }
        int count = 0;
        long[] indexAndColors = ArraysExt.EMPTY_LONG;
        for (CharSequence line : CharSequences.splitOnEOL((CharSequence)this.readAuxiliaryFile(CLR, false))) {
            int end = CharSequences.skipTrailingWhitespaces((CharSequence)line, (int)0, (int)line.length());
            int start = CharSequences.skipLeadingWhitespaces((CharSequence)line, (int)0, (int)end);
            if (start >= end || !Character.isDigit(Character.codePointAt(line, start))) continue;
            int column = 0;
            long code = 0L;
            for (CharSequence item : CharSequences.split((CharSequence)line.subSequence(start, end), (char)' ')) {
                if (item.length() == 0) continue;
                int value = Integer.parseInt(item.toString());
                if (column == 0) {
                    code = (long)value << 32;
                } else {
                    value = Math.max(0, Math.min(255, value));
                    code |= (long)(value << (3 - column) * 8);
                }
                if (++column >= 4) break;
            }
            if (count >= indexAndColors.length) {
                indexAndColors = Arrays.copyOf(indexAndColors, Math.max(count * 2, 64));
            }
            indexAndColors[count++] = code | 0xFF000000L;
        }
        if (count <= 1) {
            return null;
        }
        Arrays.sort(indexAndColors, 0, count);
        int[] ARGB = new int[Math.max(mapSize, Math.toIntExact((indexAndColors[count - 1] >>> 32) + 1L))];
        int[] colors = new int[2];
        for (int i = 1; i < count; ++i) {
            int upper = (int)(indexAndColors[i] >>> 32);
            int lower = (int)(indexAndColors[i - 1] >>> 32);
            if (upper >= lower) {
                colors[0] = (int)indexAndColors[i - 1];
                colors[1] = (int)indexAndColors[i];
                ColorModelFactory.expand((int[])colors, (int[])ARGB, (int)lower, (int)(upper + 1));
            }
            if (upper <= maxSize) continue;
            ARGB = Arrays.copyOf(ARGB, maxSize + 1);
            break;
        }
        return ColorModelFactory.createIndexColorModel(null, (int)0, (int)numBands, (int)0, (int[])ARGB, (boolean)true, (int)-1);
    }

    private Statistics[] readStatistics(String name, SampleModel sm) throws DataStoreException, URISyntaxException, IOException {
        Statistics[] stats = new Statistics[sm.getNumBands()];
        for (CharSequence line : CharSequences.splitOnEOL((CharSequence)this.readAuxiliaryFile(STX, false))) {
            int end = CharSequences.skipTrailingWhitespaces((CharSequence)line, (int)0, (int)line.length());
            int start = CharSequences.skipLeadingWhitespaces((CharSequence)line, (int)0, (int)end);
            if (start >= end || !Character.isDigit(Character.codePointAt(line, start))) continue;
            int column = 0;
            int band = 0;
            double minimum = Double.NaN;
            double maximum = Double.NaN;
            double mean = Double.NaN;
            double stdev = Double.NaN;
            for (CharSequence item : CharSequences.split((CharSequence)line.subSequence(start, end), (char)' ')) {
                if (item.length() == 0) continue;
                if (column == 0) {
                    band = Integer.parseInt(item.toString());
                } else if (item.charAt(0) != '#') {
                    double value = Double.parseDouble(item.toString());
                    switch (column) {
                        case 1: {
                            minimum = value;
                            break;
                        }
                        case 2: {
                            maximum = value;
                            break;
                        }
                        case 3: {
                            mean = value;
                            break;
                        }
                        case 4: {
                            stdev = value;
                        }
                    }
                }
                ++column;
            }
            if (band < true || band > stats.length) continue;
            int count = Math.multiplyExact(sm.getWidth(), sm.getHeight());
            stats[band - 1] = new Statistics((CharSequence)name, 0, count, minimum, maximum, mean, stdev, false);
        }
        return stats;
    }

    final void loadBandDescriptions(String name, SampleModel sm, Statistics ... stats) throws DataStoreException {
        Object[] bands = new SampleDimension[sm.getNumBands()];
        try {
            stats = this.readStatistics(name, sm);
        }
        catch (IOException | NumberFormatException | URISyntaxException e) {
            this.cannotReadAuxiliaryFile(STX, e);
        }
        boolean isInteger = DataType.isInteger((SampleModel)sm);
        boolean isUnsigned = isInteger && DataType.isUnsigned((SampleModel)sm);
        boolean isRGB = isInteger && (bands.length == 3 || bands.length == 4);
        SampleDimension.Builder builder = new SampleDimension.Builder();
        for (int band = 0; band < bands.length; ++band) {
            Statistics s;
            double minimum = Double.NaN;
            double maximum = Double.NaN;
            if (band < stats.length && (s = stats[band]) != null) {
                minimum = s.minimum();
                maximum = s.maximum();
            }
            if (!(minimum <= maximum)) {
                minimum = 0.0;
                maximum = 1.0;
                if (isInteger) {
                    long max = Numerics.bitmask((int)sm.getSampleSize(band)) - 1L;
                    if (!isUnsigned) {
                        minimum = (max >>>= 1) ^ 0xFFFFFFFFFFFFFFFFL;
                    }
                    maximum = max;
                }
            }
            if (isRGB) {
                builder.setName((CharSequence)Vocabulary.formatInternational((short)RGB_BAND_NAMES[band]));
            } else {
                if (name != null) {
                    builder.setName((CharSequence)name);
                    name = null;
                }
                builder.addQuantitative(null, minimum, maximum, null);
                if (this.nodataValue < minimum || this.nodataValue > maximum) {
                    builder.mapQualitative(null, (Number)this.nodataValue, Float.NaN);
                }
            }
            bands[band] = builder.build().forConvertedValues(!isInteger);
            builder.clear();
            if (band != 0) continue;
            int dataType = sm.getDataType();
            try {
                this.colorModel = isRGB ? new ColorModelBuilder().createRGB(sm) : this.readColorMap(dataType, (int)(maximum + 1.0), bands.length);
            }
            catch (IOException | IllegalArgumentException | URISyntaxException e) {
                this.cannotReadAuxiliaryFile(CLR, e);
            }
            if (this.colorModel != null) continue;
            this.colorModel = ColorModelFactory.createGrayScale((int)dataType, (int)bands.length, (int)band, (double)minimum, (double)maximum);
        }
        this.sampleDimensions = UnmodifiableArrayList.wrap((Object[])bands);
    }

    private void cannotReadAuxiliaryFile(String suffix, Exception exception) {
        boolean warning = !(exception instanceof NoSuchFileException) && !(exception instanceof FileNotFoundException);
        this.cannotReadAuxiliaryFile(RasterStore.class, "loadBandDescriptions", suffix, exception, warning);
    }

    final GridCoverage2D createCoverage(GridGeometry domain, RangeArgument range, WritableRaster data, Statistics stats) {
        SampleDimension[] bands = range.select(this.sampleDimensions);
        Hashtable<String, Object[]> properties = null;
        if (stats != null) {
            Object[] as = new Statistics[range.getNumBands()];
            Arrays.fill(as, stats);
            properties = new Hashtable<String, Object[]>();
            properties.put("org.apache.sis.Statistics", as);
            properties.put("org.apache.sis.SampleDimensions", bands);
        }
        ColorModel cm = this.colorModel;
        if (!range.isIdentity() && (cm = range.select(cm)) == null) {
            SampleDimension band = bands[0];
            cm = ColorModelFactory.createGrayScale((SampleModel)data.getSampleModel(), (int)0, (NumberRange)band.getSampleRange().orElse(null));
        }
        return new GridCoverage2D(domain, Arrays.asList(bands), (RenderedImage)new ObservableImage(cm, data, false, properties));
    }

    @Override
    public List<SampleDimension> getSampleDimensions() throws DataStoreException {
        return this.sampleDimensions;
    }

    @Override
    public void close() throws DataStoreException {
        this.metadata = null;
    }
}

