/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.services.io.StreamStorable;
import org.apache.derby.iapi.services.loader.GeneratedMethod;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.ResultDescription;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptorList;
import org.apache.derby.iapi.sql.execute.ConstantAction;
import org.apache.derby.iapi.sql.execute.CursorResultSet;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.NoPutResultSet;
import org.apache.derby.iapi.sql.execute.RowChanger;
import org.apache.derby.iapi.store.access.BackingStoreHashtable;
import org.apache.derby.iapi.store.access.ConglomerateController;
import org.apache.derby.iapi.store.access.ScanController;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.types.BooleanDataValue;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.NumberDataValue;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.iapi.types.SQLBoolean;
import org.apache.derby.iapi.types.SQLRef;
import org.apache.derby.impl.sql.execute.AutoincrementCounter;
import org.apache.derby.impl.sql.execute.DMLWriteGeneratedColumnsResultSet;
import org.apache.derby.impl.sql.execute.DeferredConstraintsMemory;
import org.apache.derby.impl.sql.execute.FKInfo;
import org.apache.derby.impl.sql.execute.RISetChecker;
import org.apache.derby.impl.sql.execute.RowUtil;
import org.apache.derby.impl.sql.execute.TableScanResultSet;
import org.apache.derby.impl.sql.execute.TemporaryRowHolderImpl;
import org.apache.derby.impl.sql.execute.TriggerEventActivator;
import org.apache.derby.impl.sql.execute.TriggerEvents;
import org.apache.derby.impl.sql.execute.TriggerInfo;
import org.apache.derby.impl.sql.execute.UpdateConstantAction;
import org.apache.derby.shared.common.error.StandardException;

class UpdateResultSet
extends DMLWriteGeneratedColumnsResultSet {
    private TransactionController tc;
    private ExecRow newBaseRow;
    private ExecRow row;
    private ExecRow deferredSparseRow;
    UpdateConstantAction constants;
    NoPutResultSet savedSource;
    private RowChanger rowChanger;
    protected ConglomerateController deferredBaseCC;
    protected long[] deferredUniqueCIDs;
    protected boolean[] deferredUniqueCreated;
    protected ConglomerateController[] deferredUniqueCC;
    protected ScanController[] deferredUniqueScans;
    private TemporaryRowHolderImpl deletedRowHolder;
    private TemporaryRowHolderImpl insertedRowHolder;
    private RISetChecker riChecker;
    private TriggerInfo triggerInfo;
    private TriggerEventActivator triggerActivator;
    private boolean updatingReferencedKey;
    private boolean updatingForeignKey;
    private int numOpens;
    private long heapConglom;
    private FKInfo[] fkInfoArray;
    private FormatableBitSet baseRowReadList;
    private GeneratedMethod generationClauses;
    private GeneratedMethod checkGM;
    private int resultWidth;
    private int numberOfBaseColumns;
    private ExecRow deferredTempRow;
    private ExecRow deferredBaseRow;
    private ExecRow oldDeletedRow;
    private ResultDescription triggerResultDescription;
    int lockMode;
    boolean deferred;
    boolean beforeUpdateCopyRequired = false;
    private List<UUID> violatingCheckConstraints;
    private BackingStoreHashtable deferredChecks;

    UpdateResultSet(NoPutResultSet noPutResultSet, GeneratedMethod generatedMethod, GeneratedMethod generatedMethod2, Activation activation) throws StandardException {
        this(noPutResultSet, generatedMethod, generatedMethod2, activation, activation.getConstantAction(), null);
    }

    UpdateResultSet(NoPutResultSet noPutResultSet, GeneratedMethod generatedMethod, GeneratedMethod generatedMethod2, Activation activation, int n, int n2) throws StandardException {
        this(noPutResultSet, generatedMethod, generatedMethod2, activation, (ConstantAction)activation.getPreparedStatement().getSavedObject(n), (ResultDescription)activation.getPreparedStatement().getSavedObject(n2));
        this.deferred = true;
    }

    UpdateResultSet(NoPutResultSet noPutResultSet, GeneratedMethod generatedMethod, GeneratedMethod generatedMethod2, Activation activation, ConstantAction constantAction, ResultDescription resultDescription) throws StandardException {
        super(activation, constantAction);
        this.tc = activation.getTransactionController();
        this.sourceResultSet = noPutResultSet;
        this.generationClauses = generatedMethod;
        this.checkGM = generatedMethod2;
        this.constants = (UpdateConstantAction)this.constantAction;
        this.fkInfoArray = this.constants.getFKInfo();
        this.triggerInfo = this.constants.getTriggerInfo();
        this.heapConglom = this.constants.conglomId;
        this.baseRowReadList = this.constants.getBaseRowReadList();
        this.resultDescription = resultDescription == null ? noPutResultSet.getResultDescription() : resultDescription;
        if (this.fkInfoArray != null) {
            for (FKInfo fKInfo : this.fkInfoArray) {
                if (fKInfo.type == 2) {
                    this.updatingReferencedKey = true;
                    continue;
                }
                this.updatingForeignKey = true;
            }
        }
        this.resultWidth = this.resultDescription.getColumnCount();
        this.numberOfBaseColumns = (this.resultWidth - 1) / 2;
        this.newBaseRow = RowUtil.getEmptyValueRow(this.numberOfBaseColumns, this.lcc);
        this.deferred = this.constants.deferred;
        if (this.triggerInfo != null || this.fkInfoArray != null) {
            this.beforeUpdateCopyRequired = true;
        }
        this.identitySequenceUUIDString = this.constants.identitySequenceUUIDString;
        this.initializeAIcache(this.constants.getAutoincRowLocation());
    }

    @Override
    public void open() throws StandardException {
        this.setup();
        this.autoincrementGenerated = false;
        this.collectAffectedRows();
        if (this.deferred) {
            this.runChecker(true);
            this.fireBeforeTriggers();
            this.updateDeferredRows();
            this.rowChanger.finish();
            this.runChecker(false);
            this.fireAfterTriggers();
        } else {
            this.rowChanger.finish();
        }
        this.saveAIcacheInformation(this.constants.getSchemaName(), this.constants.getTableName(), this.constants.getColumnNames());
        this.cleanUp();
    }

    @Override
    void setup() throws StandardException {
        super.setup();
        this.lockMode = this.decodeLockMode(this.constants.lockMode);
        boolean bl = this.rowChanger == null;
        this.rowCount = 0L;
        if (this.lcc.getRunTimeStatisticsMode()) {
            this.savedSource = this.sourceResultSet;
        }
        if (bl) {
            this.rowChanger = this.lcc.getLanguageConnectionFactory().getExecutionFactory().getRowChanger(this.heapConglom, this.constants.heapSCOCI, this.heapDCOCI, this.constants.irgs, this.constants.indexCIDS, this.constants.indexSCOCIs, this.indexDCOCIs, this.constants.numColumns, this.tc, this.constants.changedColumnIds, this.constants.getBaseRowReadList(), this.constants.getBaseRowReadMap(), this.constants.getStreamStorableHeapColIds(), this.activation);
            this.rowChanger.setIndexNames(this.constants.indexNames);
        }
        this.verifyAutoGeneratedRScolumnsList(this.constants.targetUUID);
        this.rowChanger.open(this.lockMode);
        if (this.numOpens++ == 0) {
            this.sourceResultSet.openCore();
        } else {
            this.sourceResultSet.reopenCore();
        }
        if (this.deferred) {
            this.activation.clearIndexScanInfo();
        }
        if (this.fkInfoArray != null) {
            if (this.riChecker == null) {
                this.riChecker = new RISetChecker(this.lcc, this.tc, this.fkInfoArray);
            } else {
                this.riChecker.reopen();
            }
        }
        if (this.deferred) {
            if (bl) {
                this.deferredTempRow = RowUtil.getEmptyValueRow(this.numberOfBaseColumns + 1, this.lcc);
                this.oldDeletedRow = RowUtil.getEmptyValueRow(this.numberOfBaseColumns, this.lcc);
                this.triggerResultDescription = this.resultDescription != null ? this.resultDescription.truncateColumns(this.numberOfBaseColumns + 1) : null;
            }
            Properties properties = new Properties();
            this.rowChanger.getHeapConglomerateController().getInternalTablePropertySet(properties);
            if (this.beforeUpdateCopyRequired) {
                this.deletedRowHolder = new TemporaryRowHolderImpl(this.activation, properties, this.triggerResultDescription);
            }
            this.insertedRowHolder = new TemporaryRowHolderImpl(this.activation, properties, this.triggerResultDescription);
            this.rowChanger.setRowHolder(this.insertedRowHolder);
        }
        this.firstExecuteSpecialHandlingAutoGen(bl, this.rowChanger, this.constants.targetUUID);
    }

    private FormatableBitSet checkStreamCols() {
        DataValueDescriptor[] dataValueDescriptorArray = this.row.getRowArray();
        FormatableBitSet formatableBitSet = null;
        for (int i = 0; i < this.numberOfBaseColumns; ++i) {
            if (!(dataValueDescriptorArray[i + this.numberOfBaseColumns] instanceof StreamStorable)) continue;
            if (formatableBitSet == null) {
                formatableBitSet = new FormatableBitSet(this.numberOfBaseColumns);
            }
            formatableBitSet.set(i);
        }
        return formatableBitSet;
    }

    private void objectifyStream(ExecRow execRow, FormatableBitSet formatableBitSet) throws StandardException {
        DataValueDescriptor[] dataValueDescriptorArray = execRow.getRowArray();
        for (int i = 0; i < this.numberOfBaseColumns; ++i) {
            if (dataValueDescriptorArray[i] == null || !formatableBitSet.get(i)) continue;
            ((StreamStorable)((Object)dataValueDescriptorArray[i])).loadStream();
        }
    }

    private boolean evaluateCheckConstraints() throws StandardException {
        boolean bl = true;
        if (this.checkGM != null) {
            SQLBoolean sQLBoolean = (SQLBoolean)this.checkGM.invoke(this.activation);
            bl = sQLBoolean.isNull() || sQLBoolean.getBoolean();
        }
        return bl;
    }

    public boolean collectAffectedRows() throws StandardException {
        boolean bl = false;
        this.row = this.getNextRowCore(this.sourceResultSet);
        if (this.row != null) {
            bl = true;
        } else {
            this.activation.addWarning(StandardException.newWarning((String)"02000", (Object[])new Object[0]));
        }
        TableScanResultSet tableScanResultSet = (TableScanResultSet)this.activation.getForUpdateIndexScan();
        boolean bl2 = tableScanResultSet != null;
        boolean bl3 = this.deferred && bl && !this.constants.singleRowSource;
        FormatableBitSet formatableBitSet = bl3 ? this.checkStreamCols() : null;
        boolean bl4 = bl3 = formatableBitSet != null;
        while (this.row != null) {
            DataValueDescriptor[] dataValueDescriptorArray;
            boolean bl5;
            this.evaluateGenerationClauses(this.generationClauses, this.activation, this.sourceResultSet, this.row, true);
            if (this.deferred) {
                if (this.triggerInfo == null && !(bl5 = this.evaluateCheckConstraints())) {
                    dataValueDescriptorArray = this.row.getRowArray();
                    SQLRef sQLRef = (SQLRef)dataValueDescriptorArray[dataValueDescriptorArray.length - 1];
                    RowLocation rowLocation = (RowLocation)sQLRef.getObject();
                    this.deferredChecks = DeferredConstraintsMemory.rememberCheckViolations(this.lcc, this.constants.targetUUID, this.constants.getSchemaName(), this.constants.getTableName(), this.deferredChecks, this.violatingCheckConstraints, rowLocation, new DeferredConstraintsMemory.CheckInfo[1]);
                }
                RowUtil.copyRefColumns(this.deferredTempRow, this.row, this.numberOfBaseColumns, this.numberOfBaseColumns + 1);
                if (bl3) {
                    this.objectifyStream(this.deferredTempRow, formatableBitSet);
                }
                this.insertedRowHolder.insert(this.deferredTempRow);
                if (this.beforeUpdateCopyRequired) {
                    RowUtil.copyRefColumns(this.oldDeletedRow, this.row, this.numberOfBaseColumns);
                    this.deletedRowHolder.insert(this.oldDeletedRow);
                }
                if (this.deferredBaseRow == null) {
                    this.deferredBaseRow = RowUtil.getEmptyValueRow(this.numberOfBaseColumns, this.lcc);
                    RowUtil.copyCloneColumns(this.deferredBaseRow, this.row, this.numberOfBaseColumns);
                    this.deferredSparseRow = this.makeDeferredSparseRow(this.deferredBaseRow, this.baseRowReadList, this.lcc);
                }
            } else {
                bl5 = this.evaluateCheckConstraints();
                dataValueDescriptorArray = (DataValueDescriptor[])this.row.getColumn(this.resultWidth).getObject();
                if (!bl5) {
                    this.deferredChecks = DeferredConstraintsMemory.rememberCheckViolations(this.lcc, this.constants.targetUUID, this.constants.getSchemaName(), this.constants.getTableName(), this.deferredChecks, this.violatingCheckConstraints, (RowLocation)dataValueDescriptorArray, new DeferredConstraintsMemory.CheckInfo[1]);
                }
                RowUtil.copyRefColumns(this.newBaseRow, this.row, this.numberOfBaseColumns, this.numberOfBaseColumns);
                if (this.riChecker != null) {
                    this.riChecker.doFKCheck(this.activation, this.newBaseRow);
                }
                this.sourceResultSet.updateRow(this.newBaseRow, this.rowChanger);
                this.rowChanger.updateRow(this.row, this.newBaseRow, (RowLocation)dataValueDescriptorArray);
                if (bl2) {
                    this.notifyForUpdateCursor(this.row.getRowArray(), this.newBaseRow.getRowArray(), (RowLocation)dataValueDescriptorArray, tableScanResultSet);
                }
            }
            ++this.rowCount;
            if (this.constants.singleRowSource) {
                this.row = null;
                continue;
            }
            this.row = this.getNextRowCore(this.sourceResultSet);
        }
        if (this.rowCount == 1L && this.constants.hasAutoincrement()) {
            this.lcc.setIdentityValue(this.identityVal);
        }
        return bl;
    }

    @Override
    protected ExecRow getNextRowCore(NoPutResultSet noPutResultSet) throws StandardException {
        ExecRow execRow = super.getNextRowCore(noPutResultSet);
        if (execRow != null && this.constants.underMerge()) {
            execRow = this.processMergeRow(noPutResultSet, execRow);
        }
        return execRow;
    }

    private ExecRow processMergeRow(NoPutResultSet noPutResultSet, ExecRow execRow) throws StandardException {
        return this.normalizeRow(noPutResultSet, execRow);
    }

    private void notifyForUpdateCursor(DataValueDescriptor[] dataValueDescriptorArray, DataValueDescriptor[] dataValueDescriptorArray2, RowLocation rowLocation, TableScanResultSet tableScanResultSet) throws StandardException {
        int n;
        int[] nArray = tableScanResultSet.indexCols;
        int[] nArray2 = this.constants.changedColumnIds;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        for (n = 0; n < nArray.length; ++n) {
            boolean bl4;
            int n2 = nArray[n];
            if (n2 > 0) {
                bl4 = true;
            } else {
                bl4 = false;
                n2 = -n2;
            }
            for (int i = 0; i < nArray2.length; ++i) {
                if (n2 != nArray2[i]) continue;
                bl2 = true;
                int[] nArray3 = this.constants.getBaseRowReadMap();
                int n3 = nArray3 == null ? n2 - 1 : nArray3[n2 - 1];
                DataValueDescriptor dataValueDescriptor = dataValueDescriptorArray[n3];
                if (bl4 && dataValueDescriptor.greaterThan(dataValueDescriptorArray2[n3], dataValueDescriptor).equals(true) || !bl4 && dataValueDescriptor.lessThan(dataValueDescriptorArray2[n3], dataValueDescriptor).equals(true)) {
                    bl = true;
                    break;
                }
                if (!dataValueDescriptor.equals(dataValueDescriptorArray2[n3], dataValueDescriptor).equals(true)) break;
                bl2 = false;
                bl3 = true;
                break;
            }
            if (bl2) break;
        }
        if (bl3 && !bl2) {
            bl = true;
        }
        if (bl) {
            n = this.lcc.getOptimizerFactory().getMaxMemoryPerTable() / 16;
            if (n < 100) {
                n = 100;
            }
            if (tableScanResultSet.past2FutureTbl == null) {
                double d = tableScanResultSet.getEstimatedRowCount();
                int n4 = 32768;
                if (d > 0.0 && (d = d / 0.75 + 1.0) < (double)n4) {
                    n4 = (int)d;
                }
                if (n < n4) {
                    n4 = n;
                }
                tableScanResultSet.past2FutureTbl = new BackingStoreHashtable(this.tc, null, new int[]{0}, false, -1L, n, n4, -1.0f, false, tableScanResultSet.getActivation().getResultSetHoldability());
            }
            tableScanResultSet.past2FutureTbl.putRow(false, new DataValueDescriptor[]{rowLocation.cloneValue(false)}, null);
        }
    }

    void fireBeforeTriggers() throws StandardException {
        if (this.deferred && this.triggerInfo != null) {
            Vector<AutoincrementCounter> vector = null;
            if (this.aiCache != null) {
                vector = new Vector<AutoincrementCounter>();
                for (int i = 0; i < this.aiCache.length; ++i) {
                    if (this.aiCache[i] == null) continue;
                    String string = this.constants.getSchemaName();
                    String string2 = this.constants.getTableName();
                    String string3 = this.constants.getColumnName(i);
                    Long l = this.lcc.lastAutoincrementValue(string, string2, string3);
                    AutoincrementCounter autoincrementCounter = new AutoincrementCounter(l, this.constants.getAutoincIncrement(i), this.aiCache[i].getLong(), string, string2, string3, i + 1);
                    vector.addElement(autoincrementCounter);
                }
            }
            if (this.triggerActivator == null) {
                this.triggerActivator = new TriggerEventActivator(this.lcc, this.constants.targetUUID, this.triggerInfo, 1, this.activation, vector);
            } else {
                this.triggerActivator.reopen();
            }
            this.triggerActivator.notifyEvent(TriggerEvents.BEFORE_UPDATE, this.deletedRowHolder.getResultSet(), this.insertedRowHolder.getResultSet(), this.constants.getBaseRowReadMap());
        }
    }

    void fireAfterTriggers() throws StandardException {
        if (this.deferred && this.triggerActivator != null) {
            this.triggerActivator.notifyEvent(TriggerEvents.AFTER_UPDATE, this.deletedRowHolder.getResultSet(), this.insertedRowHolder.getResultSet(), this.constants.getBaseRowReadMap());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateDeferredRows() throws StandardException {
        if (this.deferred) {
            this.deferredBaseCC = this.tc.openCompiledConglomerate(false, 8196, this.lockMode, 5, this.constants.heapSCOCI, this.heapDCOCI);
            CursorResultSet cursorResultSet = this.insertedRowHolder.getResultSet();
            try {
                ExecRow execRow;
                FormatableBitSet formatableBitSet = RowUtil.shift(this.baseRowReadList, 1);
                cursorResultSet.open();
                while ((execRow = cursorResultSet.getNextRow()) != null) {
                    boolean bl = true;
                    if (this.triggerInfo != null) {
                        this.sourceResultSet.setCurrentRow(this.deferredTempRow);
                        bl = this.evaluateCheckConstraints();
                    }
                    DataValueDescriptor dataValueDescriptor = execRow.getColumn(this.numberOfBaseColumns + 1);
                    RowLocation rowLocation = (RowLocation)dataValueDescriptor.getObject();
                    if (!bl) {
                        this.deferredChecks = DeferredConstraintsMemory.rememberCheckViolations(this.lcc, this.constants.targetUUID, this.constants.getSchemaName(), this.constants.getTableName(), this.deferredChecks, this.violatingCheckConstraints, rowLocation, new DeferredConstraintsMemory.CheckInfo[1]);
                    }
                    boolean bl2 = this.deferredBaseCC.fetch(rowLocation, this.deferredSparseRow.getRowArray(), formatableBitSet);
                    RowUtil.copyRefColumns(this.newBaseRow, execRow, this.numberOfBaseColumns);
                    this.rowChanger.updateRow(this.deferredBaseRow, this.newBaseRow, rowLocation);
                }
            }
            finally {
                this.sourceResultSet.clearCurrentRow();
                cursorResultSet.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void runChecker(boolean bl) throws StandardException {
        ExecRow execRow;
        CursorResultSet cursorResultSet;
        int n;
        if (this.deferred && this.updatingReferencedKey) {
            for (n = 0; n < this.fkInfoArray.length; ++n) {
                if (this.fkInfoArray[n].type == 1) continue;
                cursorResultSet = this.deletedRowHolder.getResultSet();
                try {
                    cursorResultSet.open();
                    while ((execRow = cursorResultSet.getNextRow()) != null) {
                        if (UpdateResultSet.foundRow(execRow, this.fkInfoArray[n].colArray, this.insertedRowHolder)) continue;
                        this.riChecker.doRICheck(this.activation, n, execRow, bl, 1);
                    }
                    if (!bl) continue;
                    this.riChecker.postCheck(n);
                    continue;
                }
                finally {
                    cursorResultSet.close();
                }
            }
        }
        if (this.deferred && this.updatingForeignKey) {
            for (n = 0; n < this.fkInfoArray.length; ++n) {
                if (this.fkInfoArray[n].type == 2) continue;
                cursorResultSet = this.insertedRowHolder.getResultSet();
                try {
                    cursorResultSet.open();
                    while ((execRow = cursorResultSet.getNextRow()) != null) {
                        if (UpdateResultSet.foundRow(execRow, this.fkInfoArray[n].colArray, this.deletedRowHolder)) continue;
                        this.riChecker.doRICheck(this.activation, n, execRow, bl, 0);
                    }
                    continue;
                }
                finally {
                    cursorResultSet.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean foundRow(ExecRow execRow, int[] nArray, TemporaryRowHolderImpl temporaryRowHolderImpl) throws StandardException {
        boolean bl = false;
        DataValueDescriptor[] dataValueDescriptorArray = execRow.getRowArray();
        try (CursorResultSet cursorResultSet = temporaryRowHolderImpl.getResultSet();){
            ExecRow execRow2;
            cursorResultSet.open();
            while ((execRow2 = cursorResultSet.getNextRow()) != null) {
                DataValueDescriptor dataValueDescriptor;
                DataValueDescriptor dataValueDescriptor2;
                BooleanDataValue booleanDataValue;
                int n;
                DataValueDescriptor[] dataValueDescriptorArray2 = execRow2.getRowArray();
                for (n = 0; n < nArray.length && (booleanDataValue = (dataValueDescriptor2 = dataValueDescriptorArray[nArray[n] - 1]).equals(dataValueDescriptor = dataValueDescriptorArray2[nArray[n] - 1], dataValueDescriptor2)).getBoolean(); ++n) {
                }
                if (n != nArray.length) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    @Override
    public void cleanUp() throws StandardException {
        this.numOpens = 0;
        if (this.sourceResultSet != null) {
            this.sourceResultSet.close();
        }
        if (this.triggerActivator != null) {
            this.triggerActivator.cleanup();
        }
        if (this.rowChanger != null) {
            this.rowChanger.close();
        }
        if (this.deferredBaseCC != null) {
            this.deferredBaseCC.close();
        }
        this.deferredBaseCC = null;
        if (this.insertedRowHolder != null) {
            this.insertedRowHolder.close();
        }
        if (this.deletedRowHolder != null) {
            this.deletedRowHolder.close();
        }
        if (this.riChecker != null) {
            this.riChecker.close();
        }
        this.close();
        this.endTime = this.getCurrentTimeMillis();
    }

    @Override
    public void close() throws StandardException {
        super.close(this.constants.underMerge());
    }

    void rowChangerFinish() throws StandardException {
        this.rowChanger.finish();
    }

    @Override
    public void rememberConstraint(UUID uUID) throws StandardException {
        if (this.violatingCheckConstraints == null) {
            this.violatingCheckConstraints = new ArrayList<UUID>();
        }
        this.violatingCheckConstraints.add(uUID);
    }

    @Override
    public NumberDataValue getSetAutoincrementValue(int n, long l) throws StandardException {
        this.autoincrementGenerated = true;
        int n2 = n - 1;
        NumberDataValue numberDataValue = this.activation.getCurrentValueAndAdvance(this.identitySequenceUUIDString, this.aiCache[n2].getTypeFormatId());
        this.aiCache[n2] = numberDataValue;
        this.identityVal = numberDataValue.getLong();
        return (NumberDataValue)this.aiCache[n2];
    }

    protected void initializeAIcache(RowLocation[] rowLocationArray) throws StandardException {
        if (rowLocationArray != null) {
            this.aiCache = new DataValueDescriptor[rowLocationArray.length];
            ColumnDescriptorList columnDescriptorList = this.lcc.getDataDictionary().getTableDescriptor(this.constants.targetUUID).getColumnDescriptorList();
            for (int i = 0; i < columnDescriptorList.size(); ++i) {
                if (rowLocationArray[i] == null) continue;
                this.aiCache[i] = columnDescriptorList.elementAt(i).getType().getNull();
            }
        }
    }
}

