/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.banyandb;

import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.skywalking.banyandb.common.v1.BanyandbCommon;
import org.apache.skywalking.banyandb.model.v1.BanyandbModel;
import org.apache.skywalking.banyandb.property.v1.BanyandbProperty;
import org.apache.skywalking.banyandb.v1.client.TagAndValue;
import org.apache.skywalking.oap.server.core.management.ui.template.UITemplate;
import org.apache.skywalking.oap.server.core.query.input.DashboardSetting;
import org.apache.skywalking.oap.server.core.query.type.DashboardConfiguration;
import org.apache.skywalking.oap.server.core.query.type.TemplateChangeStatus;
import org.apache.skywalking.oap.server.core.storage.management.UITemplateManagementDAO;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.BanyanDBStorageClient;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.MetadataRegistry;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.stream.AbstractBanyanDBDAO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BanyanDBUITemplateManagementDAO
extends AbstractBanyanDBDAO
implements UITemplateManagementDAO {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BanyanDBUITemplateManagementDAO.class);

    public BanyanDBUITemplateManagementDAO(BanyanDBStorageClient client) {
        super(client);
    }

    public DashboardConfiguration getTemplate(String id) throws IOException {
        BanyandbProperty.Property p = ((BanyanDBStorageClient)this.getClient()).queryProperty("ui_template", id);
        if (p == null) {
            return null;
        }
        return this.fromEntity(this.parse(p));
    }

    public List<DashboardConfiguration> getAllTemplates(Boolean includingDisabled) throws IOException {
        List<BanyandbProperty.Property> propertyList = ((BanyanDBStorageClient)this.getClient()).listProperties("ui_template");
        return propertyList.stream().map(p -> this.fromEntity(this.parse((BanyandbProperty.Property)p))).filter(conf -> includingDisabled != false || !conf.isDisabled()).collect(Collectors.toList());
    }

    public TemplateChangeStatus addTemplate(DashboardSetting setting) {
        BanyandbProperty.Property newTemplate = this.applyAll(setting.toEntity());
        try {
            ((BanyanDBStorageClient)this.getClient()).apply(newTemplate);
            return TemplateChangeStatus.builder().status(true).id(newTemplate.getId()).build();
        }
        catch (IOException ioEx) {
            log.error("fail to add new template", (Throwable)ioEx);
            return TemplateChangeStatus.builder().status(false).id(setting.getId()).message("Can't add a new template").build();
        }
    }

    public TemplateChangeStatus changeTemplate(DashboardSetting setting) {
        BanyandbProperty.Property newTemplate = this.applyConfiguration(setting.toEntity());
        try {
            ((BanyanDBStorageClient)this.getClient()).apply(newTemplate);
            return TemplateChangeStatus.builder().status(true).id(newTemplate.getId()).build();
        }
        catch (IOException ioEx) {
            log.error("fail to modify the template", (Throwable)ioEx);
            return TemplateChangeStatus.builder().status(false).id(setting.getId()).message("Can't change an existed template").build();
        }
    }

    public TemplateChangeStatus disableTemplate(String id) throws IOException {
        BanyandbProperty.Property oldProperty = ((BanyanDBStorageClient)this.getClient()).queryProperty("ui_template", id);
        if (oldProperty == null) {
            return TemplateChangeStatus.builder().status(false).id(id).message("Can't find the template").build();
        }
        UITemplate uiTemplate = this.parse(oldProperty);
        try {
            ((BanyanDBStorageClient)this.getClient()).apply(this.applyStatus(uiTemplate));
            return TemplateChangeStatus.builder().status(true).id(uiTemplate.id().build()).build();
        }
        catch (IOException ioEx) {
            log.error("fail to disable the template", (Throwable)ioEx);
            return TemplateChangeStatus.builder().status(false).id(uiTemplate.id().build()).message("Can't disable the template").build();
        }
    }

    public DashboardConfiguration fromEntity(UITemplate uiTemplate) {
        DashboardConfiguration conf = new DashboardConfiguration();
        conf.fromEntity(uiTemplate);
        return conf;
    }

    public UITemplate parse(BanyandbProperty.Property property) {
        UITemplate uiTemplate = new UITemplate();
        uiTemplate.setTemplateId(property.getId());
        for (BanyandbModel.Tag tag : property.getTagsList()) {
            TagAndValue tagAndValue = TagAndValue.fromProtobuf((BanyandbModel.Tag)tag);
            if (tagAndValue.getTagName().equals("configuration")) {
                uiTemplate.setConfiguration((String)tagAndValue.getValue());
                continue;
            }
            if (tagAndValue.getTagName().equals("disabled")) {
                uiTemplate.setDisabled(Integer.valueOf(((Number)tagAndValue.getValue()).intValue()));
                continue;
            }
            if (!tagAndValue.getTagName().equals("update_time")) continue;
            uiTemplate.setUpdateTime(Long.valueOf(((Number)tagAndValue.getValue()).longValue()));
        }
        return uiTemplate;
    }

    public BanyandbProperty.Property applyAll(UITemplate uiTemplate) {
        MetadataRegistry.Schema schema = MetadataRegistry.INSTANCE.findManagementMetadata("ui_template");
        return BanyandbProperty.Property.newBuilder().setMetadata(BanyandbCommon.Metadata.newBuilder().setGroup(schema.getMetadata().getGroup()).setName("ui_template")).setId(uiTemplate.id().build()).addTags(TagAndValue.newStringTag((String)"configuration", (String)uiTemplate.getConfiguration()).build()).addTags(TagAndValue.newLongTag((String)"disabled", (long)uiTemplate.getDisabled().intValue()).build()).addTags(TagAndValue.newLongTag((String)"update_time", (long)uiTemplate.getUpdateTime()).build()).build();
    }

    public BanyandbProperty.Property applyStatus(UITemplate uiTemplate) {
        MetadataRegistry.Schema schema = MetadataRegistry.INSTANCE.findManagementMetadata("ui_template");
        return BanyandbProperty.Property.newBuilder().setMetadata(BanyandbCommon.Metadata.newBuilder().setGroup(schema.getMetadata().getGroup()).setName("ui_template")).setId(uiTemplate.id().build()).addTags(TagAndValue.newLongTag((String)"disabled", (long)uiTemplate.getDisabled().intValue()).build()).addTags(TagAndValue.newLongTag((String)"update_time", (long)uiTemplate.getUpdateTime()).build()).build();
    }

    public BanyandbProperty.Property applyConfiguration(UITemplate uiTemplate) {
        MetadataRegistry.Schema schema = MetadataRegistry.INSTANCE.findManagementMetadata("ui_template");
        return BanyandbProperty.Property.newBuilder().setMetadata(BanyandbCommon.Metadata.newBuilder().setGroup(schema.getMetadata().getGroup()).setName("ui_template")).setId(uiTemplate.id().build()).addTags(TagAndValue.newStringTag((String)"configuration", (String)uiTemplate.getConfiguration()).build()).addTags(TagAndValue.newLongTag((String)"update_time", (long)uiTemplate.getUpdateTime()).build()).build();
    }
}

