/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.maven.feature.launcher;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.inject.Named;
import javax.inject.Singleton;

@Named
@Singleton
public class ProcessTracker {
    private final Object sync = new Object();
    private boolean hookAdded = false;
    private final Map<String, Process> processes = new HashMap<String, Process>();

    static void stop(Process process) throws InterruptedException {
        process.destroy();
        boolean stopped = process.waitFor(30L, TimeUnit.SECONDS);
        if (!stopped) {
            process.destroyForcibly();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startTracking(String launchId, final Process process) {
        Object object = this.sync;
        synchronized (object) {
            if (this.processes.containsKey(launchId)) {
                throw new IllegalArgumentException("Launch id " + launchId + " already associated with a process");
            }
            this.processes.put(launchId, process);
            if (!this.hookAdded) {
                Runtime.getRuntime().addShutdownHook(new Thread("process-tracker-shutdown"){

                    @Override
                    public void run() {
                        for (Map.Entry entry : ProcessTracker.this.processes.entrySet()) {
                            System.err.println("Launch " + (String)entry.getKey() + " was not shut down! Destroying forcibly from shutdown hook..");
                            process.destroyForcibly();
                        }
                    }
                });
                this.hookAdded = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(String id) throws InterruptedException {
        Process process;
        Object object = this.sync;
        synchronized (object) {
            process = this.processes.remove(id);
        }
        if (process == null) {
            return;
        }
        ProcessTracker.stop(process);
    }
}

