/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.starter.access.models;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.sling.starter.access.models.RestrictionItem;

public class PrivilegeItem {
    private String name;
    private boolean granted;
    private boolean denied;
    private String longestPath;
    private long depth;
    private String extraCssClasses;
    private List<RestrictionItem> allowRestrictions;
    private List<RestrictionItem> denyRestrictions;
    private Set<String> allowRestrictionsToDelete;
    private Set<String> denyRestrictionsToDelete;
    private boolean allowExists = false;
    private boolean denyExists = false;

    public PrivilegeItem(String name, boolean granted, boolean denied, String longestPath) {
        this(name, granted, denied, longestPath, Collections.emptyList(), Collections.emptyList());
    }

    public PrivilegeItem(String name, boolean granted, boolean denied, String longestPath, List<RestrictionItem> allowRestrictions, List<RestrictionItem> denyRestrictions) {
        this.name = name;
        this.granted = granted;
        this.denied = denied;
        this.longestPath = longestPath;
        this.depth = longestPath.chars().filter(ch -> ch == 47).count();
        this.allowRestrictions = allowRestrictions;
        this.denyRestrictions = denyRestrictions;
    }

    public String getName() {
        return this.name;
    }

    public boolean getNone() {
        return !this.granted && !this.denied;
    }

    public boolean getGranted() {
        return this.granted;
    }

    public boolean getDenied() {
        return this.denied;
    }

    public void setGranted(boolean granted) {
        this.granted = granted;
    }

    public void setDenied(boolean denied) {
        this.denied = denied;
    }

    public boolean isAllowExists() {
        return this.allowExists;
    }

    public void setAllowExists(boolean allowExists) {
        this.allowExists = allowExists;
    }

    public boolean isDenyExists() {
        return this.denyExists;
    }

    public void setDenyExists(boolean denyExists) {
        this.denyExists = denyExists;
    }

    public String getLongestPath() {
        return this.longestPath;
    }

    public void addExtraCssClass(String addClass) {
        this.extraCssClasses = this.extraCssClasses == null ? addClass : String.format("%s %s", this.extraCssClasses, addClass);
    }

    public String getDepthCss() {
        String css = this.extraCssClasses != null ? String.format("depth%d %s", this.depth, this.extraCssClasses) : String.format("depth%d", this.depth);
        return css;
    }

    public long getDepth() {
        return this.depth;
    }

    public List<RestrictionItem> getAllowRestrictions() {
        return this.allowRestrictions;
    }

    public List<RestrictionItem> getDenyRestrictions() {
        return this.denyRestrictions;
    }

    public void setAllowRestrictions(List<RestrictionItem> restrictions) {
        this.allowRestrictions = restrictions;
    }

    public void setDenyRestrictions(List<RestrictionItem> restrictions) {
        this.denyRestrictions = restrictions;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("PrivilegeItem [name=");
        builder.append(this.name);
        builder.append(", granted=");
        builder.append(this.granted);
        builder.append(", denied=");
        builder.append(this.denied);
        builder.append(", longestPath=");
        builder.append(this.longestPath);
        builder.append(", depth=");
        builder.append(this.depth);
        builder.append(", extraCssClasses=");
        builder.append(this.extraCssClasses);
        builder.append(", allowRestrictions=");
        builder.append(this.allowRestrictions);
        builder.append(", denyRestrictions=");
        builder.append(this.denyRestrictions);
        builder.append("]");
        return builder.toString();
    }

    public void addAllowRestrictionToDelete(String restrictionName) {
        if (this.allowRestrictionsToDelete == null) {
            this.allowRestrictionsToDelete = new HashSet<String>();
        }
        this.allowRestrictionsToDelete.add(restrictionName);
    }

    public Collection<String> getAllowRestrictionsToDelete() {
        if (this.allowRestrictionsToDelete != null) {
            return this.allowRestrictionsToDelete;
        }
        return Collections.emptySet();
    }

    public void addDenyRestrictionToDelete(String restrictionName) {
        if (this.denyRestrictionsToDelete == null) {
            this.denyRestrictionsToDelete = new HashSet<String>();
        }
        this.denyRestrictionsToDelete.add(restrictionName);
    }

    public Collection<String> getDenyRestrictionsToDelete() {
        if (this.denyRestrictionsToDelete != null) {
            return this.denyRestrictionsToDelete;
        }
        return Collections.emptySet();
    }
}

