/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.arrow;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.ipc.ReadChannel;
import org.apache.arrow.vector.ipc.WriteChannel;
import org.apache.arrow.vector.ipc.message.ArrowRecordBatch;
import org.apache.arrow.vector.ipc.message.MessageMetadataResult;
import org.apache.arrow.vector.ipc.message.MessageSerializer;
import org.apache.spark.TaskContext;
import org.apache.spark.TaskContext$;
import org.apache.spark.internal.Logging;
import org.apache.spark.network.util.JavaUtils;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Dataset$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection$;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.catalyst.plans.logical.LocalRelation;
import org.apache.spark.sql.catalyst.plans.logical.LocalRelation$;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.types.DataTypeUtils$;
import org.apache.spark.sql.execution.arrow.ArrowConverters;
import org.apache.spark.sql.types.DataType$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.vectorized.ArrowColumnVector;
import org.apache.spark.sql.vectorized.ColumnVector;
import org.apache.spark.sql.vectorized.ColumnarBatch;
import org.apache.spark.util.ByteBufferOutputStream;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.BufferedIterator;
import scala.collection.Factory;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Stepper;
import scala.collection.StepperShape;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Vector;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

public final class ArrowConverters$
implements Logging {
    public static final ArrowConverters$ MODULE$ = new ArrowConverters$();
    private static transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        Logging.$init$((Logging)MODULE$);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public ArrowConverters.ArrowBatchIterator toBatchIterator(Iterator<InternalRow> rowIter, StructType schema, long maxRecordsPerBatch, String timeZoneId, boolean errorOnDuplicatedFieldNames, TaskContext context) {
        return new ArrowConverters.ArrowBatchIterator(rowIter, schema, maxRecordsPerBatch, timeZoneId, errorOnDuplicatedFieldNames, context);
    }

    public ArrowConverters.ArrowBatchWithSchemaIterator toBatchWithSchemaIterator(Iterator<InternalRow> rowIter, StructType schema, long maxRecordsPerBatch, long maxEstimatedBatchSize, String timeZoneId, boolean errorOnDuplicatedFieldNames) {
        return new ArrowConverters.ArrowBatchWithSchemaIterator(rowIter, schema, maxRecordsPerBatch, maxEstimatedBatchSize, timeZoneId, errorOnDuplicatedFieldNames, TaskContext$.MODULE$.get());
    }

    public byte[] createEmptyArrowBatch(StructType schema, String timeZoneId, boolean errorOnDuplicatedFieldNames) {
        ArrowConverters.ArrowBatchWithSchemaIterator batches = new ArrowConverters.ArrowBatchWithSchemaIterator(schema, timeZoneId, errorOnDuplicatedFieldNames){

            public boolean hasNext() {
                return true;
            }
        };
        return (byte[])Utils$.MODULE$.tryWithSafeFinally((Function0 & Serializable)() -> batches.next(), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            block0: {
                if (TaskContext$.MODULE$.get() != null) break block0;
                batches.close();
            }
        });
    }

    public Iterator<InternalRow> fromBatchIterator(Iterator<byte[]> arrowBatchIter, StructType schema, String timeZoneId, boolean errorOnDuplicatedFieldNames, TaskContext context) {
        return new ArrowConverters.InternalRowIteratorWithoutSchema(arrowBatchIter, schema, timeZoneId, errorOnDuplicatedFieldNames, context);
    }

    public Tuple2<Iterator<InternalRow>, StructType> fromBatchWithSchemaIterator(Iterator<byte[]> arrowBatchIter, TaskContext context) {
        ArrowConverters.InternalRowIteratorWithSchema iterator = new ArrowConverters.InternalRowIteratorWithSchema(arrowBatchIter, context);
        return new Tuple2((Object)iterator, (Object)iterator.schema());
    }

    public Iterator<InternalRow> org$apache$spark$sql$execution$arrow$ArrowConverters$$vectorSchemaRootToIter(VectorSchemaRoot root) {
        ColumnVector[] columns = (ColumnVector[])((IterableOnceOps)((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter(root.getFieldVectors()).asScala()).map((Function1 & Serializable)vector -> new ArrowColumnVector((ValueVector)vector))).toArray(ClassTag$.MODULE$.apply(ColumnVector.class));
        ColumnarBatch batch = new ColumnarBatch(columns);
        batch.setNumRows(root.getRowCount());
        return (Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(batch.rowIterator()).asScala();
    }

    public ArrowRecordBatch loadBatch(byte[] batchBytes, BufferAllocator allocator) {
        ByteArrayInputStream in = new ByteArrayInputStream(batchBytes);
        return MessageSerializer.deserializeRecordBatch((ReadChannel)new ReadChannel(Channels.newChannel(in)), (BufferAllocator)allocator);
    }

    public Dataset<Row> toDataFrame(Iterator<byte[]> arrowBatches, String schemaString, SparkSession session) {
        Dataset<Row> dataset;
        boolean shouldUseRDD;
        StructType schema = (StructType)DataType$.MODULE$.fromJson(schemaString);
        Seq attrs = DataTypeUtils$.MODULE$.toAttributes(schema);
        byte[][] batchesInDriver = (byte[][])arrowBatches.toArray(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)));
        boolean bl = shouldUseRDD = session.sessionState().conf().arrowLocalRelationThreshold() < BoxesRunTime.unboxToLong((Object)Predef$.MODULE$.wrapLongArray((long[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])batchesInDriver), (Function1 & Serializable)x$4 -> BoxesRunTime.boxToLong((long)ArrowConverters$.$anonfun$toDataFrame$1(x$4)), (ClassTag)ClassTag$.MODULE$.Long())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
        if (shouldUseRDD) {
            this.logDebug((Function0<String>)(Function0 & Serializable)() -> "Using RDD-based createDataFrame with Arrow optimization.");
            String timezone = session.sessionState().conf().sessionLocalTimeZone();
            RDD qual$1 = session.sparkContext().parallelize((Seq)Predef$.MODULE$.copyArrayToImmutableIndexedSeq((Object)batchesInDriver), batchesInDriver.length, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)));
            Function1 & Serializable x$1 = (Function1 & Serializable)batchesInExecutors -> MODULE$.fromBatchIterator((Iterator<byte[]>)batchesInExecutors, schema, timezone, false, TaskContext$.MODULE$.get());
            boolean x$2 = qual$1.mapPartitions$default$2();
            RDD rdd = qual$1.mapPartitions((Function1)x$1, x$2, ClassTag$.MODULE$.apply(InternalRow.class));
            dataset = session.internalCreateDataFrame((RDD<InternalRow>)rdd.setName("arrow"), schema, session.internalCreateDataFrame$default$3());
        } else {
            this.logDebug((Function0<String>)(Function0 & Serializable)() -> "Using LocalRelation in createDataFrame with Arrow optimization.");
            Iterator<InternalRow> data = this.fromBatchIterator((Iterator<byte[]>)Predef$.MODULE$.wrapRefArray((Object[])batchesInDriver).toIterator(), schema, session.sessionState().conf().sessionLocalTimeZone(), false, TaskContext$.MODULE$.get());
            UnsafeProjection proj = UnsafeProjection$.MODULE$.create(attrs, attrs);
            dataset = Dataset$.MODULE$.ofRows(session, (LogicalPlan)new LocalRelation(attrs, (Seq)Predef$.MODULE$.copyArrayToImmutableIndexedSeq(data.map((Function1 & Serializable)r -> proj.apply(r).copy()).toArray(ClassTag$.MODULE$.apply(UnsafeRow.class))), LocalRelation$.MODULE$.apply$default$3()));
        }
        return dataset;
    }

    public byte[][] readArrowStreamFromFile(String filename) {
        return (byte[][])Utils$.MODULE$.tryWithResource((Function0 & Serializable)() -> new FileInputStream(filename), (Function1 & Serializable)fileStream -> (byte[][])MODULE$.getBatchesFromStream(fileStream.getChannel()).toArray(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE))));
    }

    public Iterator<byte[]> getBatchesFromStream(ReadableByteChannel in) {
        return new Iterator<byte[]>(in){
            private byte[] batch;
            private final ReadableByteChannel in$1;

            public final boolean hasDefiniteSize() {
                return Iterator.hasDefiniteSize$((Iterator)this);
            }

            public final Iterator<byte[]> iterator() {
                return Iterator.iterator$((Iterator)this);
            }

            public Option<byte[]> nextOption() {
                return Iterator.nextOption$((Iterator)this);
            }

            public boolean contains(Object elem) {
                return Iterator.contains$((Iterator)this, (Object)elem);
            }

            public BufferedIterator<byte[]> buffered() {
                return Iterator.buffered$((Iterator)this);
            }

            public <B> Iterator<B> padTo(int len, B elem) {
                return Iterator.padTo$((Iterator)this, (int)len, elem);
            }

            public Tuple2<Iterator<byte[]>, Iterator<byte[]>> partition(Function1<byte[], Object> p) {
                return Iterator.partition$((Iterator)this, p);
            }

            public <B> Iterator.GroupedIterator<B> grouped(int size) {
                return Iterator.grouped$((Iterator)this, (int)size);
            }

            public <B> Iterator.GroupedIterator<B> sliding(int size, int step) {
                return Iterator.sliding$((Iterator)this, (int)size, (int)step);
            }

            public <B> int sliding$default$2() {
                return Iterator.sliding$default$2$((Iterator)this);
            }

            public <B> Iterator<B> scanLeft(B z, Function2<B, byte[], B> op) {
                return Iterator.scanLeft$((Iterator)this, z, op);
            }

            public <B> Iterator<B> scanRight(B z, Function2<byte[], B, B> op) {
                return Iterator.scanRight$((Iterator)this, z, op);
            }

            public int indexWhere(Function1<byte[], Object> p, int from) {
                return Iterator.indexWhere$((Iterator)this, p, (int)from);
            }

            public int indexWhere$default$2() {
                return Iterator.indexWhere$default$2$((Iterator)this);
            }

            public <B> int indexOf(B elem) {
                return Iterator.indexOf$((Iterator)this, elem);
            }

            public <B> int indexOf(B elem, int from) {
                return Iterator.indexOf$((Iterator)this, elem, (int)from);
            }

            public final int length() {
                return Iterator.length$((Iterator)this);
            }

            public boolean isEmpty() {
                return Iterator.isEmpty$((Iterator)this);
            }

            public Iterator<byte[]> filter(Function1<byte[], Object> p) {
                return Iterator.filter$((Iterator)this, p);
            }

            public Iterator<byte[]> filterNot(Function1<byte[], Object> p) {
                return Iterator.filterNot$((Iterator)this, p);
            }

            public Iterator<byte[]> filterImpl(Function1<byte[], Object> p, boolean isFlipped) {
                return Iterator.filterImpl$((Iterator)this, p, (boolean)isFlipped);
            }

            public Iterator<byte[]> withFilter(Function1<byte[], Object> p) {
                return Iterator.withFilter$((Iterator)this, p);
            }

            public <B> Iterator<B> collect(PartialFunction<byte[], B> pf) {
                return Iterator.collect$((Iterator)this, pf);
            }

            public Iterator<byte[]> distinct() {
                return Iterator.distinct$((Iterator)this);
            }

            public <B> Iterator<byte[]> distinctBy(Function1<byte[], B> f) {
                return Iterator.distinctBy$((Iterator)this, f);
            }

            public <B> Iterator<B> map(Function1<byte[], B> f) {
                return Iterator.map$((Iterator)this, f);
            }

            public <B> Iterator<B> flatMap(Function1<byte[], IterableOnce<B>> f) {
                return Iterator.flatMap$((Iterator)this, f);
            }

            public <B> Iterator<B> flatten(Function1<byte[], IterableOnce<B>> ev) {
                return Iterator.flatten$((Iterator)this, ev);
            }

            public <B> Iterator<B> concat(Function0<IterableOnce<B>> xs) {
                return Iterator.concat$((Iterator)this, xs);
            }

            public final <B> Iterator<B> $plus$plus(Function0<IterableOnce<B>> xs) {
                return Iterator.$plus$plus$((Iterator)this, xs);
            }

            public Iterator<byte[]> take(int n) {
                return Iterator.take$((Iterator)this, (int)n);
            }

            public Iterator<byte[]> takeWhile(Function1<byte[], Object> p) {
                return Iterator.takeWhile$((Iterator)this, p);
            }

            public Iterator<byte[]> drop(int n) {
                return Iterator.drop$((Iterator)this, (int)n);
            }

            public Iterator<byte[]> dropWhile(Function1<byte[], Object> p) {
                return Iterator.dropWhile$((Iterator)this, p);
            }

            public Tuple2<Iterator<byte[]>, Iterator<byte[]>> span(Function1<byte[], Object> p) {
                return Iterator.span$((Iterator)this, p);
            }

            public Iterator<byte[]> slice(int from, int until) {
                return Iterator.slice$((Iterator)this, (int)from, (int)until);
            }

            public Iterator<byte[]> sliceIterator(int from, int until) {
                return Iterator.sliceIterator$((Iterator)this, (int)from, (int)until);
            }

            public <B> Iterator<Tuple2<byte[], B>> zip(IterableOnce<B> that) {
                return Iterator.zip$((Iterator)this, that);
            }

            public <A1, B> Iterator<Tuple2<A1, B>> zipAll(IterableOnce<B> that, A1 thisElem, B thatElem) {
                return Iterator.zipAll$((Iterator)this, that, thisElem, thatElem);
            }

            public Iterator<Tuple2<byte[], Object>> zipWithIndex() {
                return Iterator.zipWithIndex$((Iterator)this);
            }

            public <B> boolean sameElements(IterableOnce<B> that) {
                return Iterator.sameElements$((Iterator)this, that);
            }

            public Tuple2<Iterator<byte[]>, Iterator<byte[]>> duplicate() {
                return Iterator.duplicate$((Iterator)this);
            }

            public <B> Iterator<B> patch(int from, Iterator<B> patchElems, int replaced) {
                return Iterator.patch$((Iterator)this, (int)from, patchElems, (int)replaced);
            }

            public <U$> Iterator<byte[]> tapEach(Function1<byte[], U$> f) {
                return Iterator.tapEach$((Iterator)this, f);
            }

            public String toString() {
                return Iterator.toString$((Iterator)this);
            }

            public Iterator<byte[]> seq() {
                return Iterator.seq$((Iterator)this);
            }

            public Tuple2<Iterator<byte[]>, Iterator<byte[]>> splitAt(int n) {
                return IterableOnceOps.splitAt$((IterableOnceOps)this, (int)n);
            }

            public boolean isTraversableAgain() {
                return IterableOnceOps.isTraversableAgain$((IterableOnceOps)this);
            }

            public <U$> void foreach(Function1<byte[], U$> f) {
                IterableOnceOps.foreach$((IterableOnceOps)this, f);
            }

            public boolean forall(Function1<byte[], Object> p) {
                return IterableOnceOps.forall$((IterableOnceOps)this, p);
            }

            public boolean exists(Function1<byte[], Object> p) {
                return IterableOnceOps.exists$((IterableOnceOps)this, p);
            }

            public int count(Function1<byte[], Object> p) {
                return IterableOnceOps.count$((IterableOnceOps)this, p);
            }

            public Option<byte[]> find(Function1<byte[], Object> p) {
                return IterableOnceOps.find$((IterableOnceOps)this, p);
            }

            public <B> B foldLeft(B z, Function2<B, byte[], B> op) {
                return (B)IterableOnceOps.foldLeft$((IterableOnceOps)this, z, op);
            }

            public <B> B foldRight(B z, Function2<byte[], B, B> op) {
                return (B)IterableOnceOps.foldRight$((IterableOnceOps)this, z, op);
            }

            public final <B> B $div$colon(B z, Function2<B, byte[], B> op) {
                return (B)IterableOnceOps.$div$colon$((IterableOnceOps)this, z, op);
            }

            public final <B> B $colon$bslash(B z, Function2<byte[], B, B> op) {
                return (B)IterableOnceOps.$colon$bslash$((IterableOnceOps)this, z, op);
            }

            public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
                return (A1)IterableOnceOps.fold$((IterableOnceOps)this, z, op);
            }

            public <B> B reduce(Function2<B, B, B> op) {
                return (B)IterableOnceOps.reduce$((IterableOnceOps)this, op);
            }

            public <B> Option<B> reduceOption(Function2<B, B, B> op) {
                return IterableOnceOps.reduceOption$((IterableOnceOps)this, op);
            }

            public <B> B reduceLeft(Function2<B, byte[], B> op) {
                return (B)IterableOnceOps.reduceLeft$((IterableOnceOps)this, op);
            }

            public <B> B reduceRight(Function2<byte[], B, B> op) {
                return (B)IterableOnceOps.reduceRight$((IterableOnceOps)this, op);
            }

            public <B> Option<B> reduceLeftOption(Function2<B, byte[], B> op) {
                return IterableOnceOps.reduceLeftOption$((IterableOnceOps)this, op);
            }

            public <B> Option<B> reduceRightOption(Function2<byte[], B, B> op) {
                return IterableOnceOps.reduceRightOption$((IterableOnceOps)this, op);
            }

            public boolean nonEmpty() {
                return IterableOnceOps.nonEmpty$((IterableOnceOps)this);
            }

            public int size() {
                return IterableOnceOps.size$((IterableOnceOps)this);
            }

            public final <B> void copyToBuffer(Buffer<B> dest) {
                IterableOnceOps.copyToBuffer$((IterableOnceOps)this, dest);
            }

            public <B> int copyToArray(Object xs) {
                return IterableOnceOps.copyToArray$((IterableOnceOps)this, (Object)xs);
            }

            public <B> int copyToArray(Object xs, int start) {
                return IterableOnceOps.copyToArray$((IterableOnceOps)this, (Object)xs, (int)start);
            }

            public <B> int copyToArray(Object xs, int start, int len) {
                return IterableOnceOps.copyToArray$((IterableOnceOps)this, (Object)xs, (int)start, (int)len);
            }

            public <B> B sum(Numeric<B> num) {
                return (B)IterableOnceOps.sum$((IterableOnceOps)this, num);
            }

            public <B> B product(Numeric<B> num) {
                return (B)IterableOnceOps.product$((IterableOnceOps)this, num);
            }

            public Object min(Ordering ord) {
                return IterableOnceOps.min$((IterableOnceOps)this, (Ordering)ord);
            }

            public <B> Option<byte[]> minOption(Ordering<B> ord) {
                return IterableOnceOps.minOption$((IterableOnceOps)this, ord);
            }

            public Object max(Ordering ord) {
                return IterableOnceOps.max$((IterableOnceOps)this, (Ordering)ord);
            }

            public <B> Option<byte[]> maxOption(Ordering<B> ord) {
                return IterableOnceOps.maxOption$((IterableOnceOps)this, ord);
            }

            public Object maxBy(Function1 f, Ordering cmp) {
                return IterableOnceOps.maxBy$((IterableOnceOps)this, (Function1)f, (Ordering)cmp);
            }

            public <B> Option<byte[]> maxByOption(Function1<byte[], B> f, Ordering<B> cmp) {
                return IterableOnceOps.maxByOption$((IterableOnceOps)this, f, cmp);
            }

            public Object minBy(Function1 f, Ordering cmp) {
                return IterableOnceOps.minBy$((IterableOnceOps)this, (Function1)f, (Ordering)cmp);
            }

            public <B> Option<byte[]> minByOption(Function1<byte[], B> f, Ordering<B> cmp) {
                return IterableOnceOps.minByOption$((IterableOnceOps)this, f, cmp);
            }

            public <B> Option<B> collectFirst(PartialFunction<byte[], B> pf) {
                return IterableOnceOps.collectFirst$((IterableOnceOps)this, pf);
            }

            public <B> B aggregate(Function0<B> z, Function2<B, byte[], B> seqop, Function2<B, B, B> combop) {
                return (B)IterableOnceOps.aggregate$((IterableOnceOps)this, z, seqop, combop);
            }

            public <B> boolean corresponds(IterableOnce<B> that, Function2<byte[], B, Object> p) {
                return IterableOnceOps.corresponds$((IterableOnceOps)this, that, p);
            }

            public final String mkString(String start, String sep, String end) {
                return IterableOnceOps.mkString$((IterableOnceOps)this, (String)start, (String)sep, (String)end);
            }

            public final String mkString(String sep) {
                return IterableOnceOps.mkString$((IterableOnceOps)this, (String)sep);
            }

            public final String mkString() {
                return IterableOnceOps.mkString$((IterableOnceOps)this);
            }

            public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
                return IterableOnceOps.addString$((IterableOnceOps)this, (StringBuilder)b, (String)start, (String)sep, (String)end);
            }

            public final StringBuilder addString(StringBuilder b, String sep) {
                return IterableOnceOps.addString$((IterableOnceOps)this, (StringBuilder)b, (String)sep);
            }

            public final StringBuilder addString(StringBuilder b) {
                return IterableOnceOps.addString$((IterableOnceOps)this, (StringBuilder)b);
            }

            public <C1> C1 to(Factory<byte[], C1> factory) {
                return (C1)IterableOnceOps.to$((IterableOnceOps)this, factory);
            }

            public final Iterator<byte[]> toIterator() {
                return IterableOnceOps.toIterator$((IterableOnceOps)this);
            }

            public List<byte[]> toList() {
                return IterableOnceOps.toList$((IterableOnceOps)this);
            }

            public Vector<byte[]> toVector() {
                return IterableOnceOps.toVector$((IterableOnceOps)this);
            }

            public <K, V> Map<K, V> toMap(.less.colon.less<byte[], Tuple2<K, V>> ev) {
                return IterableOnceOps.toMap$((IterableOnceOps)this, ev);
            }

            public <B> Set<B> toSet() {
                return IterableOnceOps.toSet$((IterableOnceOps)this);
            }

            public Seq<byte[]> toSeq() {
                return IterableOnceOps.toSeq$((IterableOnceOps)this);
            }

            public IndexedSeq<byte[]> toIndexedSeq() {
                return IterableOnceOps.toIndexedSeq$((IterableOnceOps)this);
            }

            public final Stream<byte[]> toStream() {
                return IterableOnceOps.toStream$((IterableOnceOps)this);
            }

            public final <B> Buffer<B> toBuffer() {
                return IterableOnceOps.toBuffer$((IterableOnceOps)this);
            }

            public <B> Object toArray(ClassTag<B> evidence$2) {
                return IterableOnceOps.toArray$((IterableOnceOps)this, evidence$2);
            }

            public Iterable<byte[]> reversed() {
                return IterableOnceOps.reversed$((IterableOnceOps)this);
            }

            public <S extends Stepper<?>> S stepper(StepperShape<byte[], S> shape) {
                return (S)IterableOnce.stepper$((IterableOnce)this, shape);
            }

            public int knownSize() {
                return IterableOnce.knownSize$((IterableOnce)this);
            }

            private byte[] batch() {
                return this.batch;
            }

            private void batch_$eq(byte[] x$1) {
                this.batch = x$1;
            }

            public boolean hasNext() {
                return this.batch() != null;
            }

            /*
             * WARNING - void declaration
             */
            public byte[] next() {
                void var1_1;
                byte[] prevBatch = this.batch();
                this.batch_$eq(this.readNextBatch());
                return var1_1;
            }

            private byte[] readNextBatch() {
                int bodyLength;
                MessageMetadataResult msgMetadata;
                while (true) {
                    if ((msgMetadata = MessageSerializer.readMessage((ReadChannel)new ReadChannel(this.in$1))) == null) {
                        return null;
                    }
                    bodyLength = (int)msgMetadata.getMessageBodyLength();
                    if (msgMetadata.getMessage().headerType() == 3) break;
                    Object object = bodyLength > 0 ? BoxesRunTime.boxToLong((long)Channels.newInputStream(this.in$1).skip(bodyLength)) : BoxedUnit.UNIT;
                }
                ByteBufferOutputStream bbout = new ByteBufferOutputStream(8 + msgMetadata.getMessageLength() + bodyLength);
                MessageSerializer.writeMessageBuffer((WriteChannel)new WriteChannel(Channels.newChannel((OutputStream)bbout)), (int)msgMetadata.getMessageLength(), (ByteBuffer)msgMetadata.getMessageBuffer());
                bbout.close();
                ByteBuffer bb = bbout.toByteBuffer();
                bb.position(bbout.getCount());
                bb.limit(bb.capacity());
                JavaUtils.readFully((ReadableByteChannel)this.in$1, (ByteBuffer)bb);
                return bb.array();
            }
            {
                this.in$1 = in$1;
                IterableOnce.$init$((IterableOnce)this);
                IterableOnceOps.$init$((IterableOnceOps)this);
                Iterator.$init$((Iterator)this);
                this.batch = this.readNextBatch();
            }
        };
    }

    public void org$apache$spark$sql$execution$arrow$ArrowConverters$$closeAll(Seq<AutoCloseable> closeables) {
        closeables.foreach((Function1 & Serializable)closeable -> {
            ArrowConverters$.$anonfun$closeAll$1(closeable);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ long $anonfun$toDataFrame$1(byte[] x$4) {
        return x$4.length;
    }

    public static final /* synthetic */ void $anonfun$closeAll$1(AutoCloseable closeable) {
        block0: {
            if (closeable == null) break block0;
            closeable.close();
        }
    }

    private ArrowConverters$() {
    }
}

