/*
 * Decompiled with CFR 0.152.
 */
package coursierapi.shaded.xz.lzma;

import coursierapi.shaded.xz.lzma.State;
import coursierapi.shaded.xz.rangecoder.RangeCoder;

abstract class LZMACoder {
    final int posMask;
    final int[] reps = new int[4];
    final State state = new State();
    final short[][] isMatch = new short[12][16];
    final short[] isRep = new short[12];
    final short[] isRep0 = new short[12];
    final short[] isRep1 = new short[12];
    final short[] isRep2 = new short[12];
    final short[][] isRep0Long = new short[12][16];
    final short[][] distSlots = new short[4][64];
    final short[][] distSpecial = new short[][]{new short[2], new short[2], new short[4], new short[4], new short[8], new short[8], new short[16], new short[16], new short[32], new short[32]};
    final short[] distAlign = new short[16];

    static final int getDistState(int n) {
        return n < 6 ? n - 2 : 3;
    }

    LZMACoder(int n) {
        this.posMask = (1 << n) - 1;
    }

    void reset() {
        int n;
        this.reps[0] = 0;
        this.reps[1] = 0;
        this.reps[2] = 0;
        this.reps[3] = 0;
        this.state.reset();
        for (n = 0; n < this.isMatch.length; ++n) {
            RangeCoder.initProbs(this.isMatch[n]);
        }
        RangeCoder.initProbs(this.isRep);
        RangeCoder.initProbs(this.isRep0);
        RangeCoder.initProbs(this.isRep1);
        RangeCoder.initProbs(this.isRep2);
        for (n = 0; n < this.isRep0Long.length; ++n) {
            RangeCoder.initProbs(this.isRep0Long[n]);
        }
        for (n = 0; n < this.distSlots.length; ++n) {
            RangeCoder.initProbs(this.distSlots[n]);
        }
        for (n = 0; n < this.distSpecial.length; ++n) {
            RangeCoder.initProbs(this.distSpecial[n]);
        }
        RangeCoder.initProbs(this.distAlign);
    }

    abstract class LengthCoder {
        final short[] choice = new short[2];
        final short[][] low = new short[16][8];
        final short[][] mid = new short[16][8];
        final short[] high = new short[256];

        LengthCoder() {
        }

        void reset() {
            int n;
            RangeCoder.initProbs(this.choice);
            for (n = 0; n < this.low.length; ++n) {
                RangeCoder.initProbs(this.low[n]);
            }
            for (n = 0; n < this.low.length; ++n) {
                RangeCoder.initProbs(this.mid[n]);
            }
            RangeCoder.initProbs(this.high);
        }
    }

    abstract class LiteralCoder {
        private final int lc;
        private final int literalPosMask;

        LiteralCoder(int n, int n2) {
            this.lc = n;
            this.literalPosMask = (1 << n2) - 1;
        }

        final int getSubcoderIndex(int n, int n2) {
            int n3 = n >> 8 - this.lc;
            int n4 = (n2 & this.literalPosMask) << this.lc;
            return n3 + n4;
        }

        abstract class LiteralSubcoder {
            final short[] probs = new short[768];

            LiteralSubcoder() {
            }

            void reset() {
                RangeCoder.initProbs(this.probs);
            }
        }
    }
}

