/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.translator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.JoinOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.ReduceSinkOperator;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.lib.DefaultRuleDispatcher;
import org.apache.hadoop.hive.ql.lib.ForwardWalker;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessor;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.lib.Rule;
import org.apache.hadoop.hive.ql.lib.RuleRegExp;
import org.apache.hadoop.hive.ql.optimizer.Transform;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.JoinDesc;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;

public class HiveOpConverterPostProc
extends Transform {
    private ParseContext pctx;
    private Map<String, Operator<? extends OperatorDesc>> aliasToOpInfo;

    @Override
    public ParseContext transform(ParseContext pctx) throws SemanticException {
        boolean cboEnabled = HiveConf.getBoolVar((Configuration)pctx.getConf(), (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_CBO_ENABLED);
        boolean returnPathEnabled = HiveConf.getBoolVar((Configuration)pctx.getConf(), (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_CBO_RETPATH_HIVEOP);
        boolean cboSucceeded = pctx.getContext().isCboSucceeded();
        if (!(cboEnabled && returnPathEnabled && cboSucceeded)) {
            return pctx;
        }
        this.pctx = pctx;
        this.aliasToOpInfo = new HashMap<String, Operator<? extends OperatorDesc>>();
        LinkedHashMap<Rule, NodeProcessor> opRules = new LinkedHashMap<Rule, NodeProcessor>();
        opRules.put(new RuleRegExp("R1", JoinOperator.getOperatorName() + "%"), new JoinAnnotate());
        opRules.put(new RuleRegExp("R2", TableScanOperator.getOperatorName() + "%"), new TableScanAnnotate());
        DefaultRuleDispatcher disp = new DefaultRuleDispatcher(null, opRules, null);
        ForwardWalker ogw = new ForwardWalker(disp);
        ArrayList<Node> topNodes = new ArrayList<Node>();
        topNodes.addAll(pctx.getTopOps().values());
        ogw.startWalking(topNodes, null);
        return pctx;
    }

    private class TableScanAnnotate
    implements NodeProcessor {
        private TableScanAnnotate() {
        }

        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            TableScanOperator tableScanOp = (TableScanOperator)nd;
            String opAlias = null;
            for (Map.Entry<String, TableScanOperator> topOpEntry : HiveOpConverterPostProc.this.pctx.getTopOps().entrySet()) {
                if (topOpEntry.getValue() != tableScanOp) continue;
                opAlias = topOpEntry.getKey();
            }
            assert (opAlias != null);
            HiveOpConverterPostProc.this.aliasToOpInfo.put(opAlias, tableScanOp);
            return null;
        }
    }

    private class JoinAnnotate
    implements NodeProcessor {
        private JoinAnnotate() {
        }

        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            JoinOperator joinOp = (JoinOperator)nd;
            String[] baseSrc = new String[joinOp.getParentOperators().size()];
            String[] rightAliases = new String[joinOp.getParentOperators().size() - 1];
            for (int i = 0; i < joinOp.getParentOperators().size(); ++i) {
                ReduceSinkOperator rsOp = (ReduceSinkOperator)joinOp.getParentOperators().get(i);
                Set<String> aliases = rsOp.getSchema().getTableNames();
                if (aliases == null || aliases.size() != 1) {
                    throw new SemanticException("In return path join annotate rule, we find " + aliases == null ? null : aliases.size() + " aliases for " + rsOp.toString());
                }
                baseSrc[i] = aliases.iterator().next();
                if (i == 0) {
                    ((JoinDesc)joinOp.getConf()).setLeftAlias(baseSrc[i]);
                    continue;
                }
                rightAliases[i - 1] = baseSrc[i];
            }
            ((JoinDesc)joinOp.getConf()).setBaseSrc(baseSrc);
            ((JoinDesc)joinOp.getConf()).setRightAliases(rightAliases);
            ((JoinDesc)joinOp.getConf()).setAliasToOpInfo(HiveOpConverterPostProc.this.aliasToOpInfo);
            Set<String> aliases = joinOp.getSchema().getTableNames();
            if (aliases == null || aliases.size() != 1) {
                throw new SemanticException("In return path join annotate rule, we find " + aliases == null ? null : aliases.size() + " aliases for " + joinOp.toString());
            }
            String joinOpAlias = aliases.iterator().next();
            HiveOpConverterPostProc.this.aliasToOpInfo.put(joinOpAlias, joinOp);
            HiveOpConverterPostProc.this.pctx.getJoinOps().add(joinOp);
            return null;
        }
    }
}

