/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.StringInstr$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.util.CollationSupport;
import org.apache.spark.sql.internal.types.StringTypeNonCSAICollation$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(str, substr) - Returns the (1-based) index of the first occurrence of `substr` in `str`.", examples="\n    Examples:\n      > SELECT _FUNC_('SparkSQL', 'SQL');\n       6\n  ", since="1.5.0", group="string_funcs")
@ScalaSignature(bytes="\u0006\u0005\u0005uh\u0001B\u0011#\u0001>B\u0001\"\u0013\u0001\u0003\u0016\u0004%\tA\u0013\u0005\t\u001d\u0002\u0011\t\u0012)A\u0005\u0017\"Aq\n\u0001BK\u0002\u0013\u0005!\n\u0003\u0005Q\u0001\tE\t\u0015!\u0003L\u0011\u0015\t\u0006\u0001\"\u0001S\u0011\u00151\u0006\u0001\"\u0011X\u0011!Y\u0006\u0001#b\u0001\n\u000ba\u0006\"\u00021\u0001\t\u0003R\u0005\"B1\u0001\t\u0003R\u0005\"\u00022\u0001\t\u0003\u001a\u0007\"\u00026\u0001\t\u0003Z\u0007\"\u0002:\u0001\t\u0003\u001a\b\"B>\u0001\t\u0003b\bbBA\u0006\u0001\u0011\u0005\u0013Q\u0002\u0005\b\u0003S\u0001A\u0011KA\u0016\u0011%\t)\u0004AA\u0001\n\u0003\t9\u0004C\u0005\u0002>\u0001\t\n\u0011\"\u0001\u0002@!I\u0011Q\u000b\u0001\u0012\u0002\u0013\u0005\u0011q\b\u0005\n\u0003/\u0002\u0011\u0011!C!\u00033B\u0001\"!\u001b\u0001\u0003\u0003%\t\u0001\u0018\u0005\n\u0003W\u0002\u0011\u0011!C\u0001\u0003[B\u0011\"a\u001d\u0001\u0003\u0003%\t%!\u001e\t\u0013\u0005\r\u0005!!A\u0005\u0002\u0005\u0015\u0005\"CAE\u0001\u0005\u0005I\u0011IAF\u0011%\ty\tAA\u0001\n\u0003\n\tjB\u0005\u00026\n\n\t\u0011#\u0001\u00028\u001aA\u0011EIA\u0001\u0012\u0003\tI\f\u0003\u0004R7\u0011\u0005\u0011\u0011\u001b\u0005\n\u0003'\\\u0012\u0011!C#\u0003+D\u0011\"a6\u001c\u0003\u0003%\t)!7\t\u0013\u0005}7$!A\u0005\u0002\u0006\u0005\b\"CAz7\u0005\u0005I\u0011BA{\u0005-\u0019FO]5oO&s7\u000f\u001e:\u000b\u0005\r\"\u0013aC3yaJ,7o]5p]NT!!\n\u0014\u0002\u0011\r\fG/\u00197zgRT!a\n\u0015\u0002\u0007M\fHN\u0003\u0002*U\u0005)1\u000f]1sW*\u00111\u0006L\u0001\u0007CB\f7\r[3\u000b\u00035\n1a\u001c:h\u0007\u0001\u0019R\u0001\u0001\u00195ou\u0002\"!\r\u001a\u000e\u0003\tJ!a\r\u0012\u0003!\tKg.\u0019:z\u000bb\u0004(/Z:tS>t\u0007CA\u00196\u0013\t1$E\u0001\fJ[Bd\u0017nY5u\u0007\u0006\u001cH/\u00138qkR$\u0016\u0010]3t!\tA4(D\u0001:\u0015\u0005Q\u0014!B:dC2\f\u0017B\u0001\u001f:\u0005\u001d\u0001&o\u001c3vGR\u0004\"A\u0010$\u000f\u0005}\"eB\u0001!D\u001b\u0005\t%B\u0001\"/\u0003\u0019a$o\\8u}%\t!(\u0003\u0002Fs\u00059\u0001/Y2lC\u001e,\u0017BA$I\u00051\u0019VM]5bY&T\u0018M\u00197f\u0015\t)\u0015(A\u0002tiJ,\u0012a\u0013\t\u0003c1K!!\u0014\u0012\u0003\u0015\u0015C\bO]3tg&|g.\u0001\u0003tiJ\u0004\u0013AB:vEN$(/A\u0004tk\n\u001cHO\u001d\u0011\u0002\rqJg.\u001b;?)\r\u0019F+\u0016\t\u0003c\u0001AQ!S\u0003A\u0002-CQaT\u0003A\u0002-\u000baB\\;mY&sGo\u001c7fe\u0006tG/F\u0001Y!\tA\u0014,\u0003\u0002[s\t9!i\\8mK\u0006t\u0017aC2pY2\fG/[8o\u0013\u0012,\u0012!\u0018\t\u0003qyK!aX\u001d\u0003\u0007%sG/\u0001\u0003mK\u001a$\u0018!\u0002:jO\"$\u0018\u0001\u00033bi\u0006$\u0016\u0010]3\u0016\u0003\u0011\u0004\"!\u001a5\u000e\u0003\u0019T!a\u001a\u0014\u0002\u000bQL\b/Z:\n\u0005%4'\u0001\u0003#bi\u0006$\u0016\u0010]3\u0002\u0015%t\u0007/\u001e;UsB,7/F\u0001m!\rqTn\\\u0005\u0003]\"\u00131aU3r!\t)\u0007/\u0003\u0002rM\n\u0001\u0012IY:ue\u0006\u001cG\u000fR1uCRK\b/Z\u0001\r]VdGnU1gK\u00163\u0018\r\u001c\u000b\u0004i^L\bC\u0001\u001dv\u0013\t1\u0018HA\u0002B]fDQ\u0001\u001f\u0007A\u0002Q\faa\u001d;sS:<\u0007\"\u0002>\r\u0001\u0004!\u0018aA:vE\u0006Q\u0001O]3uift\u0015-\\3\u0016\u0003u\u00042A`A\u0003\u001d\ry\u0018\u0011\u0001\t\u0003\u0001fJ1!a\u0001:\u0003\u0019\u0001&/\u001a3fM&!\u0011qAA\u0005\u0005\u0019\u0019FO]5oO*\u0019\u00111A\u001d\u0002\u0013\u0011|w)\u001a8D_\u0012,GCBA\b\u00037\t)\u0003\u0005\u0003\u0002\u0012\u0005]QBAA\n\u0015\r\t)BI\u0001\bG>$WmZ3o\u0013\u0011\tI\"a\u0005\u0003\u0011\u0015C\bO]\"pI\u0016Dq!!\b\u000f\u0001\u0004\ty\"A\u0002dib\u0004B!!\u0005\u0002\"%!\u00111EA\n\u00059\u0019u\u000eZ3hK:\u001cuN\u001c;fqRDq!a\n\u000f\u0001\u0004\ty!\u0001\u0002fm\u00069r/\u001b;i\u001d\u0016<8\t[5mIJ,g.\u00138uKJt\u0017\r\u001c\u000b\u0006'\u00065\u0012\u0011\u0007\u0005\u0007\u0003_y\u0001\u0019A&\u0002\u000f9,w\u000fT3gi\"1\u00111G\bA\u0002-\u000b\u0001B\\3x%&<\u0007\u000e^\u0001\u0005G>\u0004\u0018\u0010F\u0003T\u0003s\tY\u0004C\u0004J!A\u0005\t\u0019A&\t\u000f=\u0003\u0002\u0013!a\u0001\u0017\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAA!U\rY\u00151I\u0016\u0003\u0003\u000b\u0002B!a\u0012\u0002R5\u0011\u0011\u0011\n\u0006\u0005\u0003\u0017\ni%A\u0005v]\u000eDWmY6fI*\u0019\u0011qJ\u001d\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002T\u0005%#!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012\u0014!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002\\A!\u0011QLA4\u001b\t\tyF\u0003\u0003\u0002b\u0005\r\u0014\u0001\u00027b]\u001eT!!!\u001a\u0002\t)\fg/Y\u0005\u0005\u0003\u000f\ty&\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\u0007Q\fy\u0007\u0003\u0005\u0002rU\t\t\u00111\u0001^\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u0011q\u000f\t\u0006\u0003s\ny\b^\u0007\u0003\u0003wR1!! :\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003\u0003\u000bYH\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dGc\u0001-\u0002\b\"A\u0011\u0011O\f\u0002\u0002\u0003\u0007A/\u0001\nqe>$Wo\u0019;FY\u0016lWM\u001c;OC6,G\u0003BA.\u0003\u001bC\u0001\"!\u001d\u0019\u0003\u0003\u0005\r!X\u0001\u0007KF,\u0018\r\\:\u0015\u0007a\u000b\u0019\n\u0003\u0005\u0002re\t\t\u00111\u0001uQM\u0001\u0011qSAO\u0003?\u000b\u0019+!*\u0002*\u0006-\u0016qVAY!\r\t\u0014\u0011T\u0005\u0004\u00037\u0013#!F#yaJ,7o]5p]\u0012+7o\u0019:jaRLwN\\\u0001\u0006kN\fw-Z\u0011\u0003\u0003C\u000bql\u0018$V\u001d\u000e{\u0006f\u001d;sY\u0001\u001aXOY:ue&\u0002S\u0006\t*fiV\u0014hn\u001d\u0011uQ\u0016\u0004\u0003&M\u0017cCN,G-\u000b\u0011j]\u0012,\u0007\u0010I8gAQDW\r\t4jeN$\be\\2dkJ\u0014XM\\2fA=4\u0007\u0005Y:vEN$(\u000f\u0019\u0011j]\u0002\u00027\u000f\u001e:a]\u0005AQ\r_1na2,7/\t\u0002\u0002(\u0006!%\u0002\t\u0011!A\u0015C\u0018-\u001c9mKNT$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK\u0014Ta\u0006\u00148nU)MO1\u0002seU)MO%Z$\u0002\t\u0011!A\u0001\u0002\u0003E\u000e\u0006!A\u0005)1/\u001b8dK\u0006\u0012\u0011QV\u0001\u0006c9*d\u0006M\u0001\u0006OJ|W\u000f]\u0011\u0003\u0003g\u000bAb\u001d;sS:<wLZ;oGN\f1b\u0015;sS:<\u0017J\\:ueB\u0011\u0011gG\n\u00067\u0005m\u0016q\u0019\t\b\u0003{\u000b\u0019mS&T\u001b\t\tyLC\u0002\u0002Bf\nqA];oi&lW-\u0003\u0003\u0002F\u0006}&!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8oeA!\u0011\u0011ZAh\u001b\t\tYM\u0003\u0003\u0002N\u0006\r\u0014AA5p\u0013\r9\u00151\u001a\u000b\u0003\u0003o\u000b\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u00037\nQ!\u00199qYf$RaUAn\u0003;DQ!\u0013\u0010A\u0002-CQa\u0014\u0010A\u0002-\u000bq!\u001e8baBd\u0017\u0010\u0006\u0003\u0002d\u0006=\b#\u0002\u001d\u0002f\u0006%\u0018bAAts\t1q\n\u001d;j_:\u0004R\u0001OAv\u0017.K1!!<:\u0005\u0019!V\u000f\u001d7fe!A\u0011\u0011_\u0010\u0002\u0002\u0003\u00071+A\u0002yIA\nAb\u001e:ji\u0016\u0014V\r\u001d7bG\u0016$\"!a>\u0011\t\u0005u\u0013\u0011`\u0005\u0005\u0003w\fyF\u0001\u0004PE*,7\r\u001e")
public class StringInstr
extends BinaryExpression
implements ImplicitCastInputTypes,
Serializable {
    private int collationId;
    private final Expression str;
    private final Expression substr;
    private volatile boolean bitmap$0;

    public static Option<Tuple2<Expression, Expression>> unapply(StringInstr x$0) {
        return StringInstr$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple2<Expression, Expression>, StringInstr> tupled() {
        return StringInstr$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, StringInstr>> curried() {
        return StringInstr$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    public Expression str() {
        return this.str;
    }

    public Expression substr() {
        return this.substr;
    }

    @Override
    public boolean nullIntolerant() {
        return true;
    }

    private int collationId$lzycompute() {
        StringInstr stringInstr = this;
        synchronized (stringInstr) {
            if (!this.bitmap$0) {
                this.collationId = ((StringType)this.left().dataType()).collationId();
                this.bitmap$0 = true;
            }
        }
        return this.collationId;
    }

    public final int collationId() {
        if (!this.bitmap$0) {
            return this.collationId$lzycompute();
        }
        return this.collationId;
    }

    @Override
    public Expression left() {
        return this.str();
    }

    @Override
    public Expression right() {
        return this.substr();
    }

    @Override
    public DataType dataType() {
        return IntegerType$.MODULE$;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return new .colon.colon((Object)StringTypeNonCSAICollation$.MODULE$.apply(true), (List)new .colon.colon((Object)StringTypeNonCSAICollation$.MODULE$.apply(true), (List)Nil$.MODULE$));
    }

    @Override
    public Object nullSafeEval(Object string, Object sub) {
        return BoxesRunTime.boxToInteger((int)(CollationSupport.StringInstr.exec((UTF8String)((UTF8String)string), (UTF8String)((UTF8String)sub), (int)this.collationId()) + 1));
    }

    @Override
    public String prettyName() {
        return "instr";
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.defineCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable)(string, substring) -> CollationSupport.StringInstr.genCode((String)string, (String)substring, (int)this.collationId()) + " + 1");
    }

    @Override
    public StringInstr withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight);
    }

    public StringInstr copy(Expression str, Expression substr) {
        return new StringInstr(str, substr);
    }

    public Expression copy$default$1() {
        return this.str();
    }

    public Expression copy$default$2() {
        return this.substr();
    }

    @Override
    public String productPrefix() {
        return "StringInstr";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.str();
            }
            case 1: {
                return this.substr();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof StringInstr;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "str";
            }
            case 1: {
                return "substr";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof StringInstr)) return false;
        boolean bl = true;
        if (!bl) return false;
        StringInstr stringInstr = (StringInstr)x$1;
        Expression expression = this.str();
        Expression expression2 = stringInstr.str();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.substr();
        Expression expression4 = stringInstr.substr();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!stringInstr.canEqual(this)) return false;
        return true;
    }

    public StringInstr(Expression str, Expression substr) {
        this.str = str;
        this.substr = substr;
        ExpectsInputTypes.$init$(this);
    }
}

