#
# Licensed to the Apache Software Foundation (ASF) under one or more
# contributor license agreements.  See the NOTICE file distributed with
# this work for additional information regarding copyright ownership.
# The ASF licenses this file to You under the Apache License, Version 2.0
# (the "License"); you may not use this file except in compliance with
# the License.  You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

"""Spark Connect Python Client - ML module"""
from pyspark.sql.connect.utils import check_dependencies

check_dependencies(__name__)

from pyspark.ml.connect.base import (
    Estimator,
    Transformer,
    Model,
)
from pyspark.ml.connect import (
    feature,
    evaluation,
    tuning,
)
from pyspark.ml.connect.evaluation import Evaluator
from pyspark.ml.connect.pipeline import Pipeline, PipelineModel

__all__ = [
    "Estimator",
    "Transformer",
    "Evaluator",
    "Model",
    "feature",
    "evaluation",
    "Pipeline",
    "PipelineModel",
    "tuning",
]
