/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import org.apache.spark.scheduler.HighlyCompressedMapStatus$;
import org.apache.spark.scheduler.MapStatus;
import org.apache.spark.scheduler.MapStatus$;
import org.apache.spark.storage.BlockManagerId;
import org.apache.spark.storage.BlockManagerId$;
import org.apache.spark.util.Utils$;
import org.roaringbitmap.RoaringBitmap;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.mutable.Map$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0005Ec!\u0002\r\u001a\u0001m\t\u0003\u0002\u0003\u001b\u0001\u0005\u0003\u0005\u000b\u0015\u0002\u001c\t\u0011q\u0002!\u0011!Q!\nuB\u0001\u0002\u0011\u0001\u0003\u0002\u0003\u0006K!\u0011\u0005\t\u000f\u0002\u0011\t\u0011)Q\u0005\u0011\"A1\n\u0001B\u0001B\u0003&A\n\u0003\u0005V\u0001\t\u0005\t\u0015)\u0003I\u0011!1\u0006A!A!B\u0013A\u0005\"B,\u0001\t\u0013A\u0006\"B,\u0001\t#\t\u0007\"\u00022\u0001\t\u0003\u001a\u0007\"\u00023\u0001\t\u0003*\u0007\"B6\u0001\t\u0003b\u0007\"B8\u0001\t\u0003\u0002\b\"B9\u0001\t\u0003\u0002\b\"\u0002:\u0001\t\u0003\u001a\b\"B=\u0001\t\u0003Rx\u0001CA\u00013!\u00051$a\u0001\u0007\u000faI\u0002\u0012A\u000e\u0002\u0006!1qK\u0005C\u0001\u0003\u001bAq!a\u0004\u0013\t\u0003\t\t\u0002C\u0005\u0002(I\t\n\u0011\"\u0001\u0002*!I\u0011q\b\n\u0012\u0002\u0013%\u0011\u0011\u0006\u0005\n\u0003\u0003\u0012\u0012\u0011!C\u0005\u0003\u0007\u0012\u0011\u0004S5hQ2L8i\\7qe\u0016\u001c8/\u001a3NCB\u001cF/\u0019;vg*\u0011!dG\u0001\ng\u000eDW\rZ;mKJT!\u0001H\u000f\u0002\u000bM\u0004\u0018M]6\u000b\u0005yy\u0012AB1qC\u000eDWMC\u0001!\u0003\ry'oZ\n\u0005\u0001\tBC\u0006\u0005\u0002$M5\tAEC\u0001&\u0003\u0015\u00198-\u00197b\u0013\t9CE\u0001\u0004B]f\u0014VM\u001a\t\u0003S)j\u0011!G\u0005\u0003We\u0011\u0011\"T1q'R\fG/^:\u0011\u00055\u0012T\"\u0001\u0018\u000b\u0005=\u0002\u0014AA5p\u0015\u0005\t\u0014\u0001\u00026bm\u0006L!a\r\u0018\u0003\u001d\u0015CH/\u001a:oC2L'0\u00192mK\u0006\u0019An\\2\u0004\u0001A\u0011qGO\u0007\u0002q)\u0011\u0011hG\u0001\bgR|'/Y4f\u0013\tY\u0004H\u0001\bCY>\u001c7.T1oC\u001e,'/\u00133\u0002#9,XNT8o\u000b6\u0004H/\u001f\"m_\u000e\\7\u000f\u0005\u0002$}%\u0011q\b\n\u0002\u0004\u0013:$\u0018aC3naRL(\t\\8dWN\u0004\"AQ#\u000e\u0003\rS!\u0001R\u0010\u0002\u001bI|\u0017M]5oO\nLG/\\1q\u0013\t15IA\u0007S_\u0006\u0014\u0018N\\4CSRl\u0017\r]\u0001\bCZ<7+\u001b>f!\t\u0019\u0013*\u0003\u0002KI\t!Aj\u001c8h\u00039AWoZ3CY>\u001c7nU5{KN\u0004B!\u0014)>%6\taJ\u0003\u0002PI\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005Es%aA'baB\u00111eU\u0005\u0003)\u0012\u0012AAQ=uK\u0006Qq,\\1q)\u0006\u001c8.\u00133\u0002\u0019}\u001b\u0007.Z2lgVlg+\u00197\u0002\rqJg.\u001b;?)!I&l\u0017/^=~\u0003\u0007CA\u0015\u0001\u0011\u0015!\u0004\u00021\u00017\u0011\u0015a\u0004\u00021\u0001>\u0011\u0015\u0001\u0005\u00021\u0001B\u0011\u00159\u0005\u00021\u0001I\u0011\u0015Y\u0005\u00021\u0001M\u0011\u0015)\u0006\u00021\u0001I\u0011\u001d1\u0006\u0002%AA\u0002!#\u0012!W\u0001\tY>\u001c\u0017\r^5p]V\ta'\u0001\bva\u0012\fG/\u001a'pG\u0006$\u0018n\u001c8\u0015\u0005\u0019L\u0007CA\u0012h\u0013\tAGE\u0001\u0003V]&$\b\"\u00026\f\u0001\u00041\u0014A\u00028fo2{7-A\bhKR\u001c\u0016N_3G_J\u0014En\\2l)\tAU\u000eC\u0003o\u0019\u0001\u0007Q(\u0001\u0005sK\u0012,8-Z%e\u0003\u0015i\u0017\r]%e+\u0005A\u0015!D2iK\u000e\\7/^7WC2,X-A\u0007xe&$X-\u0012=uKJt\u0017\r\u001c\u000b\u0003MRDQ!^\bA\u0002Y\f1a\\;u!\tis/\u0003\u0002y]\taqJ\u00196fGR|U\u000f\u001e9vi\u0006a!/Z1e\u000bb$XM\u001d8bYR\u0011am\u001f\u0005\u0006yB\u0001\r!`\u0001\u0003S:\u0004\"!\f@\n\u0005}t#aC(cU\u0016\u001cG/\u00138qkR\f\u0011\u0004S5hQ2L8i\\7qe\u0016\u001c8/\u001a3NCB\u001cF/\u0019;vgB\u0011\u0011FE\n\u0005%\t\n9\u0001E\u0002.\u0003\u0013I1!a\u0003/\u00051\u0019VM]5bY&T\u0018M\u00197f)\t\t\u0019!A\u0003baBd\u0017\u0010F\u0005Z\u0003'\t)\"a\b\u0002$!)A\u0007\u0006a\u0001m!9\u0011q\u0003\u000bA\u0002\u0005e\u0011!E;oG>l\u0007O]3tg\u0016$7+\u001b>fgB!1%a\u0007I\u0013\r\ti\u0002\n\u0002\u0006\u0003J\u0014\u0018-\u001f\u0005\u0007\u0003C!\u0002\u0019\u0001%\u0002\u00135\f\u0007\u000fV1tW&#\u0007\u0002CA\u0013)A\u0005\t\u0019\u0001%\u0002\u0017\rDWmY6tk64\u0016\r\\\u0001\u0010CB\u0004H.\u001f\u0013eK\u001a\fW\u000f\u001c;%iU\u0011\u00111\u0006\u0016\u0004\u0011\u000652FAA\u0018!\u0011\t\t$a\u000f\u000e\u0005\u0005M\"\u0002BA\u001b\u0003o\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005eB%\u0001\u0006b]:|G/\u0019;j_:LA!!\u0010\u00024\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00138\u000319(/\u001b;f%\u0016\u0004H.Y2f)\t\t)\u0005\u0005\u0003\u0002H\u00055SBAA%\u0015\r\tY\u0005M\u0001\u0005Y\u0006tw-\u0003\u0003\u0002P\u0005%#AB(cU\u0016\u001cG\u000f")
public class HighlyCompressedMapStatus
implements MapStatus,
Externalizable {
    private BlockManagerId loc;
    private int numNonEmptyBlocks;
    private RoaringBitmap emptyBlocks;
    private long avgSize;
    private Map<Object, Object> hugeBlockSizes;
    private long _mapTaskId;
    private long _checksumVal;

    public static long apply$default$4() {
        return HighlyCompressedMapStatus$.MODULE$.apply$default$4();
    }

    public static HighlyCompressedMapStatus apply(BlockManagerId loc, long[] uncompressedSizes, long mapTaskId, long checksumVal) {
        return HighlyCompressedMapStatus$.MODULE$.apply(loc, uncompressedSizes, mapTaskId, checksumVal);
    }

    @Override
    public BlockManagerId location() {
        return this.loc;
    }

    @Override
    public void updateLocation(BlockManagerId newLoc) {
        this.loc = newLoc;
    }

    @Override
    public long getSizeForBlock(int reduceId) {
        Predef$.MODULE$.assert(this.hugeBlockSizes != null);
        if (this.emptyBlocks.contains(reduceId)) {
            return 0L;
        }
        Option option = this.hugeBlockSizes.get((Object)BoxesRunTime.boxToInteger((int)reduceId));
        if (option instanceof Some) {
            Some some = (Some)option;
            byte size = BoxesRunTime.unboxToByte((Object)some.value());
            return MapStatus$.MODULE$.decompressSize(size);
        }
        if (None$.MODULE$.equals(option)) {
            return this.avgSize;
        }
        throw new MatchError((Object)option);
    }

    @Override
    public long mapId() {
        return this._mapTaskId;
    }

    @Override
    public long checksumValue() {
        return this._checksumVal;
    }

    @Override
    public void writeExternal(ObjectOutput out) {
        Utils$.MODULE$.tryOrIOException((JFunction0.mcV.sp & Serializable)() -> {
            $this.loc.writeExternal(out);
            $this.emptyBlocks.serialize((DataOutput)out);
            out.writeLong($this.avgSize);
            out.writeInt($this.hugeBlockSizes.size());
            $this.hugeBlockSizes.foreach((Function1 & Serializable)kv -> {
                HighlyCompressedMapStatus.$anonfun$writeExternal$3(out, kv);
                return BoxedUnit.UNIT;
            });
            out.writeLong($this._mapTaskId);
            out.writeLong($this._checksumVal);
        });
    }

    @Override
    public void readExternal(ObjectInput in) {
        Utils$.MODULE$.tryOrIOException((JFunction0.mcV.sp & Serializable)() -> {
            $this.loc = BlockManagerId$.MODULE$.apply(in);
            $this.numNonEmptyBlocks = -1;
            $this.emptyBlocks = new RoaringBitmap();
            $this.emptyBlocks.deserialize((DataInput)in);
            $this.avgSize = in.readLong();
            int count = in.readInt();
            scala.collection.mutable.Map hugeBlockSizesImpl = (scala.collection.mutable.Map)Map$.MODULE$.empty();
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), count).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$2 -> {
                int block = in.readInt();
                byte size = in.readByte();
                hugeBlockSizesImpl.update((Object)BoxesRunTime.boxToInteger((int)block), (Object)BoxesRunTime.boxToByte((byte)size));
            });
            $this.hugeBlockSizes = hugeBlockSizesImpl;
            $this._mapTaskId = in.readLong();
            $this._checksumVal = in.readLong();
        });
    }

    public static final /* synthetic */ void $anonfun$writeExternal$3(ObjectOutput out$2, Tuple2 kv) {
        out$2.writeInt(kv._1$mcI$sp());
        out$2.writeByte(BoxesRunTime.unboxToByte((Object)kv._2()));
    }

    public HighlyCompressedMapStatus(BlockManagerId loc, int numNonEmptyBlocks, RoaringBitmap emptyBlocks, long avgSize, Map<Object, Object> hugeBlockSizes, long _mapTaskId, long _checksumVal) {
        this.loc = loc;
        this.numNonEmptyBlocks = numNonEmptyBlocks;
        this.emptyBlocks = emptyBlocks;
        this.avgSize = avgSize;
        this.hugeBlockSizes = hugeBlockSizes;
        this._mapTaskId = _mapTaskId;
        this._checksumVal = _checksumVal;
        MapStatus.$init$(this);
        Predef$.MODULE$.require(this.loc == null || this.avgSize > 0L || this.hugeBlockSizes.size() > 0 || this.numNonEmptyBlocks == 0 || this._mapTaskId > 0L, (Function0 & Serializable)() -> "Average size can only be zero for map stages that produced no output");
    }

    public HighlyCompressedMapStatus() {
        this(null, -1, null, -1L, null, -1L, 0L);
    }
}

