/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.reloperators;

import com.google.common.collect.ImmutableList;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelCollationTraitDef;
import org.apache.calcite.rel.RelDistribution;
import org.apache.calcite.rel.RelDistributionTraitDef;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.SortExchange;
import org.apache.calcite.rex.RexNode;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;

public class HiveSortExchange
extends SortExchange {
    private ImmutableList<RexNode> joinKeys;
    private ExprNodeDesc[] joinExpressions;

    private HiveSortExchange(RelOptCluster cluster, RelTraitSet traitSet, RelNode input, RelDistribution distribution, RelCollation collation, ImmutableList<RexNode> joinKeys) {
        super(cluster, traitSet, input, distribution, collation);
        this.joinKeys = new ImmutableList.Builder().addAll(joinKeys).build();
    }

    public static HiveSortExchange create(RelNode input, RelDistribution distribution, RelCollation collation, ImmutableList<RexNode> joinKeys) {
        RelOptCluster cluster = input.getCluster();
        distribution = (RelDistribution)RelDistributionTraitDef.INSTANCE.canonize((RelTrait)distribution);
        collation = (RelCollation)RelCollationTraitDef.INSTANCE.canonize((RelTrait)collation);
        RelTraitSet traitSet = RelTraitSet.createEmpty().plus((RelTrait)distribution).plus((RelTrait)collation);
        return new HiveSortExchange(cluster, traitSet, input, distribution, collation, joinKeys);
    }

    public SortExchange copy(RelTraitSet traitSet, RelNode newInput, RelDistribution newDistribution, RelCollation newCollation) {
        return new HiveSortExchange(this.getCluster(), traitSet, newInput, newDistribution, newCollation, this.joinKeys);
    }

    public ImmutableList<RexNode> getJoinKeys() {
        return this.joinKeys;
    }

    public void setJoinKeys(ImmutableList<RexNode> joinKeys) {
        this.joinKeys = joinKeys;
    }

    public ExprNodeDesc[] getJoinExpressions() {
        return this.joinExpressions;
    }

    public void setJoinExpressions(ExprNodeDesc[] joinExpressions) {
        this.joinExpressions = joinExpressions;
    }
}

