/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.text.BreakIterator;
import java.util.ArrayList;
import java.util.Locale;
import javax.crypto.Cipher;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.spark.SparkBuildInfo;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.errors.QueryExecutionErrors;
import org.apache.spark.unsafe.types.UTF8String;
import org.apache.spark.util.VersionUtils;
import org.apache.spark.util.random.XORShiftRandom;

public class ExpressionImplUtils {
    private static final SecureRandom secureRandom = new SecureRandom();
    private static final int GCM_IV_LEN = 12;
    private static final int GCM_TAG_LEN = 128;
    private static final int CBC_IV_LEN = 16;

    public static boolean isLuhnNumber(UTF8String numberString) {
        String digits = numberString.toString();
        if (digits.isEmpty()) {
            return false;
        }
        int checkSum = 0;
        boolean isSecond = false;
        for (int i = digits.length() - 1; i >= 0; --i) {
            char ch = digits.charAt(i);
            if (!Character.isDigit(ch)) {
                return false;
            }
            int digit = Character.getNumericValue(ch);
            int doubled = isSecond ? digit * 2 : digit;
            checkSum += doubled % 10 + doubled / 10;
            isSecond = !isSecond;
        }
        return checkSum % 10 == 0;
    }

    public static UTF8String validateUTF8String(UTF8String utf8String) {
        if (utf8String.isValid()) {
            return utf8String;
        }
        throw QueryExecutionErrors.invalidUTF8StringError(utf8String);
    }

    public static UTF8String tryValidateUTF8String(UTF8String utf8String) {
        if (utf8String.isValid()) {
            return utf8String;
        }
        return null;
    }

    public static byte[] aesEncrypt(byte[] input, byte[] key, UTF8String mode, UTF8String padding, byte[] iv, byte[] aad) {
        return ExpressionImplUtils.aesInternal(input, key, mode.toString(), padding.toString(), 1, iv, aad);
    }

    public static byte[] aesDecrypt(byte[] input, byte[] key, UTF8String mode, UTF8String padding, byte[] aad) {
        return ExpressionImplUtils.aesInternal(input, key, mode.toString(), padding.toString(), 2, null, aad);
    }

    public static UTF8String getSparkVersion() {
        String shortVersion = VersionUtils.shortVersion((String)SparkBuildInfo.spark_version());
        String revision = SparkBuildInfo.spark_revision();
        return UTF8String.fromString((String)(shortVersion + " " + revision));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static SecretKeySpec getSecretKeySpec(byte[] key) {
        switch (key.length) {
            case 16: 
            case 24: 
            case 32: {
                return new SecretKeySpec(key, 0, key.length, "AES");
            }
            default: {
                throw QueryExecutionErrors.invalidAesKeyLengthError(key.length);
            }
        }
    }

    private static byte[] generateIv(CipherMode mode) {
        byte[] iv = new byte[mode.ivLength];
        secureRandom.nextBytes(iv);
        return iv;
    }

    private static AlgorithmParameterSpec getParamSpec(CipherMode mode, byte[] input) {
        return switch (mode) {
            case CipherMode.CBC -> new IvParameterSpec(input, 0, mode.ivLength);
            case CipherMode.GCM -> new GCMParameterSpec(mode.tagLength, input, 0, mode.ivLength);
            default -> null;
        };
    }

    private static byte[] aesInternal(byte[] input, byte[] key, String mode, String padding, int opmode, byte[] iv, byte[] aad) {
        try {
            SecretKeySpec secretKey = ExpressionImplUtils.getSecretKeySpec(key);
            CipherMode cipherMode = CipherMode.fromString(mode, padding);
            Cipher cipher = Cipher.getInstance(cipherMode.transformation);
            if (opmode == 1) {
                if (iv == null || iv.length == 0) {
                    iv = ExpressionImplUtils.generateIv(cipherMode);
                } else if (!cipherMode.usesSpec) {
                    throw QueryExecutionErrors.aesUnsupportedIv(mode);
                }
                if (iv.length != cipherMode.ivLength) {
                    throw QueryExecutionErrors.invalidAesIvLengthError(mode, iv.length);
                }
                if (cipherMode.usesSpec) {
                    AlgorithmParameterSpec algSpec = ExpressionImplUtils.getParamSpec(cipherMode, iv);
                    cipher.init(opmode, (Key)secretKey, algSpec);
                } else {
                    cipher.init(opmode, secretKey);
                }
                if (aad != null && aad.length != 0) {
                    if (!cipherMode.supportsAad) {
                        throw QueryExecutionErrors.aesUnsupportedAad(mode);
                    }
                    cipher.updateAAD(aad);
                }
                byte[] encrypted = cipher.doFinal(input, 0, input.length);
                if (iv.length > 0) {
                    ByteBuffer byteBuffer = ByteBuffer.allocate(iv.length + encrypted.length);
                    byteBuffer.put(iv);
                    byteBuffer.put(encrypted);
                    return byteBuffer.array();
                }
                return encrypted;
            }
            assert (opmode == 2);
            if (cipherMode.usesSpec) {
                AlgorithmParameterSpec algSpec = ExpressionImplUtils.getParamSpec(cipherMode, input);
                cipher.init(opmode, (Key)secretKey, algSpec);
                if (aad != null && aad.length != 0) {
                    if (!cipherMode.supportsAad) {
                        throw QueryExecutionErrors.aesUnsupportedAad(mode);
                    }
                    cipher.updateAAD(aad);
                }
                return cipher.doFinal(input, cipherMode.ivLength, input.length - cipherMode.ivLength);
            }
            cipher.init(opmode, secretKey);
            return cipher.doFinal(input, 0, input.length);
        }
        catch (GeneralSecurityException e) {
            throw QueryExecutionErrors.aesCryptoError(e.getMessage());
        }
    }

    public static ArrayData getSentences(UTF8String str, UTF8String language, UTF8String country) {
        if (str == null) {
            return null;
        }
        Locale locale = language != null && country != null ? new Locale(language.toString(), country.toString()) : (language != null ? new Locale(language.toString()) : Locale.US);
        String sentences = str.toString();
        BreakIterator sentenceInstance = BreakIterator.getSentenceInstance(locale);
        sentenceInstance.setText(sentences);
        int sentenceIndex = 0;
        ArrayList<GenericArrayData> res = new ArrayList<GenericArrayData>();
        while (sentenceInstance.next() != -1) {
            String sentence = sentences.substring(sentenceIndex, sentenceInstance.current());
            sentenceIndex = sentenceInstance.current();
            BreakIterator wordInstance = BreakIterator.getWordInstance(locale);
            wordInstance.setText(sentence);
            int wordIndex = 0;
            ArrayList<UTF8String> words = new ArrayList<UTF8String>();
            while (wordInstance.next() != -1) {
                String word = sentence.substring(wordIndex, wordInstance.current());
                wordIndex = wordInstance.current();
                if (!Character.isLetterOrDigit(word.charAt(0))) continue;
                words.add(UTF8String.fromString((String)word));
            }
            res.add(new GenericArrayData(words.toArray(new UTF8String[0])));
        }
        return new GenericArrayData(res.toArray(new GenericArrayData[0]));
    }

    public static UTF8String randStr(XORShiftRandom rng, int length) {
        byte[] bytes = new byte[length];
        for (int i = 0; i < bytes.length; ++i) {
            int v = Math.abs(rng.nextInt() % 62);
            bytes[i] = v < 10 ? (byte)(48 + v) : (v < 36 ? (byte)(97 + (v - 10)) : (byte)(65 + (v - 36)));
        }
        return UTF8String.fromBytes((byte[])bytes);
    }

    public static UTF8String quote(UTF8String str) {
        String qtChar = "'";
        String qtCharRep = "\\\\'";
        String sp2 = str.toString().replaceAll("'", "\\\\'");
        return UTF8String.fromString((String)("'" + sp2 + "'"));
    }

    static enum CipherMode {
        ECB("ECB", 0, 0, "AES/ECB/PKCS5Padding", false, false),
        CBC("CBC", 16, 0, "AES/CBC/PKCS5Padding", true, false),
        GCM("GCM", 12, 128, "AES/GCM/NoPadding", true, true);

        private final String name;
        final int ivLength;
        final int tagLength;
        final String transformation;
        final boolean usesSpec;
        final boolean supportsAad;

        private CipherMode(String name, int ivLen, int tagLen, String transformation, boolean usesSpec, boolean supportsAad) {
            this.name = name;
            this.ivLength = ivLen;
            this.tagLength = tagLen;
            this.transformation = transformation;
            this.usesSpec = usesSpec;
            this.supportsAad = supportsAad;
        }

        static CipherMode fromString(String modeName, String padding) {
            boolean isNone = padding.equalsIgnoreCase("NONE");
            boolean isPkcs = padding.equalsIgnoreCase("PKCS");
            boolean isDefault = padding.equalsIgnoreCase("DEFAULT");
            if (modeName.equalsIgnoreCase(CipherMode.ECB.name) && (isPkcs || isDefault)) {
                return ECB;
            }
            if (modeName.equalsIgnoreCase(CipherMode.CBC.name) && (isPkcs || isDefault)) {
                return CBC;
            }
            if (modeName.equalsIgnoreCase(CipherMode.GCM.name) && (isNone || isDefault)) {
                return GCM;
            }
            throw QueryExecutionErrors.aesModeUnsupportedError(modeName, padding);
        }
    }
}

