/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.http;

import io.fabric8.kubernetes.client.http.BasicBuilder;
import io.fabric8.kubernetes.client.http.HttpClient;
import io.fabric8.kubernetes.client.http.HttpLoggingInterceptor;
import io.fabric8.kubernetes.client.http.HttpRequest;
import io.fabric8.kubernetes.client.http.Interceptor;
import io.fabric8.kubernetes.client.http.TlsVersion;
import io.fabric8.kubernetes.client.internal.SSLUtils;
import java.net.InetSocketAddress;
import java.time.Duration;
import java.util.LinkedHashMap;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import lombok.Generated;
import org.slf4j.LoggerFactory;

public abstract class StandardHttpClientBuilder<C extends HttpClient, F extends HttpClient.Factory, T extends StandardHttpClientBuilder<C, F, ?>>
implements HttpClient.Builder {
    protected LinkedHashMap<String, Interceptor> interceptors = new LinkedHashMap();
    protected Duration connectTimeout;
    protected SSLContext sslContext;
    protected String proxyAuthorization;
    protected InetSocketAddress proxyAddress;
    protected boolean followRedirects;
    protected boolean preferHttp11;
    protected TlsVersion[] tlsVersions;
    protected boolean authenticatorNone;
    protected C client;
    protected F clientFactory;
    protected TrustManager[] trustManagers;
    protected KeyManager[] keyManagers;
    protected LinkedHashMap<Class<?>, Object> tags = new LinkedHashMap();
    protected HttpClient.ProxyType proxyType = HttpClient.ProxyType.HTTP;

    protected StandardHttpClientBuilder(F clientFactory) {
        this.clientFactory = clientFactory;
        if (LoggerFactory.getLogger(HttpLoggingInterceptor.class).isTraceEnabled()) {
            this.interceptors.put("HttpLogging", new HttpLoggingInterceptor());
        }
    }

    public T connectTimeout(long connectTimeout, TimeUnit unit) {
        this.connectTimeout = Duration.ofNanos(unit.toNanos(connectTimeout));
        return (T)this;
    }

    public T addOrReplaceInterceptor(String name, Interceptor interceptor) {
        if (interceptor == null) {
            this.interceptors.remove(name);
        } else {
            this.interceptors.put(name, interceptor);
        }
        return (T)this;
    }

    public T authenticatorNone() {
        this.authenticatorNone = true;
        return (T)this;
    }

    public T sslContext(KeyManager[] keyManagers, TrustManager[] trustManagers) {
        this.sslContext = SSLUtils.sslContext(keyManagers, trustManagers);
        this.keyManagers = keyManagers;
        this.trustManagers = trustManagers;
        return (T)this;
    }

    public T followAllRedirects() {
        this.followRedirects = true;
        return (T)this;
    }

    public T proxyAddress(InetSocketAddress proxyAddress) {
        this.proxyAddress = proxyAddress;
        return (T)this;
    }

    public T proxyAuthorization(String credentials) {
        this.proxyAuthorization = credentials;
        return (T)this;
    }

    public T proxyType(HttpClient.ProxyType type) {
        this.proxyType = type;
        return (T)this;
    }

    public T tlsVersions(TlsVersion ... tlsVersions) {
        this.tlsVersions = tlsVersions;
        return (T)this;
    }

    public T preferHttp11() {
        this.preferHttp11 = true;
        return (T)this;
    }

    public T clientFactory(F clientFactory) {
        this.clientFactory = clientFactory;
        return (T)this;
    }

    @Override
    public HttpClient.DerivedClientBuilder tag(Object value) {
        if (value != null) {
            this.tags.put(value.getClass(), value);
        }
        return this;
    }

    protected abstract T newInstance(F var1);

    public T copy(C client) {
        T copy = this.newInstance(this.clientFactory);
        ((StandardHttpClientBuilder)copy).connectTimeout = this.connectTimeout;
        ((StandardHttpClientBuilder)copy).sslContext = this.sslContext;
        ((StandardHttpClientBuilder)copy).trustManagers = this.trustManagers;
        ((StandardHttpClientBuilder)copy).keyManagers = this.keyManagers;
        ((StandardHttpClientBuilder)copy).interceptors = new LinkedHashMap<String, Interceptor>(this.interceptors);
        ((StandardHttpClientBuilder)copy).proxyAddress = this.proxyAddress;
        ((StandardHttpClientBuilder)copy).proxyAuthorization = this.proxyAuthorization;
        ((StandardHttpClientBuilder)copy).tlsVersions = this.tlsVersions;
        ((StandardHttpClientBuilder)copy).preferHttp11 = this.preferHttp11;
        ((StandardHttpClientBuilder)copy).followRedirects = this.followRedirects;
        ((StandardHttpClientBuilder)copy).authenticatorNone = this.authenticatorNone;
        ((StandardHttpClientBuilder)copy).client = client;
        ((StandardHttpClientBuilder)copy).tags = new LinkedHashMap(this.tags);
        ((StandardHttpClientBuilder)copy).proxyType = this.proxyType;
        return copy;
    }

    protected void addProxyAuthInterceptor() {
        if (this.proxyAuthorization != null) {
            this.interceptors.put("PROXY-AUTH", new Interceptor(){

                @Override
                public void before(BasicBuilder builder, HttpRequest httpRequest, Interceptor.RequestTags tags) {
                    builder.setHeader("Proxy-Authorization", StandardHttpClientBuilder.this.proxyAuthorization);
                }
            });
        }
    }

    @Generated
    public LinkedHashMap<String, Interceptor> getInterceptors() {
        return this.interceptors;
    }

    @Generated
    public Duration getConnectTimeout() {
        return this.connectTimeout;
    }

    @Generated
    public SSLContext getSslContext() {
        return this.sslContext;
    }

    @Generated
    public String getProxyAuthorization() {
        return this.proxyAuthorization;
    }

    @Generated
    public InetSocketAddress getProxyAddress() {
        return this.proxyAddress;
    }

    @Generated
    public boolean isFollowRedirects() {
        return this.followRedirects;
    }

    @Generated
    public boolean isPreferHttp11() {
        return this.preferHttp11;
    }

    @Generated
    public TlsVersion[] getTlsVersions() {
        return this.tlsVersions;
    }

    @Generated
    public boolean isAuthenticatorNone() {
        return this.authenticatorNone;
    }

    @Generated
    public C getClient() {
        return this.client;
    }

    @Generated
    public F getClientFactory() {
        return this.clientFactory;
    }

    @Generated
    public TrustManager[] getTrustManagers() {
        return this.trustManagers;
    }

    @Generated
    public KeyManager[] getKeyManagers() {
        return this.keyManagers;
    }

    @Generated
    public LinkedHashMap<Class<?>, Object> getTags() {
        return this.tags;
    }

    @Generated
    public HttpClient.ProxyType getProxyType() {
        return this.proxyType;
    }
}

