/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.memory.internal;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class VirtualMachineMemory {
    private static final Class<?> VM_CLASS;
    private static final Method VM_IS_DIRECT_MEMORY_PAGE_ALIGNED_METHOD;
    private static final boolean isPageAligned;

    public static boolean getIsPageAligned() {
        return isPageAligned;
    }

    static {
        try {
            VM_CLASS = Class.forName("sun.misc.VM");
            VM_IS_DIRECT_MEMORY_PAGE_ALIGNED_METHOD = VM_CLASS.getDeclaredMethod("isDirectMemoryPageAligned", new Class[0]);
            VM_IS_DIRECT_MEMORY_PAGE_ALIGNED_METHOD.setAccessible(true);
            isPageAligned = (Boolean)VM_IS_DIRECT_MEMORY_PAGE_ALIGNED_METHOD.invoke(null, new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new RuntimeException("Could not acquire sun.misc.VM class: " + e.getClass());
        }
    }
}

