/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.recommendation;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.Serializable;
import org.apache.hadoop.fs.Path;
import org.apache.spark.ml.Model;
import org.apache.spark.ml.linalg.BLAS$;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.shared.HasBlockSize;
import org.apache.spark.ml.param.shared.HasPredictionCol;
import org.apache.spark.ml.recommendation.ALSModel$;
import org.apache.spark.ml.recommendation.ALSModel$ALSModelReader$;
import org.apache.spark.ml.recommendation.ALSModel$ALSModelWriter$;
import org.apache.spark.ml.recommendation.ALSModelParams;
import org.apache.spark.ml.recommendation.FeatureData;
import org.apache.spark.ml.util.BaseReadWrite;
import org.apache.spark.ml.util.DefaultParamsReader;
import org.apache.spark.ml.util.DefaultParamsReader$;
import org.apache.spark.ml.util.DefaultParamsWriter$;
import org.apache.spark.ml.util.Identifiable$;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.ml.util.ReadWriteUtils$;
import org.apache.spark.ml.util.SchemaUtils$;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.expressions.UserDefinedFunction;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.ArrayImplicits$;
import org.json4s.DefaultFormats$;
import org.json4s.ExtractableJsonAstNode$;
import org.json4s.Formats;
import org.json4s.JObject;
import org.json4s.JsonDSL$;
import org.json4s.MonadicJValue$;
import org.sparkproject.guava.collect.Ordering;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.Manifest;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\r\rd\u0001B\u001c9\u0001\rC\u0001b\u0015\u0001\u0003\u0006\u0004%\t\u0005\u0016\u0005\tW\u0002\u0011\t\u0011)A\u0005+\"AQ\u000e\u0001BC\u0002\u0013\u0005a\u000e\u0003\u0005u\u0001\t\u0005\t\u0015!\u0003p\u0011!1\bA!b\u0001\n\u00039\b\"CA\n\u0001\t\u0005\t\u0015!\u0003y\u0011%\ti\u0002\u0001BC\u0002\u0013\u0005q\u000fC\u0005\u0002 \u0001\u0011\t\u0011)A\u0005q\"A\u00111\u0005\u0001\u0005\u0002i\n)\u0003\u0003\u0005\u0002$\u0001!\tAOA\u001a\u0011\u001d\t)\u0004\u0001C\u0001\u0003oAq!!\u0011\u0001\t\u0003\t\u0019\u0005C\u0004\u0002J\u0001!\t!a\u0013\t\u000f\u0005U\u0003\u0001\"\u0001\u0002X!9\u0011\u0011\r\u0001\u0005\u0002\u0005\r\u0004\"CA7\u0001\t\u0007I\u0011BA8\u0011!\ti\b\u0001Q\u0001\n\u0005E\u0004bBA@\u0001\u0011\u0005\u0013\u0011\u0011\u0005\b\u0003[\u0003A\u0011IAX\u0011\u001d\t\u0019\r\u0001C!\u0003\u000bDq!!8\u0001\t\u0003\ny\u000eC\u0004\u0002n\u0002!\t%a<\t\u000f\u0005M\b\u0001\"\u0001\u0002v\"9\u0011Q \u0001\u0005\u0002\u0005}\bb\u0002B\u000b\u0001\u0011\u0005!q\u0003\u0005\b\u0005?\u0001A\u0011\u0001B\u0011\u0011\u001d\u0011\u0019\u0004\u0001C\u0005\u0005kAqAa\u0013\u0001\t\u0013\u0011i\u0005C\u0004\u0003h\u0001!IA!\u001b\t\u000f\t%\u0005\u0001\"\u0011\u0003\f\u001e9!Q\u0013\u001d\t\u0002\t]eAB\u001c9\u0011\u0003\u0011I\nC\u0004\u0002$\u0001\"\tAa.\t\u0011\te\u0006\u0005\"\u0001;\u0005wC\u0001Ba6!\t\u0003Q$\u0011\u001c\u0005\n\u0005K\u0004#\u0019!C\u0005\u0005OD\u0001Ba=!A\u0003%!\u0011\u001e\u0005\n\u0005k\u0004#\u0019!C\u0005\u0005OD\u0001Ba>!A\u0003%!\u0011\u001e\u0005\u000b\u0005s\u0004#\u0019!C\u0003q\tm\b\u0002\u0003B\u0000A\u0001\u0006iA!@\t\u0011\r\u0005\u0001\u0005\"\u00019\u0007\u0007Aqaa\u0007!\t\u0003\u001ai\u0002C\u0004\u0004(\u0001\"\te!\u000b\u0007\u000f\rE\u0002\u0005\u0001\u0011\u00044!I1QG\u0017\u0003\u0002\u0003\u0006I\u0001\u0013\u0005\b\u0003GiC\u0011AB\u001c\u0011\u001d\u0019y$\fC)\u0007\u00032aa!\u0012!\t\r\u001d\u0003bBA\u0012c\u0011\u00051\u0011\n\u0005\n\u0007\u001b\n$\u0019!C\u0005\u0005OD\u0001ba\u00142A\u0003%!\u0011\u001e\u0005\b\u0007O\tD\u0011IB)\u0011%\u0019)\u0006IA\u0001\n\u0013\u00199F\u0001\u0005B\u0019Nku\u000eZ3m\u0015\tI$(\u0001\bsK\u000e|W.\\3oI\u0006$\u0018n\u001c8\u000b\u0005mb\u0014AA7m\u0015\tid(A\u0003ta\u0006\u00148N\u0003\u0002@\u0001\u00061\u0011\r]1dQ\u0016T\u0011!Q\u0001\u0004_J<7\u0001A\n\u0005\u0001\u0011SU\nE\u0002F\r\"k\u0011AO\u0005\u0003\u000fj\u0012Q!T8eK2\u0004\"!\u0013\u0001\u000e\u0003a\u0002\"!S&\n\u00051C$AD!M'6{G-\u001a7QCJ\fWn\u001d\t\u0003\u001dFk\u0011a\u0014\u0006\u0003!j\nA!\u001e;jY&\u0011!k\u0014\u0002\u000b\u001b2;&/\u001b;bE2,\u0017aA;jIV\tQ\u000b\u0005\u0002W?:\u0011q+\u0018\t\u00031nk\u0011!\u0017\u0006\u00035\n\u000ba\u0001\u0010:p_Rt$\"\u0001/\u0002\u000bM\u001c\u0017\r\\1\n\u0005y[\u0016A\u0002)sK\u0012,g-\u0003\u0002aC\n11\u000b\u001e:j]\u001eT!AX.)\u0007\u0005\u0019\u0017\u000e\u0005\u0002eO6\tQM\u0003\u0002gy\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u0005!,'!B*j]\u000e,\u0017%\u00016\u0002\u000bErCG\f\u0019\u0002\tULG\r\t\u0015\u0004\u0005\rL\u0017\u0001\u0002:b].,\u0012a\u001c\t\u0003aFl\u0011aW\u0005\u0003en\u00131!\u00138uQ\r\u00191-[\u0001\u0006e\u0006t7\u000e\t\u0015\u0004\t\rL\u0017aC;tKJ4\u0015m\u0019;peN,\u0012\u0001\u001f\t\u0004s\u00065ab\u0001>\u0002\b9\u001910a\u0001\u000f\u0007q\f\tA\u0004\u0002~\u007f:\u0011\u0001L`\u0005\u0002\u0003&\u0011q\bQ\u0005\u0003{yJ1!!\u0002=\u0003\r\u0019\u0018\u000f\\\u0005\u0005\u0003\u0013\tY!A\u0004qC\u000e\\\u0017mZ3\u000b\u0007\u0005\u0015A(\u0003\u0003\u0002\u0010\u0005E!!\u0003#bi\u00064%/Y7f\u0015\u0011\tI!a\u0003\u0002\u0019U\u001cXM\u001d$bGR|'o\u001d\u0011)\u0007\u0019\t9\u0002E\u0002q\u00033I1!a\u0007\\\u0005%!(/\u00198tS\u0016tG/A\u0006ji\u0016lg)Y2u_J\u001c\u0018\u0001D5uK64\u0015m\u0019;peN\u0004\u0003f\u0001\u0005\u0002\u0018\u00051A(\u001b8jiz\"\u0012\u0002SA\u0014\u0003W\ty#!\r\t\u000bMK\u0001\u0019A+)\t\u0005\u001d2-\u001b\u0005\u0006[&\u0001\ra\u001c\u0015\u0005\u0003W\u0019\u0017\u000eC\u0003w\u0013\u0001\u0007\u0001\u0010\u0003\u0004\u0002\u001e%\u0001\r\u0001\u001f\u000b\u0002\u0011\u0006Q1/\u001a;Vg\u0016\u00148i\u001c7\u0015\t\u0005e\u00121H\u0007\u0002\u0001!1\u0011QH\u0006A\u0002U\u000bQA^1mk\u0016D3aC2j\u0003)\u0019X\r^%uK6\u001cu\u000e\u001c\u000b\u0005\u0003s\t)\u0005\u0003\u0004\u0002>1\u0001\r!\u0016\u0015\u0004\u0019\rL\u0017\u0001E:fiB\u0013X\rZ5di&|gnQ8m)\u0011\tI$!\u0014\t\r\u0005uR\u00021\u0001VQ\u0011i1-!\u0015\"\u0005\u0005M\u0013!B\u0019/g9\u0002\u0014\u0001F:fi\u000e{G\u000eZ*uCJ$8\u000b\u001e:bi\u0016<\u0017\u0010\u0006\u0003\u0002:\u0005e\u0003BBA\u001f\u001d\u0001\u0007Q\u000b\u000b\u0003\u000fG\u0006u\u0013EAA0\u0003\u0015\u0011dF\r\u00181\u00031\u0019X\r\u001e\"m_\u000e\\7+\u001b>f)\u0011\tI$!\u001a\t\r\u0005ur\u00021\u0001pQ\u0011y1-!\u001b\"\u0005\u0005-\u0014!B\u001a/a9\u0002\u0014a\u00029sK\u0012L7\r^\u000b\u0003\u0003c\u0002B!a\u001d\u0002z5\u0011\u0011Q\u000f\u0006\u0005\u0003o\nY!A\u0006fqB\u0014Xm]:j_:\u001c\u0018\u0002BA>\u0003k\u00121#V:fe\u0012+g-\u001b8fI\u001a+hn\u0019;j_:\f\u0001\u0002\u001d:fI&\u001cG\u000fI\u0001\niJ\fgn\u001d4pe6$2\u0001_AB\u0011\u001d\t)I\u0005a\u0001\u0003\u000f\u000bq\u0001Z1uCN,G\u000f\r\u0003\u0002\n\u0006U\u0005CBAF\u0003\u001b\u000b\t*\u0004\u0002\u0002\f%!\u0011qRA\u0006\u0005\u001d!\u0015\r^1tKR\u0004B!a%\u0002\u00162\u0001A\u0001DAL\u0003\u0007\u000b\t\u0011!A\u0003\u0002\u0005e%aA0%eE!\u00111TAQ!\r\u0001\u0018QT\u0005\u0004\u0003?[&a\u0002(pi\"Lgn\u001a\t\u0004a\u0006\r\u0016bAAS7\n\u0019\u0011I\\=)\tI\u0019\u0017\u0011V\u0011\u0003\u0003W\u000bQA\r\u00181]A\nq\u0002\u001e:b]N4wN]7TG\",W.\u0019\u000b\u0005\u0003c\u000bi\f\u0005\u0003\u00024\u0006eVBAA[\u0015\u0011\t9,a\u0003\u0002\u000bQL\b/Z:\n\t\u0005m\u0016Q\u0017\u0002\u000b'R\u0014Xo\u0019;UsB,\u0007bBA`'\u0001\u0007\u0011\u0011W\u0001\u0007g\u000eDW-\\1)\tM\u0019\u0017\u0011K\u0001\u0005G>\u0004\u0018\u0010F\u0002I\u0003\u000fDq!!3\u0015\u0001\u0004\tY-A\u0003fqR\u0014\u0018\r\u0005\u0003\u0002N\u0006MWBAAh\u0015\r\t\tNO\u0001\u0006a\u0006\u0014\u0018-\\\u0005\u0005\u0003+\fyM\u0001\u0005QCJ\fW.T1qQ\u0011!2-!7\"\u0005\u0005m\u0017!B\u0019/k9\u0002\u0014!B<sSR,WCAAq!\rq\u00151]\u0005\u0004\u0003K|%\u0001C'M/JLG/\u001a:)\tU\u0019\u0017\u0011^\u0011\u0003\u0003W\fQ!\r\u00187]A\n\u0001\u0002^8TiJLgn\u001a\u000b\u0002+\"\"acYA5\u0003Q\u0011XmY8n[\u0016tGMR8s\u00032dWk]3sgR\u0019\u00010a>\t\r\u0005ex\u00031\u0001p\u0003!qW/\\%uK6\u001c\b\u0006B\fd\u0003;\naC]3d_6lWM\u001c3G_J,6/\u001a:Tk\n\u001cX\r\u001e\u000b\u0006q\n\u0005!Q\u0002\u0005\b\u0003\u000bC\u0002\u0019\u0001B\u0002a\u0011\u0011)A!\u0003\u0011\r\u0005-\u0015Q\u0012B\u0004!\u0011\t\u0019J!\u0003\u0005\u0019\t-!\u0011AA\u0001\u0002\u0003\u0015\t!!'\u0003\u0007}#3\u0007\u0003\u0004\u0002zb\u0001\ra\u001c\u0015\u00051\r\u0014\t\"\t\u0002\u0003\u0014\u0005)!GL\u001a/a\u0005!\"/Z2p[6,g\u000e\u001a$pe\u0006cG.\u0013;f[N$2\u0001\u001fB\r\u0011\u0019\u0011Y\"\u0007a\u0001_\u0006Aa.^7Vg\u0016\u00148\u000f\u000b\u0003\u001aG\u0006u\u0013A\u0006:fG>lW.\u001a8e\r>\u0014\u0018\n^3n'V\u00147/\u001a;\u0015\u000ba\u0014\u0019Ca\f\t\u000f\u0005\u0015%\u00041\u0001\u0003&A\"!q\u0005B\u0016!\u0019\tY)!$\u0003*A!\u00111\u0013B\u0016\t1\u0011iCa\t\u0002\u0002\u0003\u0005)\u0011AAM\u0005\ryF\u0005\u000e\u0005\u0007\u00057Q\u0002\u0019A8)\ti\u0019'\u0011C\u0001\u0016O\u0016$8k\\;sG\u00164\u0015m\u0019;peN+(m]3u)\u001dA(q\u0007B\"\u0005\u000fBq!!\"\u001c\u0001\u0004\u0011I\u0004\r\u0003\u0003<\t}\u0002CBAF\u0003\u001b\u0013i\u0004\u0005\u0003\u0002\u0014\n}B\u0001\u0004B!\u0005o\t\t\u0011!A\u0003\u0002\u0005e%aA0%k!1!QI\u000eA\u0002a\fqAZ1di>\u00148\u000f\u0003\u0004\u0003Jm\u0001\r!V\u0001\u0007G>dW/\u001c8\u0002\u001fI,7m\\7nK:$gi\u001c:BY2$R\u0002\u001fB(\u0005'\u00129Fa\u0017\u0003`\t\r\u0004B\u0002B)9\u0001\u0007\u00010\u0001\u0006te\u000e4\u0015m\u0019;peNDaA!\u0016\u001d\u0001\u0004A\u0018A\u00033ti\u001a\u000b7\r^8sg\"1!\u0011\f\u000fA\u0002U\u000bqb\u001d:d\u001fV$\b/\u001e;D_2,XN\u001c\u0005\u0007\u0005;b\u0002\u0019A+\u0002\u001f\u0011\u001cHoT;uaV$8i\u001c7v[:DaA!\u0019\u001d\u0001\u0004y\u0017a\u00018v[\"1!Q\r\u000fA\u0002=\f\u0011B\u00197pG.\u001c\u0016N_3\u0002\u0011\tdwnY6jMf$bAa\u001b\u0003\u0002\n\u001d\u0005CBAF\u0003\u001b\u0013i\u0007E\u0004q\u0005_\u0012\u0019H!\u001f\n\u0007\tE4L\u0001\u0004UkBdWM\r\t\u0005a\nUt.C\u0002\u0003xm\u0013Q!\u0011:sCf\u0004R\u0001\u001dB;\u0005w\u00022\u0001\u001dB?\u0013\r\u0011yh\u0017\u0002\u0006\r2|\u0017\r\u001e\u0005\b\u0005\u000bj\u0002\u0019\u0001BB!\u0019\tY)!$\u0003\u0006B1\u0001Oa\u001cp\u0005sBaA!\u001a\u001e\u0001\u0004y\u0017!D3ti&l\u0017\r^3e'&TX-\u0006\u0002\u0003\u000eB\u0019\u0001Oa$\n\u0007\tE5L\u0001\u0003M_:<\u0007\u0006\u0002\u0001d\u0003#\n\u0001\"\u0011'T\u001b>$W\r\u001c\t\u0003\u0013\u0002\u001ar\u0001\tBN\u0005C\u00139\u000bE\u0002q\u0005;K1Aa(\\\u0005\u0019\te.\u001f*fMB!aJa)I\u0013\r\u0011)k\u0014\u0002\u000b\u001b2\u0013V-\u00193bE2,\u0007\u0003\u0002BU\u0005gk!Aa+\u000b\t\t5&qV\u0001\u0003S>T!A!-\u0002\t)\fg/Y\u0005\u0005\u0005k\u0013YK\u0001\u0007TKJL\u0017\r\\5{C\ndW\r\u0006\u0002\u0003\u0018\u0006i1/\u001a:jC2L'0\u001a#bi\u0006$bA!0\u0003D\n5\u0007c\u00019\u0003@&\u0019!\u0011Y.\u0003\tUs\u0017\u000e\u001e\u0005\b\u0005\u000b\u0014\u0003\u0019\u0001Bd\u0003\u0011!\u0017\r^1\u0011\u0007%\u0013I-C\u0002\u0003Lb\u00121BR3biV\u0014X\rR1uC\"9!q\u001a\u0012A\u0002\tE\u0017a\u00013pgB!!\u0011\u0016Bj\u0013\u0011\u0011)Na+\u0003!\u0011\u000bG/Y(viB,Ho\u0015;sK\u0006l\u0017a\u00043fg\u0016\u0014\u0018.\u00197ju\u0016$\u0015\r^1\u0015\t\t\u001d'1\u001c\u0005\b\u0005;\u001c\u0003\u0019\u0001Bp\u0003\r!\u0017n\u001d\t\u0005\u0005S\u0013\t/\u0003\u0003\u0003d\n-&a\u0004#bi\u0006Le\u000e];u'R\u0014X-Y7\u0002\u00079\u000bg*\u0006\u0002\u0003jB!!1\u001eBy\u001b\t\u0011iO\u0003\u0003\u0003p\n=\u0016\u0001\u00027b]\u001eL1\u0001\u0019Bw\u0003\u0011q\u0015M\u0014\u0011\u0002\t\u0011\u0013x\u000e]\u0001\u0006\tJ|\u0007\u000fI\u0001\u001dgV\u0004\bo\u001c:uK\u0012\u001cu\u000e\u001c3Ti\u0006\u0014Ho\u0015;sCR,w-[3t+\t\u0011i\u0010E\u0003q\u0005k\u0012I/A\u000ftkB\u0004xN\u001d;fI\u000e{G\u000eZ*uCJ$8\u000b\u001e:bi\u0016<\u0017.Z:!\u00035\u0019w\u000e\u001c7fGR|Fo\u001c9`WRA1QAB\u0006\u0007\u001f\u0019\t\u0002\u0005\u0003\u0002\f\u000e\u001d\u0011\u0002BB\u0005\u0003\u0017\u0011aaQ8mk6t\u0007bBB\u0007U\u0001\u00071QA\u0001\u0002K\"1!\u0011\r\u0016A\u0002=Dqaa\u0005+\u0001\u0004\u0019)\"A\u0004sKZ,'o]3\u0011\u0007A\u001c9\"C\u0002\u0004\u001am\u0013qAQ8pY\u0016\fg.\u0001\u0003sK\u0006$WCAB\u0010!\u0011q5\u0011\u0005%\n\u0007\r\rrJ\u0001\u0005N\u0019J+\u0017\rZ3sQ\u0011Y3-!;\u0002\t1|\u0017\r\u001a\u000b\u0004\u0011\u000e-\u0002BBB\u0017Y\u0001\u0007Q+\u0001\u0003qCRD\u0007\u0006\u0002\u0017d\u0003S\u0014a\"\u0011'T\u001b>$W\r\\,sSR,'oE\u0002.\u0003C\f\u0001\"\u001b8ti\u0006t7-\u001a\u000b\u0005\u0007s\u0019i\u0004E\u0002\u0004<5j\u0011\u0001\t\u0005\u0007\u0007ky\u0003\u0019\u0001%\u0002\u0011M\fg/Z%na2$BA!0\u0004D!11Q\u0006\u0019A\u0002U\u0013a\"\u0011'T\u001b>$W\r\u001c*fC\u0012,'oE\u00022\u0007?!\"aa\u0013\u0011\u0007\rm\u0012'A\u0005dY\u0006\u001c8OT1nK\u0006Q1\r\\1tg:\u000bW.\u001a\u0011\u0015\u0007!\u001b\u0019\u0006\u0003\u0004\u0004.U\u0002\r!V\u0001\roJLG/\u001a*fa2\f7-\u001a\u000b\u0003\u00073\u0002BAa;\u0004\\%!1Q\fBw\u0005\u0019y%M[3di\"\"\u0001eYAuQ\u0011y2-!;")
public class ALSModel
extends Model<ALSModel>
implements ALSModelParams,
MLWritable {
    private final String uid;
    private final int rank;
    private final transient Dataset<Row> userFactors;
    private final transient Dataset<Row> itemFactors;
    private final UserDefinedFunction predict;
    private Param<String> userCol;
    private Param<String> itemCol;
    private Param<String> coldStartStrategy;
    private IntParam blockSize;
    private Param<String> predictionCol;

    public static ALSModel load(String path) {
        return ALSModel$.MODULE$.load(path);
    }

    public static MLReader<ALSModel> read() {
        return ALSModel$.MODULE$.read();
    }

    @Override
    public void save(String path) throws IOException {
        MLWritable.save$(this, path);
    }

    @Override
    public String getUserCol() {
        return ALSModelParams.getUserCol$(this);
    }

    @Override
    public String getItemCol() {
        return ALSModelParams.getItemCol$(this);
    }

    @Override
    public Column checkIntegers(Dataset<?> dataset, String colName) {
        return ALSModelParams.checkIntegers$(this, dataset, colName);
    }

    @Override
    public String getColdStartStrategy() {
        return ALSModelParams.getColdStartStrategy$(this);
    }

    @Override
    public final int getBlockSize() {
        return HasBlockSize.getBlockSize$(this);
    }

    @Override
    public final String getPredictionCol() {
        return HasPredictionCol.getPredictionCol$(this);
    }

    @Override
    public Param<String> userCol() {
        return this.userCol;
    }

    @Override
    public Param<String> itemCol() {
        return this.itemCol;
    }

    @Override
    public Param<String> coldStartStrategy() {
        return this.coldStartStrategy;
    }

    @Override
    public void org$apache$spark$ml$recommendation$ALSModelParams$_setter_$userCol_$eq(Param<String> x$1) {
        this.userCol = x$1;
    }

    @Override
    public void org$apache$spark$ml$recommendation$ALSModelParams$_setter_$itemCol_$eq(Param<String> x$1) {
        this.itemCol = x$1;
    }

    @Override
    public void org$apache$spark$ml$recommendation$ALSModelParams$_setter_$coldStartStrategy_$eq(Param<String> x$1) {
        this.coldStartStrategy = x$1;
    }

    @Override
    public final IntParam blockSize() {
        return this.blockSize;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasBlockSize$_setter_$blockSize_$eq(IntParam x$1) {
        this.blockSize = x$1;
    }

    @Override
    public final Param<String> predictionCol() {
        return this.predictionCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasPredictionCol$_setter_$predictionCol_$eq(Param<String> x$1) {
        this.predictionCol = x$1;
    }

    @Override
    public String uid() {
        return this.uid;
    }

    public int rank() {
        return this.rank;
    }

    public Dataset<Row> userFactors() {
        return this.userFactors;
    }

    public Dataset<Row> itemFactors() {
        return this.itemFactors;
    }

    public ALSModel setUserCol(String value) {
        return (ALSModel)this.set(this.userCol(), value);
    }

    public ALSModel setItemCol(String value) {
        return (ALSModel)this.set(this.itemCol(), value);
    }

    public ALSModel setPredictionCol(String value) {
        return (ALSModel)this.set(this.predictionCol(), value);
    }

    public ALSModel setColdStartStrategy(String value) {
        return (ALSModel)this.set(this.coldStartStrategy(), value);
    }

    public ALSModel setBlockSize(int value) {
        return (ALSModel)this.set(this.blockSize(), BoxesRunTime.boxToInteger((int)value));
    }

    private UserDefinedFunction predict() {
        return this.predict;
    }

    @Override
    public Dataset<Row> transform(Dataset<?> dataset) {
        this.transformSchema(dataset.schema());
        Column validatedUsers = this.checkIntegers(dataset, this.$(this.userCol()));
        Column validatedItems = this.checkIntegers(dataset, this.$(this.itemCol()));
        String validatedInputAlias = Identifiable$.MODULE$.randomUID("__als_validated_input");
        String itemFactorsAlias = Identifiable$.MODULE$.randomUID("__als_item_factors");
        String userFactorsAlias = Identifiable$.MODULE$.randomUID("__als_user_factors");
        Dataset predictions = dataset.withColumns((Seq)new .colon.colon((Object)this.$(this.userCol()), (List)new .colon.colon((Object)this.$(this.itemCol()), (List)Nil$.MODULE$)), (Seq)new .colon.colon((Object)validatedUsers, (List)new .colon.colon((Object)validatedItems, (List)Nil$.MODULE$))).alias(validatedInputAlias).join(this.userFactors().alias(userFactorsAlias), functions$.MODULE$.col(validatedInputAlias + "." + this.$(this.userCol())).$eq$eq$eq((Object)functions$.MODULE$.col(userFactorsAlias + ".id")), "left").join(this.itemFactors().alias(itemFactorsAlias), functions$.MODULE$.col(validatedInputAlias + "." + this.$(this.itemCol())).$eq$eq$eq((Object)functions$.MODULE$.col(itemFactorsAlias + ".id")), "left").select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(validatedInputAlias + ".*"), this.predict().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(userFactorsAlias + ".features"), functions$.MODULE$.col(itemFactorsAlias + ".features")})).alias(this.$(this.predictionCol()))}));
        String string = this.getColdStartStrategy();
        String string2 = ALSModel$.MODULE$.org$apache$spark$ml$recommendation$ALSModel$$Drop();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            return predictions.na().drop("all", (Seq)new .colon.colon((Object)this.$(this.predictionCol()), (List)Nil$.MODULE$));
        }
        String string4 = ALSModel$.MODULE$.org$apache$spark$ml$recommendation$ALSModel$$NaN();
        String string5 = string;
        if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
            return predictions;
        }
        throw new MatchError((Object)string);
    }

    @Override
    public StructType transformSchema(StructType schema) {
        SchemaUtils$.MODULE$.checkNumericType(schema, this.$(this.userCol()), SchemaUtils$.MODULE$.checkNumericType$default$3());
        SchemaUtils$.MODULE$.checkNumericType(schema, this.$(this.itemCol()), SchemaUtils$.MODULE$.checkNumericType$default$3());
        return SchemaUtils$.MODULE$.appendColumn(schema, this.$(this.predictionCol()), (DataType)FloatType$.MODULE$, SchemaUtils$.MODULE$.appendColumn$default$4());
    }

    @Override
    public ALSModel copy(ParamMap extra) {
        ALSModel copied = new ALSModel(this.uid(), this.rank(), this.userFactors(), this.itemFactors());
        return (ALSModel)((Model)this.copyValues(copied, extra)).setParent(this.parent());
    }

    @Override
    public MLWriter write() {
        return new ALSModelWriter(this);
    }

    @Override
    public String toString() {
        return "ALSModel: uid=" + this.uid() + ", rank=" + this.rank();
    }

    public Dataset<Row> recommendForAllUsers(int numItems) {
        return this.recommendForAll(this.userFactors(), this.itemFactors(), this.$(this.userCol()), this.$(this.itemCol()), numItems, BoxesRunTime.unboxToInt((Object)this.$(this.blockSize())));
    }

    public Dataset<Row> recommendForUserSubset(Dataset<?> dataset, int numItems) {
        Dataset<Row> srcFactorSubset = this.getSourceFactorSubset(dataset, this.userFactors(), this.$(this.userCol()));
        return this.recommendForAll(srcFactorSubset, this.itemFactors(), this.$(this.userCol()), this.$(this.itemCol()), numItems, BoxesRunTime.unboxToInt((Object)this.$(this.blockSize())));
    }

    public Dataset<Row> recommendForAllItems(int numUsers) {
        return this.recommendForAll(this.itemFactors(), this.userFactors(), this.$(this.itemCol()), this.$(this.userCol()), numUsers, BoxesRunTime.unboxToInt((Object)this.$(this.blockSize())));
    }

    public Dataset<Row> recommendForItemSubset(Dataset<?> dataset, int numUsers) {
        Dataset<Row> srcFactorSubset = this.getSourceFactorSubset(dataset, this.itemFactors(), this.$(this.itemCol()));
        return this.recommendForAll(srcFactorSubset, this.userFactors(), this.$(this.itemCol()), this.$(this.userCol()), numUsers, BoxesRunTime.unboxToInt((Object)this.$(this.blockSize())));
    }

    private Dataset<Row> getSourceFactorSubset(Dataset<?> dataset, Dataset<Row> factors, String column) {
        return factors.join(dataset.select(column, (Seq)Nil$.MODULE$), factors.apply("id").$eq$eq$eq((Object)dataset.apply(column)), "left_semi").select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{factors.apply("id"), factors.apply("features")}));
    }

    private Dataset<Row> recommendForAll(Dataset<Row> srcFactors, Dataset<Row> dstFactors, String srcOutputColumn, String dstOutputColumn, int num, int blockSize) {
        public final class Org_apache_spark_ml_recommendation_ALSModel$$typecreator20$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple3"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Float").asType().toTypeConstructor(), (List)Nil$.MODULE$))));
            }

            public Org_apache_spark_ml_recommendation_ALSModel$$typecreator20$1(ALSModel $outer) {
            }
        }
        String ratingColumn = "rating";
        String recommendColumn = "recommendations";
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(ALSModel.class.getClassLoader());
        public final class Org_apache_spark_ml_recommendation_ALSModel$$typecreator5$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Array"), (List)new .colon.colon((Object)$m.staticClass("scala.Float").asType().toTypeConstructor(), (List)Nil$.MODULE$)), (List)Nil$.MODULE$)));
            }

            public Org_apache_spark_ml_recommendation_ALSModel$$typecreator5$1(ALSModel $outer) {
            }
        }
        Dataset<Tuple2<int[], float[]>> srcFactorsBlocked = this.blockify((Dataset<Tuple2<Object, float[]>>)srcFactors.as(srcFactors.sparkSession().implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_recommendation_ALSModel$$typecreator5$1(null)))), blockSize);
        JavaUniverse $u2 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(ALSModel.class.getClassLoader());
        public final class Org_apache_spark_ml_recommendation_ALSModel$$typecreator10$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Array"), (List)new .colon.colon((Object)$m.staticClass("scala.Float").asType().toTypeConstructor(), (List)Nil$.MODULE$)), (List)Nil$.MODULE$)));
            }

            public Org_apache_spark_ml_recommendation_ALSModel$$typecreator10$1(ALSModel $outer) {
            }
        }
        Dataset<Tuple2<int[], float[]>> dstFactorsBlocked = this.blockify((Dataset<Tuple2<Object, float[]>>)dstFactors.as(srcFactors.sparkSession().implicits().newProductEncoder(((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_ml_recommendation_ALSModel$$typecreator10$1(null)))), blockSize);
        JavaUniverse $u3 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m3 = package$.MODULE$.universe().runtimeMirror(ALSModel.class.getClassLoader());
        JavaUniverse $u4 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m4 = package$.MODULE$.universe().runtimeMirror(ALSModel.class.getClassLoader());
        public final class Org_apache_spark_ml_recommendation_ALSModel$$typecreator15$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple4"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Array"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$)), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Array"), (List)new .colon.colon((Object)$m.staticClass("scala.Float").asType().toTypeConstructor(), (List)Nil$.MODULE$)), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Array"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$)), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Array"), (List)new .colon.colon((Object)$m.staticClass("scala.Float").asType().toTypeConstructor(), (List)Nil$.MODULE$)), (List)Nil$.MODULE$)))));
            }

            public Org_apache_spark_ml_recommendation_ALSModel$$typecreator15$1(ALSModel $outer) {
            }
        }
        Dataset ratings = srcFactorsBlocked.crossJoin(dstFactorsBlocked).as(srcFactors.sparkSession().implicits().newProductEncoder(((TypeTags)$u3).TypeTag().apply((Mirror)$m3, (TypeCreator)new Org_apache_spark_ml_recommendation_ALSModel$$typecreator15$1(null)))).mapPartitions((Function1 & Serializable)iter -> {
            ObjectRef scores = ObjectRef.create(null);
            ObjectRef idxOrd = ObjectRef.create(null);
            return iter.flatMap((Function1 & Serializable)x0$1 -> {
                Tuple4 tuple4 = x0$1;
                if (tuple4 != null) {
                    int[] srcIds = (int[])tuple4._1();
                    float[] srcMat = (float[])tuple4._2();
                    int[] dstIds = (int[])tuple4._3();
                    float[] dstMat = (float[])tuple4._4();
                    Predef$.MODULE$.require(srcMat.length == srcIds.length * this.rank());
                    Predef$.MODULE$.require(dstMat.length == dstIds.length * this.rank());
                    int m = srcIds.length;
                    int n = dstIds.length;
                    if ((float[])scores$1.elem == null || ((float[])scores$1.elem).length < n) {
                        scores$1.elem = (float[])Array$.MODULE$.ofDim(n, (ClassTag)ClassTag$.MODULE$.Float());
                        idxOrd$1.elem = new Ordering<Object>(null, scores){
                            private final ObjectRef scores$1;

                            public int compare(int left, int right) {
                                return scala.package$.MODULE$.Ordering().apply((scala.math.Ordering)Ordering.DeprecatedFloatOrdering$.MODULE$).compare((Object)BoxesRunTime.boxToFloat((float)((float[])this.scores$1.elem)[left]), (Object)BoxesRunTime.boxToFloat((float)((float[])this.scores$1.elem)[right]));
                            }
                            {
                                this.scores$1 = scores$1;
                            }
                        };
                    }
                    return scala.package$.MODULE$.Iterator().range(0, m).flatMap((Function1 & Serializable)i -> ALSModel.$anonfun$recommendForAll$3(this, n, dstMat, srcMat, scores, srcIds, idxOrd, num, dstIds, BoxesRunTime.unboxToInt((Object)i)));
                }
                throw new MatchError((Object)tuple4);
            });
        }, srcFactors.sparkSession().implicits().newProductEncoder(((TypeTags)$u4).TypeTag().apply((Mirror)$m4, (TypeCreator)new Org_apache_spark_ml_recommendation_ALSModel$$typecreator20$1(null)))).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{srcOutputColumn, dstOutputColumn, ratingColumn}));
        ArrayType arrayType = ArrayType$.MODULE$.apply((DataType)new StructType().add(dstOutputColumn, (DataType)IntegerType$.MODULE$).add(ratingColumn, (DataType)FloatType$.MODULE$));
        JavaUniverse $u5 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m5 = package$.MODULE$.universe().runtimeMirror(ALSModel.class.getClassLoader());
        JavaUniverse $u6 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m6 = package$.MODULE$.universe().runtimeMirror(ALSModel.class.getClassLoader());
        public final class Org_apache_spark_ml_recommendation_ALSModel$$typecreator25$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().thisPrefix((Symbols.SymbolApi)$m.RootClass()), (Symbols.SymbolApi)$m.staticPackage("scala")), (Symbols.SymbolApi)$m.staticModule("scala.package")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.package").asModule().moduleClass(), "Seq"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Float").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$))), (List)Nil$.MODULE$)), (List)Nil$.MODULE$)));
            }

            public Org_apache_spark_ml_recommendation_ALSModel$$typecreator25$1(ALSModel $outer) {
            }
        }
        public final class Org_apache_spark_ml_recommendation_ALSModel$$typecreator30$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala.collection.immutable").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.collection.immutable.Seq"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Float").asType().toTypeConstructor(), (List)Nil$.MODULE$))), (List)Nil$.MODULE$)), (List)Nil$.MODULE$)));
            }

            public Org_apache_spark_ml_recommendation_ALSModel$$typecreator30$1(ALSModel $outer) {
            }
        }
        return ratings.groupBy(srcOutputColumn, (Seq)Nil$.MODULE$).agg(ALSModel$.MODULE$.collect_top_k(functions$.MODULE$.struct(ratingColumn, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{dstOutputColumn})), num, false), (Seq)Nil$.MODULE$).as(srcFactors.sparkSession().implicits().newProductEncoder(((TypeTags)$u5).TypeTag().apply((Mirror)$m5, (TypeCreator)new Org_apache_spark_ml_recommendation_ALSModel$$typecreator25$1(null)))).map((Function1 & Serializable)t -> new Tuple2((Object)BoxesRunTime.boxToInteger((int)t._1$mcI$sp()), ((IterableOps)t._2()).map((Function1 & Serializable)p -> new Tuple2((Object)BoxesRunTime.boxToInteger((int)p._2$mcI$sp()), p._1()))), srcFactors.sparkSession().implicits().newProductEncoder(((TypeTags)$u6).TypeTag().apply((Mirror)$m6, (TypeCreator)new Org_apache_spark_ml_recommendation_ALSModel$$typecreator30$1(null)))).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{srcOutputColumn, recommendColumn})).withColumn(recommendColumn, functions$.MODULE$.col(recommendColumn).cast((DataType)arrayType));
    }

    private Dataset<Tuple2<int[], float[]>> blockify(Dataset<Tuple2<Object, float[]>> factors, int blockSize) {
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(ALSModel.class.getClassLoader());
        public final class Org_apache_spark_ml_recommendation_ALSModel$$typecreator5$2
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Array"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$)), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Array"), (List)new .colon.colon((Object)$m.staticClass("scala.Float").asType().toTypeConstructor(), (List)Nil$.MODULE$)), (List)Nil$.MODULE$)));
            }

            public Org_apache_spark_ml_recommendation_ALSModel$$typecreator5$2(ALSModel $outer) {
            }
        }
        return factors.mapPartitions((Function1 & Serializable)iter -> iter.grouped(blockSize).map((Function1 & Serializable)block -> new Tuple2(((IterableOnceOps)block.map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1._1$mcI$sp()))).toArray((ClassTag)ClassTag$.MODULE$.Int()), ((IterableOnceOps)block.flatMap((Function1 & Serializable)x$2 -> Predef$.MODULE$.wrapFloatArray((float[])x$2._2()))).toArray((ClassTag)ClassTag$.MODULE$.Float()))), factors.sparkSession().implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_recommendation_ALSModel$$typecreator5$2(null))));
    }

    @Override
    public long estimatedSize() {
        long userCount = this.userFactors().count();
        long itemCount = this.itemFactors().count();
        return (userCount + itemCount) * (long)(this.rank() + 1) * 4L;
    }

    public static final /* synthetic */ float $anonfun$predict$1(ALSModel $this, Seq featuresA, Seq featuresB) {
        if (featuresA != null && featuresB != null) {
            float dotProduct = 0.0f;
            for (int i = 0; i < $this.rank(); ++i) {
                dotProduct += BoxesRunTime.unboxToFloat((Object)featuresA.apply(i)) * BoxesRunTime.unboxToFloat((Object)featuresB.apply(i));
            }
            return dotProduct;
        }
        return Float.NaN;
    }

    public static final /* synthetic */ Tuple3 $anonfun$recommendForAll$4(int srcId$1, int[] dstIds$1, ObjectRef scores$1, int j) {
        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)srcId$1), (Object)BoxesRunTime.boxToInteger((int)dstIds$1[j]), (Object)BoxesRunTime.boxToFloat((float)((float[])scores$1.elem)[j]));
    }

    public static final /* synthetic */ Iterator $anonfun$recommendForAll$3(ALSModel $this, int n$1, float[] dstMat$1, float[] srcMat$1, ObjectRef scores$1, int[] srcIds$1, ObjectRef idxOrd$1, int num$1, int[] dstIds$1, int i) {
        BLAS$.MODULE$.javaBLAS().sgemv("T", $this.rank(), n$1, 1.0f, dstMat$1, 0, $this.rank(), srcMat$1, i * $this.rank(), 1, 0.0f, (float[])scores$1.elem, 0, 1);
        int srcId = srcIds$1[i];
        return CollectionConverters$.MODULE$.ListHasAsScala(((Ordering)idxOrd$1.elem).greatestOf(CollectionConverters$.MODULE$.IteratorHasAsJava(scala.package$.MODULE$.Iterator().range(0, n$1)).asJava(), num$1)).asScala().iterator().map((Function1 & Serializable)j -> ALSModel.$anonfun$recommendForAll$4(srcId, dstIds$1, scores$1, BoxesRunTime.unboxToInt((Object)j)));
    }

    public ALSModel(String uid, int rank, Dataset<Row> userFactors, Dataset<Row> itemFactors) {
        this.uid = uid;
        this.rank = rank;
        this.userFactors = userFactors;
        this.itemFactors = itemFactors;
        HasPredictionCol.$init$(this);
        HasBlockSize.$init$(this);
        ALSModelParams.$init$(this);
        MLWritable.$init$(this);
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(ALSModel.class.getClassLoader());
        JavaUniverse $u2 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(ALSModel.class.getClassLoader());
        public final class Org_apache_spark_ml_recommendation_ALSModel$$typecreator1$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().thisPrefix((Symbols.SymbolApi)$m.RootClass()), (Symbols.SymbolApi)$m.staticPackage("scala")), (Symbols.SymbolApi)$m.staticModule("scala.package")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.package").asModule().moduleClass(), "Seq"), (List)new .colon.colon((Object)$m.staticClass("scala.Float").asType().toTypeConstructor(), (List)Nil$.MODULE$));
            }

            public Org_apache_spark_ml_recommendation_ALSModel$$typecreator1$1(ALSModel $outer) {
            }
        }
        public final class Org_apache_spark_ml_recommendation_ALSModel$$typecreator2$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().thisPrefix((Symbols.SymbolApi)$m.RootClass()), (Symbols.SymbolApi)$m.staticPackage("scala")), (Symbols.SymbolApi)$m.staticModule("scala.package")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.package").asModule().moduleClass(), "Seq"), (List)new .colon.colon((Object)$m.staticClass("scala.Float").asType().toTypeConstructor(), (List)Nil$.MODULE$));
            }

            public Org_apache_spark_ml_recommendation_ALSModel$$typecreator2$1(ALSModel $outer) {
            }
        }
        this.predict = functions$.MODULE$.udf((Function2 & Serializable)(featuresA, featuresB) -> BoxesRunTime.boxToFloat((float)ALSModel.$anonfun$predict$1(this, featuresA, featuresB)), ((TypeTags)package$.MODULE$.universe()).TypeTag().Float(), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_recommendation_ALSModel$$typecreator1$1(null)), ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_ml_recommendation_ALSModel$$typecreator2$1(null)));
        Statics.releaseFence();
    }

    public ALSModel() {
        this("", -1, null, null);
    }

    private static class ALSModelReader
    extends MLReader<ALSModel> {
        private final String className = ALSModel.class.getName();

        private String className() {
            return this.className;
        }

        @Override
        public ALSModel load(String path) {
            Tuple2 tuple2;
            DefaultParamsReader.Metadata metadata = DefaultParamsReader$.MODULE$.loadMetadata(path, this.sparkSession(), this.className());
            DefaultFormats$ format = DefaultFormats$.MODULE$;
            int rank = BoxesRunTime.unboxToInt((Object)ExtractableJsonAstNode$.MODULE$.extract$extension(org.json4s.package$.MODULE$.jvalue2extractable(MonadicJValue$.MODULE$.$bslash$extension(org.json4s.package$.MODULE$.jvalue2monadic(metadata.metadata()), "rank")), (Formats)format, (Manifest)ManifestFactory$.MODULE$.Int()));
            String userPath = new Path(path, "userFactors").toString();
            String itemPath = new Path(path, "itemFactors").toString();
            if (BoxesRunTime.unboxToBoolean((Object)ReadWriteUtils$.MODULE$.localSavingModeState().get())) {
                JavaUniverse $u = package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(ALSModelReader.class.getClassLoader());
                public final class Org_apache_spark_ml_recommendation_ALSModel$ALSModelReader$$typecreator1$2
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $m.staticClass("org.apache.spark.ml.recommendation.FeatureData").asType().toTypeConstructor();
                    }

                    public Org_apache_spark_ml_recommendation_ALSModel$ALSModelReader$$typecreator1$2(ALSModelReader $outer) {
                    }
                }
                FeatureData[] userFactorsData = (FeatureData[])ReadWriteUtils$.MODULE$.loadArray(userPath, this.sparkSession(), (Function1 & Serializable)dis -> ALSModel$.MODULE$.deserializeData((DataInputStream)dis), ClassTag$.MODULE$.apply(FeatureData.class), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_recommendation_ALSModel$ALSModelReader$$typecreator1$2(null)));
                JavaUniverse $u2 = package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(ALSModelReader.class.getClassLoader());
                public final class Org_apache_spark_ml_recommendation_ALSModel$ALSModelReader$$typecreator2$2
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $m.staticClass("org.apache.spark.ml.recommendation.FeatureData").asType().toTypeConstructor();
                    }

                    public Org_apache_spark_ml_recommendation_ALSModel$ALSModelReader$$typecreator2$2(ALSModelReader $outer) {
                    }
                }
                Dataset userFactors = this.sparkSession().createDataFrame((Seq)ArrayImplicits$.MODULE$.SparkArrayOps((Object)userFactorsData).toImmutableArraySeq(), ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_ml_recommendation_ALSModel$ALSModelReader$$typecreator2$2(null)));
                JavaUniverse $u3 = package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m3 = package$.MODULE$.universe().runtimeMirror(ALSModelReader.class.getClassLoader());
                public final class Org_apache_spark_ml_recommendation_ALSModel$ALSModelReader$$typecreator3$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $m.staticClass("org.apache.spark.ml.recommendation.FeatureData").asType().toTypeConstructor();
                    }

                    public Org_apache_spark_ml_recommendation_ALSModel$ALSModelReader$$typecreator3$1(ALSModelReader $outer) {
                    }
                }
                FeatureData[] itemFactorsData = (FeatureData[])ReadWriteUtils$.MODULE$.loadArray(itemPath, this.sparkSession(), (Function1 & Serializable)dis -> ALSModel$.MODULE$.deserializeData((DataInputStream)dis), ClassTag$.MODULE$.apply(FeatureData.class), ((TypeTags)$u3).TypeTag().apply((Mirror)$m3, (TypeCreator)new Org_apache_spark_ml_recommendation_ALSModel$ALSModelReader$$typecreator3$1(null)));
                JavaUniverse $u4 = package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m4 = package$.MODULE$.universe().runtimeMirror(ALSModelReader.class.getClassLoader());
                public final class Org_apache_spark_ml_recommendation_ALSModel$ALSModelReader$$typecreator4$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $m.staticClass("org.apache.spark.ml.recommendation.FeatureData").asType().toTypeConstructor();
                    }

                    public Org_apache_spark_ml_recommendation_ALSModel$ALSModelReader$$typecreator4$1(ALSModelReader $outer) {
                    }
                }
                Dataset itemFactors = this.sparkSession().createDataFrame((Seq)ArrayImplicits$.MODULE$.SparkArrayOps((Object)itemFactorsData).toImmutableArraySeq(), ((TypeTags)$u4).TypeTag().apply((Mirror)$m4, (TypeCreator)new Org_apache_spark_ml_recommendation_ALSModel$ALSModelReader$$typecreator4$1(null)));
                v0 = new Tuple2((Object)userFactors, (Object)itemFactors);
            } else {
                Dataset userFactors = this.sparkSession().read().format("parquet").load(userPath);
                Dataset itemFactors = this.sparkSession().read().format("parquet").load(itemPath);
                v0 = tuple2 = new Tuple2((Object)userFactors, (Object)itemFactors);
            }
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Dataset userFactors = (Dataset)tuple2._1();
            Dataset itemFactors = (Dataset)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)userFactors, (Object)itemFactors);
            Dataset userFactors2 = (Dataset)tuple22._1();
            Dataset itemFactors2 = (Dataset)tuple22._2();
            ALSModel model = new ALSModel(metadata.uid(), rank, (Dataset<Row>)userFactors2, (Dataset<Row>)itemFactors2);
            metadata.getAndSetParams(model, metadata.getAndSetParams$default$2());
            return model;
        }
    }

    public static class ALSModelWriter
    extends MLWriter {
        private final ALSModel instance;

        @Override
        public void saveImpl(String path) {
            Tuple2 extraMetadata = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"rank"), (Object)BoxesRunTime.boxToInteger((int)this.instance.rank()));
            DefaultParamsWriter$.MODULE$.saveMetadata(this.instance, path, this.sparkSession(), (Option<JObject>)new Some((Object)JsonDSL$.MODULE$.pair2jvalue(extraMetadata, (Function1 & Serializable)x -> JsonDSL$.MODULE$.int2jvalue(BoxesRunTime.unboxToInt((Object)x)))));
            String userPath = new Path(path, "userFactors").toString();
            String itemPath = new Path(path, "itemFactors").toString();
            if (BoxesRunTime.unboxToBoolean((Object)ReadWriteUtils$.MODULE$.localSavingModeState().get())) {
                public final class Org_apache_spark_ml_recommendation_ALSModel$ALSModelWriter$$typecreator12$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $m.staticClass("org.apache.spark.ml.recommendation.FeatureData").asType().toTypeConstructor();
                    }

                    public Org_apache_spark_ml_recommendation_ALSModel$ALSModelWriter$$typecreator12$1(ALSModelWriter $outer) {
                    }
                }
                public final class Org_apache_spark_ml_recommendation_ALSModel$ALSModelWriter$$typecreator6$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $m.staticClass("org.apache.spark.ml.recommendation.FeatureData").asType().toTypeConstructor();
                    }

                    public Org_apache_spark_ml_recommendation_ALSModel$ALSModelWriter$$typecreator6$1(ALSModelWriter $outer) {
                    }
                }
                SparkSession sparkSession = BaseReadWrite.sparkSession$(this);
                JavaUniverse $u = package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(ALSModelWriter.class.getClassLoader());
                public final class Org_apache_spark_ml_recommendation_ALSModel$ALSModelWriter$$typecreator5$3
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $m.staticClass("org.apache.spark.ml.recommendation.FeatureData").asType().toTypeConstructor();
                    }

                    public Org_apache_spark_ml_recommendation_ALSModel$ALSModelWriter$$typecreator5$3(ALSModelWriter $outer) {
                    }
                }
                FeatureData[] userFactorsData = (FeatureData[])this.instance.userFactors().as(sparkSession.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_recommendation_ALSModel$ALSModelWriter$$typecreator5$3(null)))).collect();
                JavaUniverse $u2 = package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(ALSModelWriter.class.getClassLoader());
                ReadWriteUtils$.MODULE$.saveArray(userPath, userFactorsData, sparkSession, (Function2 & Serializable)(data, dos) -> {
                    ALSModel$.MODULE$.serializeData(data, dos);
                    return BoxedUnit.UNIT;
                }, ReadWriteUtils$.MODULE$.saveArray$default$5(), ClassTag$.MODULE$.apply(FeatureData.class), ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_ml_recommendation_ALSModel$ALSModelWriter$$typecreator6$1(null)));
                JavaUniverse $u3 = package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m3 = package$.MODULE$.universe().runtimeMirror(ALSModelWriter.class.getClassLoader());
                public final class Org_apache_spark_ml_recommendation_ALSModel$ALSModelWriter$$typecreator11$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $m.staticClass("org.apache.spark.ml.recommendation.FeatureData").asType().toTypeConstructor();
                    }

                    public Org_apache_spark_ml_recommendation_ALSModel$ALSModelWriter$$typecreator11$1(ALSModelWriter $outer) {
                    }
                }
                FeatureData[] itemFactorsData = (FeatureData[])this.instance.itemFactors().as(sparkSession.implicits().newProductEncoder(((TypeTags)$u3).TypeTag().apply((Mirror)$m3, (TypeCreator)new Org_apache_spark_ml_recommendation_ALSModel$ALSModelWriter$$typecreator11$1(null)))).collect();
                JavaUniverse $u4 = package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m4 = package$.MODULE$.universe().runtimeMirror(ALSModelWriter.class.getClassLoader());
                ReadWriteUtils$.MODULE$.saveArray(itemPath, itemFactorsData, sparkSession, (Function2 & Serializable)(data, dos) -> {
                    ALSModel$.MODULE$.serializeData(data, dos);
                    return BoxedUnit.UNIT;
                }, ReadWriteUtils$.MODULE$.saveArray$default$5(), ClassTag$.MODULE$.apply(FeatureData.class), ((TypeTags)$u4).TypeTag().apply((Mirror)$m4, (TypeCreator)new Org_apache_spark_ml_recommendation_ALSModel$ALSModelWriter$$typecreator12$1(null)));
                return;
            }
            this.instance.userFactors().write().format("parquet").save(userPath);
            this.instance.itemFactors().write().format("parquet").save(itemPath);
        }

        public ALSModelWriter(ALSModel instance) {
            this.instance = instance;
        }
    }
}

