/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Objects;
import org.apache.datasketches.common.ArrayOfItemsSerDe;
import org.apache.datasketches.common.ArrayOfLongsSerDe;
import org.apache.datasketches.common.ArrayOfNumbersSerDe;
import org.apache.datasketches.common.ByteArrayUtil;
import org.apache.datasketches.common.Util;
import org.apache.datasketches.memory.Memory;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.DecimalType;

public class ArrayOfDecimalsSerDe
extends ArrayOfItemsSerDe<Decimal> {
    private final int precision;
    private final int scale;
    private final DecimalType decimalType;
    private final ArrayOfItemsSerDe<?> delegate;

    public ArrayOfDecimalsSerDe(DecimalType decimalType) {
        this.decimalType = decimalType;
        this.precision = decimalType.precision();
        this.scale = decimalType.scale();
        this.delegate = DecimalType.is32BitDecimalType((DataType)decimalType) ? new ArrayOfNumbersSerDe() : (DecimalType.is64BitDecimalType((DataType)decimalType) ? new ArrayOfLongsSerDe() : new ArrayOfDecimalByteArrSerDe(decimalType));
    }

    public byte[] serializeToByteArray(Decimal item) {
        Objects.requireNonNull(item, "Item must not be null");
        if (DecimalType.is32BitDecimalType((DataType)this.decimalType)) {
            return ((ArrayOfNumbersSerDe)this.delegate).serializeToByteArray((Number)this.decimalToInt(item));
        }
        if (DecimalType.is64BitDecimalType((DataType)this.decimalType)) {
            return ((ArrayOfLongsSerDe)this.delegate).serializeToByteArray(Long.valueOf(item.toUnscaledLong()));
        }
        return ((ArrayOfDecimalByteArrSerDe)this.delegate).serializeToByteArray(item);
    }

    public byte[] serializeToByteArray(Decimal[] items) {
        Objects.requireNonNull(items, "Item must not be null");
        if (DecimalType.is32BitDecimalType((DataType)this.decimalType)) {
            Number[] intItems = new Number[items.length];
            for (int i = 0; i < items.length; ++i) {
                intItems[i] = this.decimalToInt(items[i]);
            }
            return ((ArrayOfNumbersSerDe)this.delegate).serializeToByteArray(intItems);
        }
        if (DecimalType.is64BitDecimalType((DataType)this.decimalType)) {
            Long[] longItems = new Long[items.length];
            for (int i = 0; i < items.length; ++i) {
                longItems[i] = items[i].toUnscaledLong();
            }
            return ((ArrayOfLongsSerDe)this.delegate).serializeToByteArray(longItems);
        }
        return ((ArrayOfDecimalByteArrSerDe)this.delegate).serializeToByteArray(items);
    }

    public Decimal[] deserializeFromMemory(Memory mem, long offsetBytes, int numItems) {
        Objects.requireNonNull(mem, "Memory must not be null");
        if (DecimalType.is32BitDecimalType((DataType)this.decimalType)) {
            Number[] intArray = ((ArrayOfNumbersSerDe)this.delegate).deserializeFromMemory(mem, offsetBytes, numItems);
            Decimal[] result = new Decimal[intArray.length];
            for (int i = 0; i < intArray.length; ++i) {
                result[i] = Decimal.createUnsafe((long)((Integer)intArray[i]).intValue(), (int)this.precision, (int)this.scale);
            }
            return result;
        }
        if (DecimalType.is64BitDecimalType((DataType)this.decimalType)) {
            Long[] longArray = ((ArrayOfLongsSerDe)this.delegate).deserializeFromMemory(mem, offsetBytes, numItems);
            Decimal[] result = new Decimal[longArray.length];
            for (int i = 0; i < longArray.length; ++i) {
                result[i] = Decimal.createUnsafe((long)longArray[i], (int)this.precision, (int)this.scale);
            }
            return result;
        }
        return ((ArrayOfDecimalByteArrSerDe)this.delegate).deserializeFromMemory(mem, offsetBytes, numItems);
    }

    public int sizeOf(Decimal item) {
        Objects.requireNonNull(item, "Item must not be null");
        if (DecimalType.is32BitDecimalType((DataType)this.decimalType)) {
            return ((ArrayOfNumbersSerDe)this.delegate).sizeOf((Number)this.decimalToInt(item));
        }
        if (DecimalType.is64BitDecimalType((DataType)this.decimalType)) {
            return ((ArrayOfLongsSerDe)this.delegate).sizeOf(Long.valueOf(item.toUnscaledLong()));
        }
        return ((ArrayOfDecimalByteArrSerDe)this.delegate).sizeOf(item);
    }

    public int sizeOf(Memory mem, long offsetBytes, int numItems) {
        Objects.requireNonNull(mem, "Memory must not be null");
        return this.delegate.sizeOf(mem, offsetBytes, numItems);
    }

    public String toString(Decimal item) {
        if (item == null) {
            return "null";
        }
        return item.toString();
    }

    public Class<Decimal> getClassOfT() {
        return Decimal.class;
    }

    private int decimalToInt(Decimal item) {
        return (int)item.toUnscaledLong();
    }

    private static class ArrayOfDecimalByteArrSerDe
    extends ArrayOfItemsSerDe<Decimal> {
        private final int precision;
        private final int scale;

        ArrayOfDecimalByteArrSerDe(DecimalType decimalType) {
            assert (DecimalType.isByteArrayDecimalType((DataType)decimalType));
            this.precision = decimalType.precision();
            this.scale = decimalType.scale();
        }

        public byte[] serializeToByteArray(Decimal item) {
            Objects.requireNonNull(item, "Item must not be null");
            byte[] decimalByteArr = item.toJavaBigDecimal().unscaledValue().toByteArray();
            int numBytes = decimalByteArr.length;
            byte[] out = new byte[numBytes + 4];
            ByteArrayUtil.copyBytes((byte[])decimalByteArr, (int)0, (byte[])out, (int)4, (int)numBytes);
            ByteArrayUtil.putIntLE((byte[])out, (int)0, (int)numBytes);
            return out;
        }

        public byte[] serializeToByteArray(Decimal[] items) {
            Objects.requireNonNull(items, "Items must not be null");
            if (items.length == 0) {
                return new byte[0];
            }
            int totalBytes = 0;
            int numItems = items.length;
            byte[][] serialized2DArray = new byte[numItems][];
            for (int i = 0; i < numItems; ++i) {
                serialized2DArray[i] = items[i].toJavaBigDecimal().unscaledValue().toByteArray();
                totalBytes += serialized2DArray[i].length + 4;
            }
            byte[] bytesOut = new byte[totalBytes];
            int offset = 0;
            for (int i = 0; i < numItems; ++i) {
                int decimalLen = serialized2DArray[i].length;
                ByteArrayUtil.putIntLE((byte[])bytesOut, (int)offset, (int)decimalLen);
                ByteArrayUtil.copyBytes((byte[])serialized2DArray[i], (int)0, (byte[])bytesOut, (int)(offset += 4), (int)decimalLen);
                offset += decimalLen;
            }
            return bytesOut;
        }

        public Decimal[] deserializeFromMemory(Memory mem, long offsetBytes, int numItems) {
            Objects.requireNonNull(mem, "Memory must not be null");
            if (numItems <= 0) {
                return new Decimal[0];
            }
            Decimal[] array = new Decimal[numItems];
            long offset = offsetBytes;
            for (int i = 0; i < numItems; ++i) {
                Util.checkBounds((long)offset, (long)4L, (long)mem.getCapacity());
                int decimalLength = mem.getInt(offset);
                byte[] decimalBytes = new byte[decimalLength];
                Util.checkBounds((long)(offset += 4L), (long)decimalLength, (long)mem.getCapacity());
                mem.getByteArray(offset, decimalBytes, 0, decimalLength);
                offset += (long)decimalLength;
                BigInteger bigInteger = new BigInteger(decimalBytes);
                BigDecimal javaDecimal = new BigDecimal(bigInteger, this.scale);
                array[i] = Decimal.apply((BigDecimal)javaDecimal, (int)this.precision, (int)this.scale);
            }
            return array;
        }

        public int sizeOf(Decimal item) {
            Objects.requireNonNull(item, "Item must not be null");
            return item.toJavaBigDecimal().unscaledValue().toByteArray().length + 4;
        }

        public int sizeOf(Memory mem, long offsetBytes, int numItems) {
            Objects.requireNonNull(mem, "Memory must not be null");
            if (numItems <= 0) {
                return 0;
            }
            long offset = offsetBytes;
            long memCap = mem.getCapacity();
            for (int i = 0; i < numItems; ++i) {
                Util.checkBounds((long)offset, (long)4L, (long)memCap);
                int itemLenBytes = mem.getInt(offset);
                Util.checkBounds((long)(offset += 4L), (long)itemLenBytes, (long)memCap);
                offset += (long)itemLenBytes;
            }
            return (int)(offset - offsetBytes);
        }

        public String toString(Decimal item) {
            if (item == null) {
                return "null";
            }
            return item.toString();
        }

        public Class<Decimal> getClassOfT() {
            return Decimal.class;
        }
    }
}

