/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.aggregate;

import org.apache.spark.sql.catalyst.dsl.package$expressions$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.aggregate.MaxBy$;
import org.apache.spark.sql.catalyst.expressions.aggregate.MaxMinBy;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(x, y) - Returns the value of `x` associated with the maximum value of `y`.", examples="\n    Examples:\n      > SELECT _FUNC_(x, y) FROM VALUES ('a', 10), ('b', 50), ('c', 20) AS tab(x, y);\n       b\n  ", note="\n    The function is non-deterministic so the output order can be different for\n    those associated the same values of `x`.\n  ", group="agg_funcs", since="3.0.0")
@ScalaSignature(bytes="\u0006\u0005\u0005]f\u0001B\u000e\u001d\u0001.B\u0001B\u0011\u0001\u0003\u0016\u0004%\ta\u0011\u0005\t\u0011\u0002\u0011\t\u0012)A\u0005\t\"A\u0011\n\u0001BK\u0002\u0013\u00051\t\u0003\u0005K\u0001\tE\t\u0015!\u0003E\u0011\u0015Y\u0005\u0001\"\u0001M\u0011\u0015\u0001\u0006\u0001\"\u0011R\u0011\u0015Q\u0006\u0001\"\u0015\\\u0011\u0015\u0001\u0007\u0001\"\u0015b\u0011\u0015!\u0007\u0001\"\u0015f\u0011\u001dQ\u0007!!A\u0005\u0002-DqA\u001c\u0001\u0012\u0002\u0013\u0005q\u000eC\u0004{\u0001E\u0005I\u0011A8\t\u000fm\u0004\u0011\u0011!C!y\"I\u0011\u0011\u0002\u0001\u0002\u0002\u0013\u0005\u00111\u0002\u0005\n\u0003'\u0001\u0011\u0011!C\u0001\u0003+A\u0011\"!\t\u0001\u0003\u0003%\t%a\t\t\u0013\u0005E\u0002!!A\u0005\u0002\u0005M\u0002\"CA\u001f\u0001\u0005\u0005I\u0011IA \u0011%\t\u0019\u0005AA\u0001\n\u0003\n)eB\u0005\u0002pq\t\t\u0011#\u0001\u0002r\u0019A1\u0004HA\u0001\u0012\u0003\t\u0019\b\u0003\u0004L+\u0011\u0005\u00111\u0012\u0005\n\u0003\u001b+\u0012\u0011!C#\u0003\u001fC\u0011\"!%\u0016\u0003\u0003%\t)a%\t\u0013\u0005eU#!A\u0005\u0002\u0006m\u0005\"CAW+\u0005\u0005I\u0011BAX\u0005\u0015i\u0015\r\u001f\"z\u0015\tib$A\u0005bO\u001e\u0014XmZ1uK*\u0011q\u0004I\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002\"E\u0005A1-\u0019;bYf\u001cHO\u0003\u0002$I\u0005\u00191/\u001d7\u000b\u0005\u00152\u0013!B:qCJ\\'BA\u0014)\u0003\u0019\t\u0007/Y2iK*\t\u0011&A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u0001YA2\u0004CA\u0017/\u001b\u0005a\u0012BA\u0018\u001d\u0005!i\u0015\r_'j]\nK\bCA\u00195\u001b\u0005\u0011$\"A\u001a\u0002\u000bM\u001c\u0017\r\\1\n\u0005U\u0012$a\u0002)s_\u0012,8\r\u001e\t\u0003o}r!\u0001O\u001f\u000f\u0005ebT\"\u0001\u001e\u000b\u0005mR\u0013A\u0002\u001fs_>$h(C\u00014\u0013\tq$'A\u0004qC\u000e\\\u0017mZ3\n\u0005\u0001\u000b%\u0001D*fe&\fG.\u001b>bE2,'B\u0001 3\u0003%1\u0018\r\\;f\u000bb\u0004(/F\u0001E!\t)e)D\u0001\u001f\u0013\t9eD\u0001\u0006FqB\u0014Xm]:j_:\f!B^1mk\u0016,\u0005\u0010\u001d:!\u00031y'\u000fZ3sS:<W\t\u001f9s\u00035y'\u000fZ3sS:<W\t\u001f9sA\u00051A(\u001b8jiz\"2!\u0014(P!\ti\u0003\u0001C\u0003C\u000b\u0001\u0007A\tC\u0003J\u000b\u0001\u0007A)\u0001\u0006qe\u0016$H/\u001f(b[\u0016,\u0012A\u0015\t\u0003'^s!\u0001V+\u0011\u0005e\u0012\u0014B\u0001,3\u0003\u0019\u0001&/\u001a3fM&\u0011\u0001,\u0017\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005Y\u0013\u0014!\u00039sK\u0012L7-\u0019;f)\r!EL\u0018\u0005\u0006;\u001e\u0001\r\u0001R\u0001\b_2$W\t\u001f9s\u0011\u0015yv\u00011\u0001E\u0003\u001dqWm^#yaJ\fqb\u001c:eKJLgnZ+qI\u0006$XM\u001d\u000b\u0004\t\n\u001c\u0007\"B/\t\u0001\u0004!\u0005\"B0\t\u0001\u0004!\u0015aF<ji\"tUm^\"iS2$'/\u001a8J]R,'O\\1m)\rie\r\u001b\u0005\u0006O&\u0001\r\u0001R\u0001\b]\u0016<H*\u001a4u\u0011\u0015I\u0017\u00021\u0001E\u0003!qWm\u001e*jO\"$\u0018\u0001B2paf$2!\u00147n\u0011\u001d\u0011%\u0002%AA\u0002\u0011Cq!\u0013\u0006\u0011\u0002\u0003\u0007A)\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0003AT#\u0001R9,\u0003I\u0004\"a\u001d=\u000e\u0003QT!!\u001e<\u0002\u0013Ut7\r[3dW\u0016$'BA<3\u0003)\tgN\\8uCRLwN\\\u0005\u0003sR\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII\nQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DX#A?\u0011\u0007y\f9!D\u0001\u0000\u0015\u0011\t\t!a\u0001\u0002\t1\fgn\u001a\u0006\u0003\u0003\u000b\tAA[1wC&\u0011\u0001l`\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0003\u001b\u00012!MA\b\u0013\r\t\tB\r\u0002\u0004\u0013:$\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0003/\ti\u0002E\u00022\u00033I1!a\u00073\u0005\r\te.\u001f\u0005\n\u0003?y\u0011\u0011!a\u0001\u0003\u001b\t1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAA\u0013!\u0019\t9#!\f\u0002\u00185\u0011\u0011\u0011\u0006\u0006\u0004\u0003W\u0011\u0014AC2pY2,7\r^5p]&!\u0011qFA\u0015\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\t\u0005U\u00121\b\t\u0004c\u0005]\u0012bAA\u001de\t9!i\\8mK\u0006t\u0007\"CA\u0010#\u0005\u0005\t\u0019AA\f\u0003I\u0001(o\u001c3vGR,E.Z7f]Rt\u0015-\\3\u0015\u0007u\f\t\u0005C\u0005\u0002 I\t\t\u00111\u0001\u0002\u000e\u00051Q-];bYN$B!!\u000e\u0002H!I\u0011qD\n\u0002\u0002\u0003\u0007\u0011q\u0003\u0015\u0018\u0001\u0005-\u0013\u0011KA*\u0003/\nI&!\u0018\u0002`\u0005\r\u0014QMA5\u0003W\u00022!RA'\u0013\r\tyE\b\u0002\u0016\u000bb\u0004(/Z:tS>tG)Z:de&\u0004H/[8o\u0003\u0015)8/Y4fC\t\t)&A)`\rVs5i\u0018\u0015yY\u0001J\u0018\u0006I\u0017!%\u0016$XO\u001d8tAQDW\r\t<bYV,\u0007e\u001c4!Ab\u0004\u0007%Y:t_\u000eL\u0017\r^3eA]LG\u000f\u001b\u0011uQ\u0016\u0004S.\u0019=j[Vl\u0007E^1mk\u0016\u0004sN\u001a\u0011as\u0002t\u0013\u0001C3yC6\u0004H.Z:\"\u0005\u0005m\u0013\u0001\u001d\u0006!A\u0001\u0002S\t_1na2,7O\u000f\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)q2\u0002\u00130\u000b\u0011G%>k\u0005EV!M+\u0016\u001b\u0006\u0005K\u0014bO1\u0002\u0013\u0007M\u0015-A!:#m\n\u0017!kAJC\u0006\t\u0015(G\u001eb\u0003E\r\u0019*A\u0005\u001b\u0006\u0005^1cQad\u0003%_\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!A\tT\u0001\u0005I\u0001\u0005]>$X-\t\u0002\u0002b\u0005y(\u0002\t\u0011!AQCW\r\t4v]\u000e$\u0018n\u001c8!SN\u0004cn\u001c8.I\u0016$XM]7j]&\u001cH/[2!g>\u0004C\u000f[3!_V$\b/\u001e;!_J$WM\u001d\u0011dC:\u0004#-\u001a\u0011eS\u001a4WM]3oi\u00022wN\u001d\u0006!A\u0001\u0002C\u000f[8tK\u0002\n7o]8dS\u0006$X\r\u001a\u0011uQ\u0016\u00043/Y7fAY\fG.^3tA=4\u0007\u0005\u0019=a])\u0001\u0003%A\u0003he>,\b/\t\u0002\u0002h\u0005I\u0011mZ4`MVt7m]\u0001\u0006g&t7-Z\u0011\u0003\u0003[\nQa\r\u00181]A\nQ!T1y\u0005f\u0004\"!L\u000b\u0014\u000bU\t)(!!\u0011\u000f\u0005]\u0014Q\u0010#E\u001b6\u0011\u0011\u0011\u0010\u0006\u0004\u0003w\u0012\u0014a\u0002:v]RLW.Z\u0005\u0005\u0003\u007f\nIHA\tBEN$(/Y2u\rVt7\r^5p]J\u0002B!a!\u0002\n6\u0011\u0011Q\u0011\u0006\u0005\u0003\u000f\u000b\u0019!\u0001\u0002j_&\u0019\u0001)!\"\u0015\u0005\u0005E\u0014\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0003u\fQ!\u00199qYf$R!TAK\u0003/CQA\u0011\rA\u0002\u0011CQ!\u0013\rA\u0002\u0011\u000bq!\u001e8baBd\u0017\u0010\u0006\u0003\u0002\u001e\u0006%\u0006#B\u0019\u0002 \u0006\r\u0016bAAQe\t1q\n\u001d;j_:\u0004R!MAS\t\u0012K1!a*3\u0005\u0019!V\u000f\u001d7fe!A\u00111V\r\u0002\u0002\u0003\u0007Q*A\u0002yIA\nAb\u001e:ji\u0016\u0014V\r\u001d7bG\u0016$\"!!-\u0011\u0007y\f\u0019,C\u0002\u00026~\u0014aa\u00142kK\u000e$\b")
public class MaxBy
extends MaxMinBy {
    private final Expression valueExpr;
    private final Expression orderingExpr;

    public static Option<Tuple2<Expression, Expression>> unapply(MaxBy x$0) {
        return MaxBy$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple2<Expression, Expression>, MaxBy> tupled() {
        return MaxBy$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, MaxBy>> curried() {
        return MaxBy$.MODULE$.curried();
    }

    @Override
    public Expression valueExpr() {
        return this.valueExpr;
    }

    @Override
    public Expression orderingExpr() {
        return this.orderingExpr;
    }

    @Override
    public String prettyName() {
        return "max_by";
    }

    @Override
    public Expression predicate(Expression oldExpr, Expression newExpr) {
        return (Expression)((Object)package$expressions$.MODULE$.DslExpression(oldExpr).$greater(newExpr));
    }

    @Override
    public Expression orderingUpdater(Expression oldExpr, Expression newExpr) {
        return package$expressions$.MODULE$.greatest((Seq<Expression>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{oldExpr, newExpr}));
    }

    @Override
    public MaxBy withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight);
    }

    public MaxBy copy(Expression valueExpr, Expression orderingExpr) {
        return new MaxBy(valueExpr, orderingExpr);
    }

    public Expression copy$default$1() {
        return this.valueExpr();
    }

    public Expression copy$default$2() {
        return this.orderingExpr();
    }

    @Override
    public String productPrefix() {
        return "MaxBy";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.valueExpr();
            }
            case 1: {
                return this.orderingExpr();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof MaxBy;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "valueExpr";
            }
            case 1: {
                return "orderingExpr";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof MaxBy)) return false;
        boolean bl = true;
        if (!bl) return false;
        MaxBy maxBy = (MaxBy)x$1;
        Expression expression = this.valueExpr();
        Expression expression2 = maxBy.valueExpr();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.orderingExpr();
        Expression expression4 = maxBy.orderingExpr();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!maxBy.canEqual(this)) return false;
        return true;
    }

    public MaxBy(Expression valueExpr, Expression orderingExpr) {
        this.valueExpr = valueExpr;
        this.orderingExpr = orderingExpr;
    }
}

