/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ConfigMapKeySelector;
import io.fabric8.kubernetes.api.model.ConfigMapKeySelectorBuilder;
import io.fabric8.kubernetes.api.model.ConfigMapKeySelectorFluent;
import io.fabric8.kubernetes.api.model.EnvVarSource;
import io.fabric8.kubernetes.api.model.ObjectFieldSelector;
import io.fabric8.kubernetes.api.model.ObjectFieldSelectorBuilder;
import io.fabric8.kubernetes.api.model.ObjectFieldSelectorFluent;
import io.fabric8.kubernetes.api.model.ResourceFieldSelector;
import io.fabric8.kubernetes.api.model.ResourceFieldSelectorBuilder;
import io.fabric8.kubernetes.api.model.ResourceFieldSelectorFluent;
import io.fabric8.kubernetes.api.model.SecretKeySelector;
import io.fabric8.kubernetes.api.model.SecretKeySelectorBuilder;
import io.fabric8.kubernetes.api.model.SecretKeySelectorFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class EnvVarSourceFluent<A extends EnvVarSourceFluent<A>>
extends BaseFluent<A> {
    private ConfigMapKeySelectorBuilder configMapKeyRef;
    private ObjectFieldSelectorBuilder fieldRef;
    private ResourceFieldSelectorBuilder resourceFieldRef;
    private SecretKeySelectorBuilder secretKeyRef;
    private Map<String, Object> additionalProperties;

    public EnvVarSourceFluent() {
    }

    public EnvVarSourceFluent(EnvVarSource instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(EnvVarSource instance) {
        EnvVarSource envVarSource = instance = instance != null ? instance : new EnvVarSource();
        if (instance != null) {
            this.withConfigMapKeyRef(instance.getConfigMapKeyRef());
            this.withFieldRef(instance.getFieldRef());
            this.withResourceFieldRef(instance.getResourceFieldRef());
            this.withSecretKeyRef(instance.getSecretKeyRef());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public ConfigMapKeySelector buildConfigMapKeyRef() {
        return this.configMapKeyRef != null ? this.configMapKeyRef.build() : null;
    }

    public A withConfigMapKeyRef(ConfigMapKeySelector configMapKeyRef) {
        this._visitables.remove((Object)"configMapKeyRef");
        if (configMapKeyRef != null) {
            this.configMapKeyRef = new ConfigMapKeySelectorBuilder(configMapKeyRef);
            this._visitables.get((Object)"configMapKeyRef").add(this.configMapKeyRef);
        } else {
            this.configMapKeyRef = null;
            this._visitables.get((Object)"configMapKeyRef").remove((Object)this.configMapKeyRef);
        }
        return (A)((Object)this);
    }

    public boolean hasConfigMapKeyRef() {
        return this.configMapKeyRef != null;
    }

    public A withNewConfigMapKeyRef(String key, String name, Boolean optional) {
        return this.withConfigMapKeyRef(new ConfigMapKeySelector(key, name, optional));
    }

    public ConfigMapKeyRefNested<A> withNewConfigMapKeyRef() {
        return new ConfigMapKeyRefNested(null);
    }

    public ConfigMapKeyRefNested<A> withNewConfigMapKeyRefLike(ConfigMapKeySelector item) {
        return new ConfigMapKeyRefNested(item);
    }

    public ConfigMapKeyRefNested<A> editConfigMapKeyRef() {
        return this.withNewConfigMapKeyRefLike(Optional.ofNullable(this.buildConfigMapKeyRef()).orElse(null));
    }

    public ConfigMapKeyRefNested<A> editOrNewConfigMapKeyRef() {
        return this.withNewConfigMapKeyRefLike(Optional.ofNullable(this.buildConfigMapKeyRef()).orElse(new ConfigMapKeySelectorBuilder().build()));
    }

    public ConfigMapKeyRefNested<A> editOrNewConfigMapKeyRefLike(ConfigMapKeySelector item) {
        return this.withNewConfigMapKeyRefLike(Optional.ofNullable(this.buildConfigMapKeyRef()).orElse(item));
    }

    public ObjectFieldSelector buildFieldRef() {
        return this.fieldRef != null ? this.fieldRef.build() : null;
    }

    public A withFieldRef(ObjectFieldSelector fieldRef) {
        this._visitables.remove((Object)"fieldRef");
        if (fieldRef != null) {
            this.fieldRef = new ObjectFieldSelectorBuilder(fieldRef);
            this._visitables.get((Object)"fieldRef").add(this.fieldRef);
        } else {
            this.fieldRef = null;
            this._visitables.get((Object)"fieldRef").remove((Object)this.fieldRef);
        }
        return (A)((Object)this);
    }

    public boolean hasFieldRef() {
        return this.fieldRef != null;
    }

    public A withNewFieldRef(String apiVersion, String fieldPath) {
        return this.withFieldRef(new ObjectFieldSelector(apiVersion, fieldPath));
    }

    public FieldRefNested<A> withNewFieldRef() {
        return new FieldRefNested(null);
    }

    public FieldRefNested<A> withNewFieldRefLike(ObjectFieldSelector item) {
        return new FieldRefNested(item);
    }

    public FieldRefNested<A> editFieldRef() {
        return this.withNewFieldRefLike(Optional.ofNullable(this.buildFieldRef()).orElse(null));
    }

    public FieldRefNested<A> editOrNewFieldRef() {
        return this.withNewFieldRefLike(Optional.ofNullable(this.buildFieldRef()).orElse(new ObjectFieldSelectorBuilder().build()));
    }

    public FieldRefNested<A> editOrNewFieldRefLike(ObjectFieldSelector item) {
        return this.withNewFieldRefLike(Optional.ofNullable(this.buildFieldRef()).orElse(item));
    }

    public ResourceFieldSelector buildResourceFieldRef() {
        return this.resourceFieldRef != null ? this.resourceFieldRef.build() : null;
    }

    public A withResourceFieldRef(ResourceFieldSelector resourceFieldRef) {
        this._visitables.remove((Object)"resourceFieldRef");
        if (resourceFieldRef != null) {
            this.resourceFieldRef = new ResourceFieldSelectorBuilder(resourceFieldRef);
            this._visitables.get((Object)"resourceFieldRef").add(this.resourceFieldRef);
        } else {
            this.resourceFieldRef = null;
            this._visitables.get((Object)"resourceFieldRef").remove((Object)this.resourceFieldRef);
        }
        return (A)((Object)this);
    }

    public boolean hasResourceFieldRef() {
        return this.resourceFieldRef != null;
    }

    public ResourceFieldRefNested<A> withNewResourceFieldRef() {
        return new ResourceFieldRefNested(null);
    }

    public ResourceFieldRefNested<A> withNewResourceFieldRefLike(ResourceFieldSelector item) {
        return new ResourceFieldRefNested(item);
    }

    public ResourceFieldRefNested<A> editResourceFieldRef() {
        return this.withNewResourceFieldRefLike(Optional.ofNullable(this.buildResourceFieldRef()).orElse(null));
    }

    public ResourceFieldRefNested<A> editOrNewResourceFieldRef() {
        return this.withNewResourceFieldRefLike(Optional.ofNullable(this.buildResourceFieldRef()).orElse(new ResourceFieldSelectorBuilder().build()));
    }

    public ResourceFieldRefNested<A> editOrNewResourceFieldRefLike(ResourceFieldSelector item) {
        return this.withNewResourceFieldRefLike(Optional.ofNullable(this.buildResourceFieldRef()).orElse(item));
    }

    public SecretKeySelector buildSecretKeyRef() {
        return this.secretKeyRef != null ? this.secretKeyRef.build() : null;
    }

    public A withSecretKeyRef(SecretKeySelector secretKeyRef) {
        this._visitables.remove((Object)"secretKeyRef");
        if (secretKeyRef != null) {
            this.secretKeyRef = new SecretKeySelectorBuilder(secretKeyRef);
            this._visitables.get((Object)"secretKeyRef").add(this.secretKeyRef);
        } else {
            this.secretKeyRef = null;
            this._visitables.get((Object)"secretKeyRef").remove((Object)this.secretKeyRef);
        }
        return (A)((Object)this);
    }

    public boolean hasSecretKeyRef() {
        return this.secretKeyRef != null;
    }

    public A withNewSecretKeyRef(String key, String name, Boolean optional) {
        return this.withSecretKeyRef(new SecretKeySelector(key, name, optional));
    }

    public SecretKeyRefNested<A> withNewSecretKeyRef() {
        return new SecretKeyRefNested(null);
    }

    public SecretKeyRefNested<A> withNewSecretKeyRefLike(SecretKeySelector item) {
        return new SecretKeyRefNested(item);
    }

    public SecretKeyRefNested<A> editSecretKeyRef() {
        return this.withNewSecretKeyRefLike(Optional.ofNullable(this.buildSecretKeyRef()).orElse(null));
    }

    public SecretKeyRefNested<A> editOrNewSecretKeyRef() {
        return this.withNewSecretKeyRefLike(Optional.ofNullable(this.buildSecretKeyRef()).orElse(new SecretKeySelectorBuilder().build()));
    }

    public SecretKeyRefNested<A> editOrNewSecretKeyRefLike(SecretKeySelector item) {
        return this.withNewSecretKeyRefLike(Optional.ofNullable(this.buildSecretKeyRef()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        EnvVarSourceFluent that = (EnvVarSourceFluent)((Object)o);
        if (!Objects.equals((Object)this.configMapKeyRef, (Object)that.configMapKeyRef)) {
            return false;
        }
        if (!Objects.equals((Object)this.fieldRef, (Object)that.fieldRef)) {
            return false;
        }
        if (!Objects.equals((Object)this.resourceFieldRef, (Object)that.resourceFieldRef)) {
            return false;
        }
        if (!Objects.equals((Object)this.secretKeyRef, (Object)that.secretKeyRef)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.configMapKeyRef, this.fieldRef, this.resourceFieldRef, this.secretKeyRef, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.configMapKeyRef != null) {
            sb.append("configMapKeyRef:");
            sb.append(String.valueOf((Object)this.configMapKeyRef) + ",");
        }
        if (this.fieldRef != null) {
            sb.append("fieldRef:");
            sb.append(String.valueOf((Object)this.fieldRef) + ",");
        }
        if (this.resourceFieldRef != null) {
            sb.append("resourceFieldRef:");
            sb.append(String.valueOf((Object)this.resourceFieldRef) + ",");
        }
        if (this.secretKeyRef != null) {
            sb.append("secretKeyRef:");
            sb.append(String.valueOf((Object)this.secretKeyRef) + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class SecretKeyRefNested<N>
    extends SecretKeySelectorFluent<SecretKeyRefNested<N>>
    implements Nested<N> {
        SecretKeySelectorBuilder builder;

        SecretKeyRefNested(SecretKeySelector item) {
            this.builder = new SecretKeySelectorBuilder(this, item);
        }

        public N and() {
            return (N)EnvVarSourceFluent.this.withSecretKeyRef(this.builder.build());
        }

        public N endSecretKeyRef() {
            return this.and();
        }
    }

    public class ResourceFieldRefNested<N>
    extends ResourceFieldSelectorFluent<ResourceFieldRefNested<N>>
    implements Nested<N> {
        ResourceFieldSelectorBuilder builder;

        ResourceFieldRefNested(ResourceFieldSelector item) {
            this.builder = new ResourceFieldSelectorBuilder(this, item);
        }

        public N and() {
            return (N)EnvVarSourceFluent.this.withResourceFieldRef(this.builder.build());
        }

        public N endResourceFieldRef() {
            return this.and();
        }
    }

    public class FieldRefNested<N>
    extends ObjectFieldSelectorFluent<FieldRefNested<N>>
    implements Nested<N> {
        ObjectFieldSelectorBuilder builder;

        FieldRefNested(ObjectFieldSelector item) {
            this.builder = new ObjectFieldSelectorBuilder(this, item);
        }

        public N and() {
            return (N)EnvVarSourceFluent.this.withFieldRef(this.builder.build());
        }

        public N endFieldRef() {
            return this.and();
        }
    }

    public class ConfigMapKeyRefNested<N>
    extends ConfigMapKeySelectorFluent<ConfigMapKeyRefNested<N>>
    implements Nested<N> {
        ConfigMapKeySelectorBuilder builder;

        ConfigMapKeyRefNested(ConfigMapKeySelector item) {
            this.builder = new ConfigMapKeySelectorBuilder(this, item);
        }

        public N and() {
            return (N)EnvVarSourceFluent.this.withConfigMapKeyRef(this.builder.build());
        }

        public N endConfigMapKeyRef() {
            return this.and();
        }
    }
}

