/*
 * Decompiled with CFR 0.152.
 */
package org.sparkproject.jpmml.model.temporals;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeParseException;
import java.util.Objects;
import org.sparkproject.dmg.pmml.DataType;
import org.sparkproject.jpmml.model.temporals.DaysSinceDate;
import org.sparkproject.jpmml.model.temporals.Instant;

public class Date
extends Instant<Date> {
    private LocalDate date = null;

    private Date() {
    }

    public Date(int year, int month, int dayOfMonth) {
        this(LocalDate.of(year, month, dayOfMonth));
    }

    public Date(LocalDate date) {
        this.setDate(date);
    }

    @Override
    public DataType getDataType() {
        return DataType.DATE;
    }

    @Override
    public String toSimpleValue() {
        LocalDate date = this.getDate();
        return date.toString();
    }

    @Override
    public String format(String pattern) {
        LocalDate date = this.getDate();
        return String.format(pattern, date);
    }

    public DaysSinceDate toDaysSinceYear(int year) {
        LocalDate date = this.getDate();
        return new DaysSinceDate(new Date(year, 1, 1), date);
    }

    @Override
    public int compareTo(Date that) {
        return this.getDate().compareTo(that.getDate());
    }

    public int hashCode() {
        return this.getDate().hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof Date) {
            Date that = (Date)object;
            return Objects.equals(this.getDate(), that.getDate());
        }
        return false;
    }

    public LocalDate getDate() {
        return this.date;
    }

    private void setDate(LocalDate date) {
        this.date = Objects.requireNonNull(date);
    }

    public static Date parse(String value) throws DateTimeParseException {
        return new Date(LocalDate.parse(value));
    }

    public static Date valueOf(Object value) {
        if (value instanceof LocalDate) {
            LocalDate localDate = (LocalDate)value;
            return new Date(localDate);
        }
        if (value instanceof LocalDateTime) {
            LocalDateTime localDateTime = (LocalDateTime)value;
            return new Date(localDateTime.toLocalDate());
        }
        throw new IllegalArgumentException();
    }
}

