/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocol;

import java.util.Arrays;
import javax.annotation.Nonnull;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.Path;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class ProvidedStorageLocation {
    private final Path path;
    private final long offset;
    private final long length;
    private final byte[] nonce;

    public ProvidedStorageLocation(Path path, long offset, long length, byte[] nonce) {
        this.path = path;
        this.offset = offset;
        this.length = length;
        this.nonce = Arrays.copyOf(nonce, nonce.length);
    }

    @Nonnull
    public Path getPath() {
        return this.path;
    }

    public long getOffset() {
        return this.offset;
    }

    public long getLength() {
        return this.length;
    }

    @Nonnull
    public byte[] getNonce() {
        return Arrays.copyOf(this.nonce, this.nonce.length);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProvidedStorageLocation that = (ProvidedStorageLocation)o;
        if (this.offset != that.offset || this.length != that.length || !this.path.equals(that.path)) {
            return false;
        }
        return Arrays.equals(this.nonce, that.nonce);
    }

    public int hashCode() {
        int result = this.path.hashCode();
        result = 31 * result + (int)(this.offset ^ this.offset >>> 32);
        result = 31 * result + (int)(this.length ^ this.length >>> 32);
        result = 31 * result + Arrays.hashCode(this.nonce);
        return result;
    }
}

