/*
 * Decompiled with CFR 0.152.
 */
package org.springmodules.cache.config;

import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.springmodules.cache.config.BeanReferenceParser;
import org.w3c.dom.Element;

public class BeanReferenceParserImpl
implements BeanReferenceParser {
    public Object parse(Element element, ParserContext parserContext) {
        return this.parse(element, parserContext, false);
    }

    public Object parse(Element element, ParserContext parserContext, boolean registerInnerBean) {
        String refId = element.getAttribute("refId");
        if (StringUtils.hasText((String)refId)) {
            return new RuntimeBeanReference(refId);
        }
        Element beanElement = null;
        List beanElements = DomUtils.getChildElementsByTagName((Element)element, (String)"bean");
        if (!CollectionUtils.isEmpty((Collection)beanElements)) {
            beanElement = (Element)beanElements.get(0);
        }
        if (beanElement == null) {
            throw new IllegalStateException("The XML element " + StringUtils.quote((String)element.getNodeName()) + " should either have a " + "reference to an already registered bean definition or contain a " + "bean definition");
        }
        BeanDefinitionHolder holder = parserContext.getDelegate().parseBeanDefinitionElement(beanElement, parserContext.getContainingBeanDefinition());
        String beanName = holder.getBeanName();
        if (registerInnerBean && StringUtils.hasText((String)beanName)) {
            BeanDefinitionRegistry registry = parserContext.getRegistry();
            BeanDefinition beanDefinition = holder.getBeanDefinition();
            registry.registerBeanDefinition(beanName, beanDefinition);
            return new RuntimeBeanReference(beanName);
        }
        return holder;
    }
}

