/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.ui.commons.markup.html.form;

import de.agilecoders.wicket.core.markup.html.bootstrap.components.PopoverBehavior;
import de.agilecoders.wicket.core.markup.html.bootstrap.components.PopoverConfig;
import de.agilecoders.wicket.core.markup.html.bootstrap.components.TooltipConfig;
import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.apache.commons.lang3.SerializationUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.client.ui.commons.markup.html.form.AbstractFieldPanel;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxCheckBoxPanel;
import org.apache.syncope.common.lib.Attr;
import org.apache.syncope.common.lib.Attributable;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.PageReference;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.ResourceModel;

public abstract class FieldPanel<T extends Serializable>
extends AbstractFieldPanel<T>
implements Cloneable {
    private static final long serialVersionUID = -198988924922541273L;
    protected FormComponent<T> field;
    protected String title;
    private final Model<Integer> index = Model.of((Serializable)Integer.valueOf(0));

    public FieldPanel(String id, IModel<T> model) {
        this(id, id, model);
    }

    public FieldPanel(String id, String name, IModel<T> model) {
        super(id, name, model);
    }

    public FormComponent<T> getField() {
        return this.field;
    }

    public FieldPanel<T> setPlaceholder(String id) {
        this.field.add(new Behavior[]{new AttributeModifier("placeholder", (IModel)new ResourceModel(id, id))});
        return this;
    }

    public FieldPanel<T> setTitle(String title) {
        return this.setTitle(title, false);
    }

    public FieldPanel<T> setTitle(String title, boolean html) {
        this.title = title;
        this.field.add(new Behavior[]{new PopoverBehavior((IModel)Model.of(), (IModel)Optional.ofNullable(title).map(Model::of).orElseGet(Model::of), new PopoverConfig().withHtml(html).withHoverTrigger().withPlacement((TooltipConfig.IPlacement)(this.index.getObject() != null && (Integer)this.index.getObject() == 0 ? TooltipConfig.Placement.bottom : (this instanceof AjaxCheckBoxPanel ? TooltipConfig.Placement.right : TooltipConfig.Placement.top))))});
        return this;
    }

    public FieldPanel<T> setStyleSheet(String ... classes) {
        return this.setStyleSheet(true, classes);
    }

    public FieldPanel<T> setStyleSheet(boolean replace, String ... classes) {
        if (replace) {
            this.field.add(new Behavior[]{AttributeModifier.replace((String)"class", (Serializable)((Object)StringUtils.join((Object[])classes, (char)' ')))});
        } else {
            this.field.add(new Behavior[]{AttributeModifier.append((String)"class", (Serializable)((Object)StringUtils.join((Object[])classes, (char)' ')))});
        }
        return this;
    }

    @Override
    public FieldPanel<T> setRequired(boolean required) {
        this.field.setRequired(required);
        return this;
    }

    @Override
    public FieldPanel<T> setReadOnly(boolean readOnly) {
        this.field.setEnabled(!readOnly);
        return this;
    }

    @Override
    public boolean isRequired() {
        return this.field.isRequired();
    }

    public boolean isReadOnly() {
        return !this.field.isEnabled();
    }

    @Override
    public FieldPanel<T> setModelObject(T object) {
        this.field.setModelObject(object);
        return this;
    }

    public T getModelObject() {
        return (T)((Serializable)this.field.getModelObject());
    }

    public FieldPanel<T> setNewModel(IModel<T> model) {
        this.field.setModel((IModel)(model == null ? new Model() : model));
        return this;
    }

    public FieldPanel<T> setNewModel(final Attributable attributable, final String schema) {
        this.field.setModel((IModel)new Model(){
            private static final long serialVersionUID = -4214654722524358000L;

            public Serializable getObject() {
                return attributable.getPlainAttr(schema).map(Attr::getValues).filter(Predicate.not(List::isEmpty)).map(values -> (String)values.get(0)).orElse(null);
            }

            public void setObject(Serializable object) {
                attributable.getPlainAttr(schema).ifPresent(plainAttr -> {
                    plainAttr.getValues().clear();
                    Optional.ofNullable(object).ifPresent(o -> plainAttr.getValues().add(o.toString()));
                });
            }
        });
        return this;
    }

    public FieldPanel<T> setNewModel(final ListItem item) {
        return this.setNewModel(new IModel(){
            private static final long serialVersionUID = 6799404673615637845L;

            public Object getObject() {
                return item.getModelObject();
            }

            public void setObject(Object object) {
                item.setModelObject(object);
            }

            public void detach() {
            }
        });
    }

    public FieldPanel<T> setNewModel(final List<Serializable> list) {
        return this.setNewModel((IModel<T>)new Model(){
            private static final long serialVersionUID = 1088212074765051906L;

            public Serializable getObject() {
                return list == null || list.isEmpty() ? null : (Serializable)list.get(0);
            }

            public void setObject(Serializable object) {
                list.clear();
                if (object != null) {
                    list.add(object);
                }
            }
        });
    }

    public FieldPanel<T> setIndex(int index) {
        this.index.setObject((Serializable)Integer.valueOf(index));
        return this;
    }

    public int getIndex() {
        return (Integer)this.index.getObject();
    }

    public FieldPanel<T> settingsDependingComponents() {
        return this;
    }

    public FieldPanel<T> clone() {
        FieldPanel panel = (FieldPanel)((Object)SerializationUtils.clone((Serializable)((Object)this)));
        panel.setModelObject((T)null);
        panel.addLabel();
        return panel;
    }

    protected PageReference getPageReference() {
        return null;
    }
}

