/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow.actions;

import lombok.Generated;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.principal.Response;
import org.apereo.cas.authentication.principal.ResponseBuilder;
import org.apereo.cas.authentication.principal.ResponseBuilderLocator;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.web.flow.actions.BaseCasWebflowAction;
import org.apereo.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.action.EventFactorySupport;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class RedirectToServiceAction
extends BaseCasWebflowAction {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(RedirectToServiceAction.class);
    private final ResponseBuilderLocator<WebApplicationService> responseBuilderLocator;

    protected Event doExecute(RequestContext requestContext) {
        WebApplicationService service = WebUtils.getService((RequestContext)requestContext);
        LOGGER.debug("Located service [{}] from the context", (Object)service);
        Authentication auth = WebUtils.getAuthentication((RequestContext)requestContext);
        LOGGER.debug("Located authentication [{}] from the context", (Object)auth);
        String serviceTicketId = WebUtils.getServiceTicketFromRequestScope((RequestContext)requestContext);
        LOGGER.debug("Located service ticket [{}] from the context", (Object)serviceTicketId);
        ResponseBuilder builder = this.responseBuilderLocator.locate(service);
        LOGGER.debug("Located service response builder [{}] for [{}]", (Object)builder, (Object)service);
        Response response = builder.build(service, serviceTicketId, auth);
        LOGGER.debug("Built response [{}] for [{}]", (Object)response, (Object)service);
        return this.finalizeResponseEvent(requestContext, service, response);
    }

    protected Event finalizeResponseEvent(RequestContext requestContext, WebApplicationService service, Response response) {
        WebUtils.putServiceResponseIntoRequestScope((RequestContext)requestContext, (Response)response);
        WebUtils.putServiceOriginalUrlIntoRequestScope((RequestContext)requestContext, (WebApplicationService)service);
        String eventId = this.getFinalResponseEventId(service, response, requestContext);
        return new EventFactorySupport().event((Object)this, eventId);
    }

    protected String getFinalResponseEventId(WebApplicationService service, Response response, RequestContext requestContext) {
        String eventId = response.getResponseType().name().toLowerCase();
        LOGGER.debug("Signaling flow to redirect to service [{}] via event [{}]", (Object)service, (Object)eventId);
        return eventId;
    }

    @Generated
    public RedirectToServiceAction(ResponseBuilderLocator<WebApplicationService> responseBuilderLocator) {
        this.responseBuilderLocator = responseBuilderLocator;
    }
}

