/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.wicket.markup.html.form;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.syncope.client.console.wicket.markup.html.form.Action;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionLink;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionPanel;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;

public final class ActionsPanel<T extends Serializable>
extends Panel {
    private static final long serialVersionUID = 322966537010107771L;
    private final List<Action<T>> actions = new ArrayList<Action<T>>();
    private IModel<T> model;

    public ActionsPanel(String componentId, IModel<T> model) {
        super(componentId, model);
        this.setOutputMarkupId(true);
        this.model = model;
        this.add(new Component[]{new ListView<Action<T>>("actionRepeater", this.actions){
            private static final long serialVersionUID = -9180479401817023838L;

            protected void populateItem(ListItem<Action<T>> item) {
                item.add(new Component[]{new ActionPanel(ActionsPanel.this.model, (Action)item.getModelObject())});
            }
        }.setRenderBodyOnly(true)});
    }

    public Action<T> add(ActionLink<T> link, ActionLink.ActionType type, String entitlements) {
        return this.add(link, type, entitlements, false);
    }

    public Action<T> add(ActionLink<T> link, ActionLink.ActionType type, String entitlements, boolean onConfirm) {
        Action<T> action = new Action<T>(link, type);
        action.setEntitlements(entitlements);
        action.setOnConfirm(onConfirm);
        this.actions.add(action);
        return action;
    }

    public Action<T> add(Action<T> action) {
        this.actions.add(action);
        return action;
    }

    public Action<T> add(int index, Action<T> action) {
        this.actions.add(index, action);
        return action;
    }

    public Action<T> set(int index, Action<T> action) {
        this.actions.set(index, action);
        return action;
    }

    public List<Action<T>> getActions() {
        return this.actions;
    }

    public ActionsPanel<T> clone(String componentId, IModel<T> model) {
        ActionsPanel<T> panel = new ActionsPanel<T>(componentId, model);
        panel.actions.addAll(this.actions);
        return panel;
    }

    public ActionsPanel<T> cloneWithLabels(String componentId, IModel<T> model) {
        ActionsPanel<T> panel = new ActionsPanel<T>(componentId, model);
        this.actions.forEach(action -> panel.actions.add(action.showLabel()));
        return panel;
    }

    public boolean isEmpty() {
        return this.actions.isEmpty();
    }
}

