/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.persistence.entity;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import org.flowable.engine.impl.persistence.entity.AbstractBpmnEngineEntity;
import org.flowable.engine.impl.persistence.entity.ActivityInstanceEntity;
import org.flowable.engine.impl.util.CommandContextUtil;

public class ActivityInstanceEntityImpl
extends AbstractBpmnEngineEntity
implements ActivityInstanceEntity,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String processInstanceId;
    protected String processDefinitionId;
    protected Date startTime;
    protected Date endTime;
    protected Long durationInMillis;
    protected Integer transactionOrder;
    protected String deleteReason;
    protected String activityId;
    protected String activityName;
    protected String activityType;
    protected String executionId;
    protected String assignee;
    protected String taskId;
    protected String calledProcessInstanceId;
    protected String tenantId = "";

    public Object getPersistentState() {
        HashMap<String, Object> persistentState = new HashMap<String, Object>();
        persistentState.put("endTime", this.endTime);
        persistentState.put("transactionOrder", this.transactionOrder);
        persistentState.put("durationInMillis", this.durationInMillis);
        persistentState.put("deleteReason", this.deleteReason);
        persistentState.put("executionId", this.executionId);
        persistentState.put("taskId", this.taskId);
        persistentState.put("assignee", this.assignee);
        persistentState.put("calledProcessInstanceId", this.calledProcessInstanceId);
        persistentState.put("activityId", this.activityId);
        persistentState.put("activityName", this.activityName);
        return persistentState;
    }

    @Override
    public void markEnded(String deleteReason) {
        if (this.endTime == null) {
            this.deleteReason = deleteReason;
            this.endTime = CommandContextUtil.getProcessEngineConfiguration().getClock().getCurrentTime();
            if (this.endTime != null && this.startTime != null) {
                this.durationInMillis = this.endTime.getTime() - this.startTime.getTime();
            }
        }
    }

    @Override
    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    @Override
    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    @Override
    public Date getStartTime() {
        return this.startTime;
    }

    @Override
    public Date getEndTime() {
        return this.endTime;
    }

    @Override
    public Long getDurationInMillis() {
        return this.durationInMillis;
    }

    @Override
    public void setProcessInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    @Override
    public void setProcessDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }

    @Override
    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    @Override
    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    @Override
    public void setDurationInMillis(Long durationInMillis) {
        this.durationInMillis = durationInMillis;
    }

    @Override
    public Integer getTransactionOrder() {
        return this.transactionOrder;
    }

    @Override
    public void setTransactionOrder(Integer transactionOrder) {
        this.transactionOrder = transactionOrder;
    }

    @Override
    public String getDeleteReason() {
        return this.deleteReason;
    }

    @Override
    public void setDeleteReason(String deleteReason) {
        this.deleteReason = deleteReason;
    }

    @Override
    public String getActivityId() {
        return this.activityId;
    }

    @Override
    public void setActivityId(String activityId) {
        this.activityId = activityId;
    }

    @Override
    public String getActivityName() {
        return this.activityName;
    }

    @Override
    public void setActivityName(String activityName) {
        this.activityName = activityName;
    }

    @Override
    public String getActivityType() {
        return this.activityType;
    }

    @Override
    public void setActivityType(String activityType) {
        this.activityType = activityType;
    }

    @Override
    public String getExecutionId() {
        return this.executionId;
    }

    @Override
    public void setExecutionId(String executionId) {
        this.executionId = executionId;
    }

    @Override
    public String getAssignee() {
        return this.assignee;
    }

    @Override
    public void setAssignee(String assignee) {
        this.assignee = assignee;
    }

    @Override
    public String getTaskId() {
        return this.taskId;
    }

    @Override
    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    @Override
    public String getCalledProcessInstanceId() {
        return this.calledProcessInstanceId;
    }

    @Override
    public void setCalledProcessInstanceId(String calledProcessInstanceId) {
        this.calledProcessInstanceId = calledProcessInstanceId;
    }

    @Override
    public String getTenantId() {
        return this.tenantId;
    }

    @Override
    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public Date getTime() {
        return this.getStartTime();
    }

    public String toString() {
        return "ActivityInstanceEntity[id=" + this.id + ", activityId=" + this.activityId + ", activityName=" + this.activityName + ", executionId= " + this.executionId + "]";
    }
}

