/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.common.struct;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public final class Version
implements Comparable<Version> {
    private final List<Integer> parts;
    private final String suffix;
    private final boolean snapshot;

    private Version(List<Integer> parts, String suffix, boolean snapshot) {
        this.parts = Objects.requireNonNull(parts);
        this.suffix = suffix;
        this.snapshot = snapshot;
    }

    public boolean isSnapshot() {
        return this.snapshot;
    }

    public boolean lowerThan(Version other) {
        return this.compareTo(other) < 0;
    }

    public boolean greaterThan(Version other) {
        return this.compareTo(other) > 0;
    }

    public String toString() {
        String v = this.parts.stream().map(Objects::toString).collect(Collectors.joining("."));
        if (this.suffix != null) {
            v = v + this.suffix;
        }
        if (this.snapshot) {
            v = v + "-SNAPSHOT";
        }
        return v;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Version version = (Version)o;
        return this.snapshot == version.snapshot && this.parts.equals(version.parts) && Objects.equals(this.suffix, version.suffix);
    }

    public int hashCode() {
        return Objects.hash(this.parts, this.suffix, this.snapshot);
    }

    @Override
    public int compareTo(Version other) {
        int c;
        if (this.equals(other)) {
            return 0;
        }
        int max = Math.min(this.parts.size(), other.parts.size());
        for (int i = 0; i < max; ++i) {
            if (this.parts.get(i) > other.parts.get(i)) {
                return 1;
            }
            if (this.parts.get(i) >= other.parts.get(i)) continue;
            return -1;
        }
        if (this.parts.size() > other.parts.size()) {
            return 1;
        }
        if (this.parts.size() < other.parts.size()) {
            return -1;
        }
        if (this.suffix != null && other.suffix == null) {
            return 1;
        }
        if (this.suffix == null && other.suffix != null) {
            return -1;
        }
        if (this.suffix != null && (c = this.suffix.compareTo(other.suffix)) != 0) {
            return c;
        }
        if (this.snapshot && other.snapshot) {
            return 0;
        }
        if (this.snapshot) {
            return -1;
        }
        return 1;
    }

    public static Version valueOf(String version) {
        int last;
        Objects.requireNonNull(version);
        ArrayList<Integer> parts = new ArrayList<Integer>(5);
        String suffix = null;
        boolean snapshot = false;
        if (version.endsWith("-SNAPSHOT")) {
            snapshot = true;
            version = version.substring(0, version.length() - 9);
        }
        int since = 0;
        while ((last = version.indexOf(46, since)) > 0) {
            try {
                parts.add(Integer.parseInt(version.substring(since, last)));
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(version, e);
            }
            since = last + 1;
        }
        try {
            parts.add(Integer.parseInt(version.substring(since)));
        }
        catch (NumberFormatException ignored) {
            int p = version.indexOf(45, since);
            if (p == -1) {
                suffix = "." + version.substring(since);
            }
            suffix = version.substring(p);
            try {
                parts.add(Integer.parseInt(version.substring(since, p)));
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(version, e);
            }
        }
        if (suffix != null && !suffix.matches("[-\\w.]+")) {
            throw new IllegalArgumentException(version);
        }
        if (parts.isEmpty()) {
            throw new IllegalArgumentException(version);
        }
        return new Version(parts, suffix, snapshot);
    }
}

