/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dynamic_config.api.model;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;

public class RawPath {
    private final String value;
    private volatile transient Path cache;

    public static RawPath valueOf(String value) {
        return new RawPath(value);
    }

    private RawPath(String value) {
        this.value = Objects.requireNonNull(value);
    }

    public String getValue() {
        return this.value;
    }

    public Path toPath() {
        if (this.cache == null) {
            this.cache = Paths.get(this.value, new String[0]);
        }
        return this.cache;
    }

    public String toString() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RawPath)) {
            return false;
        }
        RawPath paths = (RawPath)o;
        return this.getValue().equals(paths.getValue());
    }

    public int hashCode() {
        return Objects.hash(this.getValue());
    }

    public RawPath append(String segments) {
        return RawPath.valueOf(this.value + segments);
    }
}

