/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.runnel.utils;

import java.nio.ByteBuffer;
import org.terracotta.runnel.utils.VLQ;

public class WriteBuffer {
    private final ByteBuffer byteBuffer;

    public WriteBuffer(ByteBuffer byteBuffer) {
        this.byteBuffer = byteBuffer;
    }

    public void putBoolean(boolean value) {
        this.byteBuffer.put(value ? (byte)1 : 0);
    }

    public void putChar(char value) {
        this.byteBuffer.putChar(value);
    }

    public void putDouble(double value) {
        this.byteBuffer.putDouble(value);
    }

    public void putLong(long value) {
        this.byteBuffer.putLong(value);
    }

    public void putInt(int value) {
        this.byteBuffer.putInt(value);
    }

    public void putVlqInt(int value) {
        VLQ.encode(value, this.byteBuffer);
    }

    public void putByteBuffer(ByteBuffer buffer) {
        this.byteBuffer.put(buffer);
    }
}

