/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.pac4j.serialization;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;
import lombok.Generated;
import org.apereo.cas.util.EncodingUtils;
import org.apereo.cas.util.serialization.SerializationUtils;
import org.pac4j.core.profile.CommonProfile;
import org.pac4j.oidc.profile.OidcProfile;

public class DelegatedClientJacksonModule
extends SimpleModule {
    private static final long serialVersionUID = 4380897174293794761L;

    public DelegatedClientJacksonModule() {
        this.addSerializer(OidcProfile.class, new CommonProfileSerializer<OidcProfile>(OidcProfile.class));
    }

    private static class CommonProfileSerializer<T extends CommonProfile>
    extends JsonSerializer<T> {
        private final Class<T> typeToHandle;

        private void serialize(T value, JsonGenerator gen) throws IOException {
            String profile = EncodingUtils.encodeBase64((byte[])SerializationUtils.serialize(value));
            gen.writeString(profile);
        }

        public void serialize(T value, JsonGenerator gen, SerializerProvider serializerProvider) throws IOException {
            this.serialize(value, gen);
        }

        public void serializeWithType(T value, JsonGenerator gen, SerializerProvider serializers, TypeSerializer typeSer) throws IOException {
            this.serialize(value, gen);
        }

        public Class<T> handledType() {
            return this.typeToHandle;
        }

        @Generated
        public CommonProfileSerializer(Class<T> typeToHandle) {
            this.typeToHandle = typeToHandle;
        }
    }
}

